/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateTagValueMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagValueRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagValueMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagValueRequest;
import com.google.cloud.resourcemanager.v3.GetNamespacedTagValueRequest;
import com.google.cloud.resourcemanager.v3.GetTagValueRequest;
import com.google.cloud.resourcemanager.v3.ListTagValuesRequest;
import com.google.cloud.resourcemanager.v3.ListTagValuesResponse;
import com.google.cloud.resourcemanager.v3.TagValue;
import com.google.cloud.resourcemanager.v3.TagValuesClient;
import com.google.cloud.resourcemanager.v3.UpdateTagValueMetadata;
import com.google.cloud.resourcemanager.v3.UpdateTagValueRequest;
import com.google.cloud.resourcemanager.v3.stub.GrpcTagValuesStub;
import com.google.cloud.resourcemanager.v3.stub.HttpJsonTagValuesStub;
import com.google.cloud.resourcemanager.v3.stub.TagValuesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TagValuesStubSettings
extends StubSettings<TagValuesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final PagedCallSettings<ListTagValuesRequest, ListTagValuesResponse, TagValuesClient.ListTagValuesPagedResponse> listTagValuesSettings;
    private final UnaryCallSettings<GetTagValueRequest, TagValue> getTagValueSettings;
    private final UnaryCallSettings<GetNamespacedTagValueRequest, TagValue> getNamespacedTagValueSettings;
    private final UnaryCallSettings<CreateTagValueRequest, Operation> createTagValueSettings;
    private final OperationCallSettings<CreateTagValueRequest, TagValue, CreateTagValueMetadata> createTagValueOperationSettings;
    private final UnaryCallSettings<UpdateTagValueRequest, Operation> updateTagValueSettings;
    private final OperationCallSettings<UpdateTagValueRequest, TagValue, UpdateTagValueMetadata> updateTagValueOperationSettings;
    private final UnaryCallSettings<DeleteTagValueRequest, Operation> deleteTagValueSettings;
    private final OperationCallSettings<DeleteTagValueRequest, TagValue, DeleteTagValueMetadata> deleteTagValueOperationSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListTagValuesRequest, ListTagValuesResponse, TagValue> LIST_TAG_VALUES_PAGE_STR_DESC = new PagedListDescriptor<ListTagValuesRequest, ListTagValuesResponse, TagValue>(){

        public String emptyToken() {
            return "";
        }

        public ListTagValuesRequest injectToken(ListTagValuesRequest payload, String token) {
            return ListTagValuesRequest.newBuilder((ListTagValuesRequest)payload).setPageToken(token).build();
        }

        public ListTagValuesRequest injectPageSize(ListTagValuesRequest payload, int pageSize) {
            return ListTagValuesRequest.newBuilder((ListTagValuesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTagValuesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTagValuesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TagValue> extractResources(ListTagValuesResponse payload) {
            return payload.getTagValuesList() == null ? ImmutableList.of() : payload.getTagValuesList();
        }
    };
    private static final PagedListResponseFactory<ListTagValuesRequest, ListTagValuesResponse, TagValuesClient.ListTagValuesPagedResponse> LIST_TAG_VALUES_PAGE_STR_FACT = new PagedListResponseFactory<ListTagValuesRequest, ListTagValuesResponse, TagValuesClient.ListTagValuesPagedResponse>(){

        public ApiFuture<TagValuesClient.ListTagValuesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTagValuesRequest, ListTagValuesResponse> callable, ListTagValuesRequest request, ApiCallContext context, ApiFuture<ListTagValuesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TAG_VALUES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TagValuesClient.ListTagValuesPagedResponse.createAsync((PageContext<ListTagValuesRequest, ListTagValuesResponse, TagValue>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListTagValuesRequest, ListTagValuesResponse, TagValuesClient.ListTagValuesPagedResponse> listTagValuesSettings() {
        return this.listTagValuesSettings;
    }

    public UnaryCallSettings<GetTagValueRequest, TagValue> getTagValueSettings() {
        return this.getTagValueSettings;
    }

    public UnaryCallSettings<GetNamespacedTagValueRequest, TagValue> getNamespacedTagValueSettings() {
        return this.getNamespacedTagValueSettings;
    }

    public UnaryCallSettings<CreateTagValueRequest, Operation> createTagValueSettings() {
        return this.createTagValueSettings;
    }

    public OperationCallSettings<CreateTagValueRequest, TagValue, CreateTagValueMetadata> createTagValueOperationSettings() {
        return this.createTagValueOperationSettings;
    }

    public UnaryCallSettings<UpdateTagValueRequest, Operation> updateTagValueSettings() {
        return this.updateTagValueSettings;
    }

    public OperationCallSettings<UpdateTagValueRequest, TagValue, UpdateTagValueMetadata> updateTagValueOperationSettings() {
        return this.updateTagValueOperationSettings;
    }

    public UnaryCallSettings<DeleteTagValueRequest, Operation> deleteTagValueSettings() {
        return this.deleteTagValueSettings;
    }

    public OperationCallSettings<DeleteTagValueRequest, TagValue, DeleteTagValueMetadata> deleteTagValueOperationSettings() {
        return this.deleteTagValueOperationSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public TagValuesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTagValuesStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTagValuesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return TagValuesStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "cloudresourcemanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudresourcemanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudresourcemanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TagValuesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TagValuesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TagValuesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return TagValuesStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TagValuesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listTagValuesSettings = settingsBuilder.listTagValuesSettings().build();
        this.getTagValueSettings = settingsBuilder.getTagValueSettings().build();
        this.getNamespacedTagValueSettings = settingsBuilder.getNamespacedTagValueSettings().build();
        this.createTagValueSettings = settingsBuilder.createTagValueSettings().build();
        this.createTagValueOperationSettings = settingsBuilder.createTagValueOperationSettings().build();
        this.updateTagValueSettings = settingsBuilder.updateTagValueSettings().build();
        this.updateTagValueOperationSettings = settingsBuilder.updateTagValueOperationSettings().build();
        this.deleteTagValueSettings = settingsBuilder.deleteTagValueSettings().build();
        this.deleteTagValueOperationSettings = settingsBuilder.deleteTagValueOperationSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TagValuesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListTagValuesRequest, ListTagValuesResponse, TagValuesClient.ListTagValuesPagedResponse> listTagValuesSettings;
        private final UnaryCallSettings.Builder<GetTagValueRequest, TagValue> getTagValueSettings;
        private final UnaryCallSettings.Builder<GetNamespacedTagValueRequest, TagValue> getNamespacedTagValueSettings;
        private final UnaryCallSettings.Builder<CreateTagValueRequest, Operation> createTagValueSettings;
        private final OperationCallSettings.Builder<CreateTagValueRequest, TagValue, CreateTagValueMetadata> createTagValueOperationSettings;
        private final UnaryCallSettings.Builder<UpdateTagValueRequest, Operation> updateTagValueSettings;
        private final OperationCallSettings.Builder<UpdateTagValueRequest, TagValue, UpdateTagValueMetadata> updateTagValueOperationSettings;
        private final UnaryCallSettings.Builder<DeleteTagValueRequest, Operation> deleteTagValueSettings;
        private final OperationCallSettings.Builder<DeleteTagValueRequest, TagValue, DeleteTagValueMetadata> deleteTagValueOperationSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listTagValuesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TAG_VALUES_PAGE_STR_FACT);
            this.getTagValueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getNamespacedTagValueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTagValueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTagValueOperationSettings = OperationCallSettings.newBuilder();
            this.updateTagValueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTagValueOperationSettings = OperationCallSettings.newBuilder();
            this.deleteTagValueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTagValueOperationSettings = OperationCallSettings.newBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listTagValuesSettings, this.getTagValueSettings, this.getNamespacedTagValueSettings, this.createTagValueSettings, this.updateTagValueSettings, this.deleteTagValueSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TagValuesStubSettings settings) {
            super((StubSettings)settings);
            this.listTagValuesSettings = settings.listTagValuesSettings.toBuilder();
            this.getTagValueSettings = settings.getTagValueSettings.toBuilder();
            this.getNamespacedTagValueSettings = settings.getNamespacedTagValueSettings.toBuilder();
            this.createTagValueSettings = settings.createTagValueSettings.toBuilder();
            this.createTagValueOperationSettings = settings.createTagValueOperationSettings.toBuilder();
            this.updateTagValueSettings = settings.updateTagValueSettings.toBuilder();
            this.updateTagValueOperationSettings = settings.updateTagValueOperationSettings.toBuilder();
            this.deleteTagValueSettings = settings.deleteTagValueSettings.toBuilder();
            this.deleteTagValueOperationSettings = settings.deleteTagValueOperationSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listTagValuesSettings, this.getTagValueSettings, this.getNamespacedTagValueSettings, this.createTagValueSettings, this.updateTagValueSettings, this.deleteTagValueSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TagValuesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TagValuesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TagValuesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TagValuesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)TagValuesStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)TagValuesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TagValuesStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TagValuesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listTagValuesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTagValueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getNamespacedTagValueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTagValueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateTagValueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteTagValueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTagValueOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TagValue.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateTagValueMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateTagValueOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TagValue.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateTagValueMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTagValueOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TagValue.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteTagValueMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListTagValuesRequest, ListTagValuesResponse, TagValuesClient.ListTagValuesPagedResponse> listTagValuesSettings() {
            return this.listTagValuesSettings;
        }

        public UnaryCallSettings.Builder<GetTagValueRequest, TagValue> getTagValueSettings() {
            return this.getTagValueSettings;
        }

        public UnaryCallSettings.Builder<GetNamespacedTagValueRequest, TagValue> getNamespacedTagValueSettings() {
            return this.getNamespacedTagValueSettings;
        }

        public UnaryCallSettings.Builder<CreateTagValueRequest, Operation> createTagValueSettings() {
            return this.createTagValueSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateTagValueRequest, TagValue, CreateTagValueMetadata> createTagValueOperationSettings() {
            return this.createTagValueOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateTagValueRequest, Operation> updateTagValueSettings() {
            return this.updateTagValueSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateTagValueRequest, TagValue, UpdateTagValueMetadata> updateTagValueOperationSettings() {
            return this.updateTagValueOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteTagValueRequest, Operation> deleteTagValueSettings() {
            return this.deleteTagValueSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTagValueRequest, TagValue, DeleteTagValueMetadata> deleteTagValueOperationSettings() {
            return this.deleteTagValueOperationSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return TagValuesStubSettings.getDefaultEndpoint();
        }

        public TagValuesStubSettings build() throws IOException {
            return new TagValuesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

