/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateTagHoldMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagHoldRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagHoldMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagHoldRequest;
import com.google.cloud.resourcemanager.v3.ListTagHoldsRequest;
import com.google.cloud.resourcemanager.v3.ListTagHoldsResponse;
import com.google.cloud.resourcemanager.v3.TagHold;
import com.google.cloud.resourcemanager.v3.TagHoldsClient;
import com.google.cloud.resourcemanager.v3.stub.HttpJsonTagHoldsCallableFactory;
import com.google.cloud.resourcemanager.v3.stub.TagHoldsStub;
import com.google.cloud.resourcemanager.v3.stub.TagHoldsStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonTagHoldsStub
extends TagHoldsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(CreateTagHoldMetadata.getDescriptor()).add(TagHold.getDescriptor()).add(DeleteTagHoldMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateTagHoldRequest, Operation> createTagHoldMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagHolds/CreateTagHold").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=tagValues/*}/tagHolds", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("tagHold", (Message)request.getTagHold(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteTagHoldRequest, Operation> deleteTagHoldMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagHolds/DeleteTagHold").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=tagValues/*/tagHolds/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListTagHoldsRequest, ListTagHoldsResponse> listTagHoldsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagHolds/ListTagHolds").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=tagValues/*}/tagHolds", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTagHoldsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateTagHoldRequest, Operation> createTagHoldCallable;
    private final OperationCallable<CreateTagHoldRequest, TagHold, CreateTagHoldMetadata> createTagHoldOperationCallable;
    private final UnaryCallable<DeleteTagHoldRequest, Operation> deleteTagHoldCallable;
    private final OperationCallable<DeleteTagHoldRequest, Empty, DeleteTagHoldMetadata> deleteTagHoldOperationCallable;
    private final UnaryCallable<ListTagHoldsRequest, ListTagHoldsResponse> listTagHoldsCallable;
    private final UnaryCallable<ListTagHoldsRequest, TagHoldsClient.ListTagHoldsPagedResponse> listTagHoldsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTagHoldsStub create(TagHoldsStubSettings settings) throws IOException {
        return new HttpJsonTagHoldsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTagHoldsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTagHoldsStub(TagHoldsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonTagHoldsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTagHoldsStub(TagHoldsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTagHoldsStub(TagHoldsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTagHoldsCallableFactory());
    }

    protected HttpJsonTagHoldsStub(TagHoldsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v3/{name=operations/**}").build()).build());
        HttpJsonCallSettings createTagHoldTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createTagHoldMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteTagHoldTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteTagHoldMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listTagHoldsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTagHoldsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createTagHoldCallable = callableFactory.createUnaryCallable(createTagHoldTransportSettings, settings.createTagHoldSettings(), clientContext);
        this.createTagHoldOperationCallable = callableFactory.createOperationCallable(createTagHoldTransportSettings, settings.createTagHoldOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteTagHoldCallable = callableFactory.createUnaryCallable(deleteTagHoldTransportSettings, settings.deleteTagHoldSettings(), clientContext);
        this.deleteTagHoldOperationCallable = callableFactory.createOperationCallable(deleteTagHoldTransportSettings, settings.deleteTagHoldOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listTagHoldsCallable = callableFactory.createUnaryCallable(listTagHoldsTransportSettings, settings.listTagHoldsSettings(), clientContext);
        this.listTagHoldsPagedCallable = callableFactory.createPagedCallable(listTagHoldsTransportSettings, settings.listTagHoldsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createTagHoldMethodDescriptor);
        methodDescriptors.add(deleteTagHoldMethodDescriptor);
        methodDescriptors.add(listTagHoldsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateTagHoldRequest, Operation> createTagHoldCallable() {
        return this.createTagHoldCallable;
    }

    @Override
    public OperationCallable<CreateTagHoldRequest, TagHold, CreateTagHoldMetadata> createTagHoldOperationCallable() {
        return this.createTagHoldOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteTagHoldRequest, Operation> deleteTagHoldCallable() {
        return this.deleteTagHoldCallable;
    }

    @Override
    public OperationCallable<DeleteTagHoldRequest, Empty, DeleteTagHoldMetadata> deleteTagHoldOperationCallable() {
        return this.deleteTagHoldOperationCallable;
    }

    @Override
    public UnaryCallable<ListTagHoldsRequest, ListTagHoldsResponse> listTagHoldsCallable() {
        return this.listTagHoldsCallable;
    }

    @Override
    public UnaryCallable<ListTagHoldsRequest, TagHoldsClient.ListTagHoldsPagedResponse> listTagHoldsPagedCallable() {
        return this.listTagHoldsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

