/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.resourcemanager.v3.CreateProjectMetadata;
import com.google.cloud.resourcemanager.v3.CreateProjectRequest;
import com.google.cloud.resourcemanager.v3.DeleteProjectMetadata;
import com.google.cloud.resourcemanager.v3.DeleteProjectRequest;
import com.google.cloud.resourcemanager.v3.GetProjectRequest;
import com.google.cloud.resourcemanager.v3.ListProjectsRequest;
import com.google.cloud.resourcemanager.v3.ListProjectsResponse;
import com.google.cloud.resourcemanager.v3.MoveProjectMetadata;
import com.google.cloud.resourcemanager.v3.MoveProjectRequest;
import com.google.cloud.resourcemanager.v3.Project;
import com.google.cloud.resourcemanager.v3.ProjectName;
import com.google.cloud.resourcemanager.v3.ProjectsSettings;
import com.google.cloud.resourcemanager.v3.SearchProjectsRequest;
import com.google.cloud.resourcemanager.v3.SearchProjectsResponse;
import com.google.cloud.resourcemanager.v3.UndeleteProjectMetadata;
import com.google.cloud.resourcemanager.v3.UndeleteProjectRequest;
import com.google.cloud.resourcemanager.v3.UpdateProjectMetadata;
import com.google.cloud.resourcemanager.v3.UpdateProjectRequest;
import com.google.cloud.resourcemanager.v3.stub.ProjectsStub;
import com.google.cloud.resourcemanager.v3.stub.ProjectsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ProjectsClient
implements BackgroundResource {
    private final ProjectsSettings settings;
    private final ProjectsStub stub;
    private final OperationsClient operationsClient;

    public static final ProjectsClient create() throws IOException {
        return ProjectsClient.create(ProjectsSettings.newBuilder().build());
    }

    public static final ProjectsClient create(ProjectsSettings settings) throws IOException {
        return new ProjectsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ProjectsClient create(ProjectsStub stub) {
        return new ProjectsClient(stub);
    }

    protected ProjectsClient(ProjectsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProjectsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ProjectsClient(ProjectsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ProjectsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProjectsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Project getProject(ProjectName name) {
        GetProjectRequest request = GetProjectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProject(request);
    }

    public final Project getProject(String name) {
        GetProjectRequest request = GetProjectRequest.newBuilder().setName(name).build();
        return this.getProject(request);
    }

    public final Project getProject(GetProjectRequest request) {
        return (Project)this.getProjectCallable().call((Object)request);
    }

    public final UnaryCallable<GetProjectRequest, Project> getProjectCallable() {
        return this.stub.getProjectCallable();
    }

    public final ListProjectsPagedResponse listProjects(ResourceName parent) {
        ListProjectsRequest request = ListProjectsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProjects(request);
    }

    public final ListProjectsPagedResponse listProjects(String parent) {
        ListProjectsRequest request = ListProjectsRequest.newBuilder().setParent(parent).build();
        return this.listProjects(request);
    }

    public final ListProjectsPagedResponse listProjects(ListProjectsRequest request) {
        return (ListProjectsPagedResponse)((Object)this.listProjectsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProjectsRequest, ListProjectsPagedResponse> listProjectsPagedCallable() {
        return this.stub.listProjectsPagedCallable();
    }

    public final UnaryCallable<ListProjectsRequest, ListProjectsResponse> listProjectsCallable() {
        return this.stub.listProjectsCallable();
    }

    public final SearchProjectsPagedResponse searchProjects(String query) {
        SearchProjectsRequest request = SearchProjectsRequest.newBuilder().setQuery(query).build();
        return this.searchProjects(request);
    }

    public final SearchProjectsPagedResponse searchProjects(SearchProjectsRequest request) {
        return (SearchProjectsPagedResponse)((Object)this.searchProjectsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchProjectsRequest, SearchProjectsPagedResponse> searchProjectsPagedCallable() {
        return this.stub.searchProjectsPagedCallable();
    }

    public final UnaryCallable<SearchProjectsRequest, SearchProjectsResponse> searchProjectsCallable() {
        return this.stub.searchProjectsCallable();
    }

    public final OperationFuture<Project, CreateProjectMetadata> createProjectAsync(Project project) {
        CreateProjectRequest request = CreateProjectRequest.newBuilder().setProject(project).build();
        return this.createProjectAsync(request);
    }

    public final OperationFuture<Project, CreateProjectMetadata> createProjectAsync(CreateProjectRequest request) {
        return this.createProjectOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateProjectRequest, Project, CreateProjectMetadata> createProjectOperationCallable() {
        return this.stub.createProjectOperationCallable();
    }

    public final UnaryCallable<CreateProjectRequest, Operation> createProjectCallable() {
        return this.stub.createProjectCallable();
    }

    public final OperationFuture<Project, UpdateProjectMetadata> updateProjectAsync(Project project, FieldMask updateMask) {
        UpdateProjectRequest request = UpdateProjectRequest.newBuilder().setProject(project).setUpdateMask(updateMask).build();
        return this.updateProjectAsync(request);
    }

    public final OperationFuture<Project, UpdateProjectMetadata> updateProjectAsync(UpdateProjectRequest request) {
        return this.updateProjectOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateProjectRequest, Project, UpdateProjectMetadata> updateProjectOperationCallable() {
        return this.stub.updateProjectOperationCallable();
    }

    public final UnaryCallable<UpdateProjectRequest, Operation> updateProjectCallable() {
        return this.stub.updateProjectCallable();
    }

    public final OperationFuture<Project, MoveProjectMetadata> moveProjectAsync(ProjectName name, ResourceName destinationParent) {
        MoveProjectRequest request = MoveProjectRequest.newBuilder().setName(name == null ? null : name.toString()).setDestinationParent(destinationParent == null ? null : destinationParent.toString()).build();
        return this.moveProjectAsync(request);
    }

    public final OperationFuture<Project, MoveProjectMetadata> moveProjectAsync(ProjectName name, String destinationParent) {
        MoveProjectRequest request = MoveProjectRequest.newBuilder().setName(name == null ? null : name.toString()).setDestinationParent(destinationParent).build();
        return this.moveProjectAsync(request);
    }

    public final OperationFuture<Project, MoveProjectMetadata> moveProjectAsync(String name, ResourceName destinationParent) {
        MoveProjectRequest request = MoveProjectRequest.newBuilder().setName(name).setDestinationParent(destinationParent == null ? null : destinationParent.toString()).build();
        return this.moveProjectAsync(request);
    }

    public final OperationFuture<Project, MoveProjectMetadata> moveProjectAsync(String name, String destinationParent) {
        MoveProjectRequest request = MoveProjectRequest.newBuilder().setName(name).setDestinationParent(destinationParent).build();
        return this.moveProjectAsync(request);
    }

    public final OperationFuture<Project, MoveProjectMetadata> moveProjectAsync(MoveProjectRequest request) {
        return this.moveProjectOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<MoveProjectRequest, Project, MoveProjectMetadata> moveProjectOperationCallable() {
        return this.stub.moveProjectOperationCallable();
    }

    public final UnaryCallable<MoveProjectRequest, Operation> moveProjectCallable() {
        return this.stub.moveProjectCallable();
    }

    public final OperationFuture<Project, DeleteProjectMetadata> deleteProjectAsync(ProjectName name) {
        DeleteProjectRequest request = DeleteProjectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteProjectAsync(request);
    }

    public final OperationFuture<Project, DeleteProjectMetadata> deleteProjectAsync(String name) {
        DeleteProjectRequest request = DeleteProjectRequest.newBuilder().setName(name).build();
        return this.deleteProjectAsync(request);
    }

    public final OperationFuture<Project, DeleteProjectMetadata> deleteProjectAsync(DeleteProjectRequest request) {
        return this.deleteProjectOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteProjectRequest, Project, DeleteProjectMetadata> deleteProjectOperationCallable() {
        return this.stub.deleteProjectOperationCallable();
    }

    public final UnaryCallable<DeleteProjectRequest, Operation> deleteProjectCallable() {
        return this.stub.deleteProjectCallable();
    }

    public final OperationFuture<Project, UndeleteProjectMetadata> undeleteProjectAsync(ProjectName name) {
        UndeleteProjectRequest request = UndeleteProjectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeleteProjectAsync(request);
    }

    public final OperationFuture<Project, UndeleteProjectMetadata> undeleteProjectAsync(String name) {
        UndeleteProjectRequest request = UndeleteProjectRequest.newBuilder().setName(name).build();
        return this.undeleteProjectAsync(request);
    }

    public final OperationFuture<Project, UndeleteProjectMetadata> undeleteProjectAsync(UndeleteProjectRequest request) {
        return this.undeleteProjectOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeleteProjectRequest, Project, UndeleteProjectMetadata> undeleteProjectOperationCallable() {
        return this.stub.undeleteProjectOperationCallable();
    }

    public final UnaryCallable<UndeleteProjectRequest, Operation> undeleteProjectCallable() {
        return this.stub.undeleteProjectCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchProjectsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchProjectsRequest, SearchProjectsResponse, Project, SearchProjectsPage, SearchProjectsFixedSizeCollection> {
        private SearchProjectsFixedSizeCollection(List<SearchProjectsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchProjectsFixedSizeCollection createEmptyCollection() {
            return new SearchProjectsFixedSizeCollection(null, 0);
        }

        protected SearchProjectsFixedSizeCollection createCollection(List<SearchProjectsPage> pages, int collectionSize) {
            return new SearchProjectsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchProjectsPage
    extends AbstractPage<SearchProjectsRequest, SearchProjectsResponse, Project, SearchProjectsPage> {
        private SearchProjectsPage(PageContext<SearchProjectsRequest, SearchProjectsResponse, Project> context, SearchProjectsResponse response) {
            super(context, (Object)response);
        }

        private static SearchProjectsPage createEmptyPage() {
            return new SearchProjectsPage(null, null);
        }

        protected SearchProjectsPage createPage(PageContext<SearchProjectsRequest, SearchProjectsResponse, Project> context, SearchProjectsResponse response) {
            return new SearchProjectsPage(context, response);
        }

        public ApiFuture<SearchProjectsPage> createPageAsync(PageContext<SearchProjectsRequest, SearchProjectsResponse, Project> context, ApiFuture<SearchProjectsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchProjectsPagedResponse
    extends AbstractPagedListResponse<SearchProjectsRequest, SearchProjectsResponse, Project, SearchProjectsPage, SearchProjectsFixedSizeCollection> {
        public static ApiFuture<SearchProjectsPagedResponse> createAsync(PageContext<SearchProjectsRequest, SearchProjectsResponse, Project> context, ApiFuture<SearchProjectsResponse> futureResponse) {
            ApiFuture<SearchProjectsPage> futurePage = SearchProjectsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchProjectsPage, SearchProjectsPagedResponse>(){

                public SearchProjectsPagedResponse apply(SearchProjectsPage input) {
                    return new SearchProjectsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchProjectsPagedResponse(SearchProjectsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchProjectsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProjectsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProjectsRequest, ListProjectsResponse, Project, ListProjectsPage, ListProjectsFixedSizeCollection> {
        private ListProjectsFixedSizeCollection(List<ListProjectsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProjectsFixedSizeCollection createEmptyCollection() {
            return new ListProjectsFixedSizeCollection(null, 0);
        }

        protected ListProjectsFixedSizeCollection createCollection(List<ListProjectsPage> pages, int collectionSize) {
            return new ListProjectsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProjectsPage
    extends AbstractPage<ListProjectsRequest, ListProjectsResponse, Project, ListProjectsPage> {
        private ListProjectsPage(PageContext<ListProjectsRequest, ListProjectsResponse, Project> context, ListProjectsResponse response) {
            super(context, (Object)response);
        }

        private static ListProjectsPage createEmptyPage() {
            return new ListProjectsPage(null, null);
        }

        protected ListProjectsPage createPage(PageContext<ListProjectsRequest, ListProjectsResponse, Project> context, ListProjectsResponse response) {
            return new ListProjectsPage(context, response);
        }

        public ApiFuture<ListProjectsPage> createPageAsync(PageContext<ListProjectsRequest, ListProjectsResponse, Project> context, ApiFuture<ListProjectsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProjectsPagedResponse
    extends AbstractPagedListResponse<ListProjectsRequest, ListProjectsResponse, Project, ListProjectsPage, ListProjectsFixedSizeCollection> {
        public static ApiFuture<ListProjectsPagedResponse> createAsync(PageContext<ListProjectsRequest, ListProjectsResponse, Project> context, ApiFuture<ListProjectsResponse> futureResponse) {
            ApiFuture<ListProjectsPage> futurePage = ListProjectsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListProjectsPage, ListProjectsPagedResponse>(){

                public ListProjectsPagedResponse apply(ListProjectsPage input) {
                    return new ListProjectsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListProjectsPagedResponse(ListProjectsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProjectsFixedSizeCollection.createEmptyCollection());
        }
    }
}

