/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.spi.v1beta1;

import com.google.api.services.cloudresourcemanager.model.Constraint;
import com.google.api.services.cloudresourcemanager.model.OrgPolicy;
import com.google.api.services.cloudresourcemanager.model.Policy;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.cloud.ServiceRpc;
import com.google.cloud.Tuple;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface ResourceManagerRpc
extends ServiceRpc {
    public Project create(Project var1);

    public void delete(String var1);

    public Project get(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<Project>> list(Map<Option, ?> var1);

    public void undelete(String var1);

    public Project replace(Project var1);

    public Policy getPolicy(String var1);

    public Policy replacePolicy(String var1, Policy var2);

    public List<Boolean> testPermissions(String var1, List<String> var2);

    public Map<String, Boolean> testOrgPermissions(String var1, List<String> var2) throws IOException;

    public void clearOrgPolicy(String var1, OrgPolicy var2) throws IOException;

    public OrgPolicy getEffectiveOrgPolicy(String var1, String var2) throws IOException;

    public OrgPolicy getOrgPolicy(String var1, String var2) throws IOException;

    public ListResult<Constraint> listAvailableOrgPolicyConstraints(String var1, Map<Option, ?> var2) throws IOException;

    public ListResult<OrgPolicy> listOrgPolicies(String var1, Map<Option, ?> var2) throws IOException;

    public OrgPolicy replaceOrgPolicy(String var1, OrgPolicy var2) throws IOException;

    public static class ListResult<T> {
        private final Iterable<T> results;
        private final String pageToken;

        ListResult(String pageToken, Iterable<T> results) {
            this.results = ImmutableList.copyOf(results);
            this.pageToken = pageToken;
        }

        public static <T> ListResult<T> of(String pageToken, Iterable<T> list) {
            return new ListResult<T>(pageToken, list);
        }

        public Iterable<T> results() {
            return this.results;
        }

        public String pageToken() {
            return this.pageToken;
        }
    }

    public static enum Option {
        FILTER("filter"),
        FIELDS("fields"),
        PAGE_SIZE("pageSize"),
        PAGE_TOKEN("pageToken");

        private final String value;

        private Option(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        <T> T get(Map<Option, ?> options) {
            return (T)options.get((Object)this);
        }

        String getString(Map<Option, ?> options) {
            return (String)this.get(options);
        }

        Integer getInt(Map<Option, ?> options) {
            return (Integer)this.get(options);
        }
    }
}

