/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recommender.v1.GetInsightRequest;
import com.google.cloud.recommender.v1.GetInsightTypeConfigRequest;
import com.google.cloud.recommender.v1.GetRecommendationRequest;
import com.google.cloud.recommender.v1.GetRecommenderConfigRequest;
import com.google.cloud.recommender.v1.Insight;
import com.google.cloud.recommender.v1.InsightTypeConfig;
import com.google.cloud.recommender.v1.ListInsightsRequest;
import com.google.cloud.recommender.v1.ListInsightsResponse;
import com.google.cloud.recommender.v1.ListRecommendationsRequest;
import com.google.cloud.recommender.v1.ListRecommendationsResponse;
import com.google.cloud.recommender.v1.MarkInsightAcceptedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationClaimedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationDismissedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationFailedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationSucceededRequest;
import com.google.cloud.recommender.v1.Recommendation;
import com.google.cloud.recommender.v1.RecommenderClient;
import com.google.cloud.recommender.v1.RecommenderConfig;
import com.google.cloud.recommender.v1.UpdateInsightTypeConfigRequest;
import com.google.cloud.recommender.v1.UpdateRecommenderConfigRequest;
import com.google.cloud.recommender.v1.stub.GrpcRecommenderCallableFactory;
import com.google.cloud.recommender.v1.stub.RecommenderStub;
import com.google.cloud.recommender.v1.stub.RecommenderStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcRecommenderStub
extends RecommenderStub {
    private static final MethodDescriptor<ListInsightsRequest, ListInsightsResponse> listInsightsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/ListInsights").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInsightsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInsightsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInsightRequest, Insight> getInsightMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/GetInsight").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInsightRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Insight.getDefaultInstance())).build();
    private static final MethodDescriptor<MarkInsightAcceptedRequest, Insight> markInsightAcceptedMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/MarkInsightAccepted").setRequestMarshaller(ProtoUtils.marshaller((Message)MarkInsightAcceptedRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Insight.getDefaultInstance())).build();
    private static final MethodDescriptor<ListRecommendationsRequest, ListRecommendationsResponse> listRecommendationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/ListRecommendations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRecommendationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRecommendationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetRecommendationRequest, Recommendation> getRecommendationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/GetRecommendation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRecommendationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Recommendation.getDefaultInstance())).build();
    private static final MethodDescriptor<MarkRecommendationDismissedRequest, Recommendation> markRecommendationDismissedMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/MarkRecommendationDismissed").setRequestMarshaller(ProtoUtils.marshaller((Message)MarkRecommendationDismissedRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Recommendation.getDefaultInstance())).build();
    private static final MethodDescriptor<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/MarkRecommendationClaimed").setRequestMarshaller(ProtoUtils.marshaller((Message)MarkRecommendationClaimedRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Recommendation.getDefaultInstance())).build();
    private static final MethodDescriptor<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/MarkRecommendationSucceeded").setRequestMarshaller(ProtoUtils.marshaller((Message)MarkRecommendationSucceededRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Recommendation.getDefaultInstance())).build();
    private static final MethodDescriptor<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/MarkRecommendationFailed").setRequestMarshaller(ProtoUtils.marshaller((Message)MarkRecommendationFailedRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Recommendation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetRecommenderConfigRequest, RecommenderConfig> getRecommenderConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/GetRecommenderConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRecommenderConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RecommenderConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateRecommenderConfigRequest, RecommenderConfig> updateRecommenderConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/UpdateRecommenderConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateRecommenderConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RecommenderConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInsightTypeConfigRequest, InsightTypeConfig> getInsightTypeConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/GetInsightTypeConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInsightTypeConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)InsightTypeConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateInsightTypeConfigRequest, InsightTypeConfig> updateInsightTypeConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recommender.v1.Recommender/UpdateInsightTypeConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateInsightTypeConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)InsightTypeConfig.getDefaultInstance())).build();
    private final UnaryCallable<ListInsightsRequest, ListInsightsResponse> listInsightsCallable;
    private final UnaryCallable<ListInsightsRequest, RecommenderClient.ListInsightsPagedResponse> listInsightsPagedCallable;
    private final UnaryCallable<GetInsightRequest, Insight> getInsightCallable;
    private final UnaryCallable<MarkInsightAcceptedRequest, Insight> markInsightAcceptedCallable;
    private final UnaryCallable<ListRecommendationsRequest, ListRecommendationsResponse> listRecommendationsCallable;
    private final UnaryCallable<ListRecommendationsRequest, RecommenderClient.ListRecommendationsPagedResponse> listRecommendationsPagedCallable;
    private final UnaryCallable<GetRecommendationRequest, Recommendation> getRecommendationCallable;
    private final UnaryCallable<MarkRecommendationDismissedRequest, Recommendation> markRecommendationDismissedCallable;
    private final UnaryCallable<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedCallable;
    private final UnaryCallable<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededCallable;
    private final UnaryCallable<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedCallable;
    private final UnaryCallable<GetRecommenderConfigRequest, RecommenderConfig> getRecommenderConfigCallable;
    private final UnaryCallable<UpdateRecommenderConfigRequest, RecommenderConfig> updateRecommenderConfigCallable;
    private final UnaryCallable<GetInsightTypeConfigRequest, InsightTypeConfig> getInsightTypeConfigCallable;
    private final UnaryCallable<UpdateInsightTypeConfigRequest, InsightTypeConfig> updateInsightTypeConfigCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcRecommenderStub create(RecommenderStubSettings settings) throws IOException {
        return new GrpcRecommenderStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcRecommenderStub create(ClientContext clientContext) throws IOException {
        return new GrpcRecommenderStub(RecommenderStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcRecommenderStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcRecommenderStub(RecommenderStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcRecommenderStub(RecommenderStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcRecommenderCallableFactory());
    }

    protected GrpcRecommenderStub(RecommenderStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listInsightsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInsightsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getInsightTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInsightMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings markInsightAcceptedTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(markInsightAcceptedMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listRecommendationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRecommendationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getRecommendationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRecommendationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings markRecommendationDismissedTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(markRecommendationDismissedMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings markRecommendationClaimedTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(markRecommendationClaimedMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings markRecommendationSucceededTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(markRecommendationSucceededMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings markRecommendationFailedTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(markRecommendationFailedMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getRecommenderConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRecommenderConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateRecommenderConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateRecommenderConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("recommender_config.name", String.valueOf(request.getRecommenderConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getInsightTypeConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInsightTypeConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateInsightTypeConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateInsightTypeConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("insight_type_config.name", String.valueOf(request.getInsightTypeConfig().getName()));
            return builder.build();
        }).build();
        this.listInsightsCallable = callableFactory.createUnaryCallable(listInsightsTransportSettings, settings.listInsightsSettings(), clientContext);
        this.listInsightsPagedCallable = callableFactory.createPagedCallable(listInsightsTransportSettings, settings.listInsightsSettings(), clientContext);
        this.getInsightCallable = callableFactory.createUnaryCallable(getInsightTransportSettings, settings.getInsightSettings(), clientContext);
        this.markInsightAcceptedCallable = callableFactory.createUnaryCallable(markInsightAcceptedTransportSettings, settings.markInsightAcceptedSettings(), clientContext);
        this.listRecommendationsCallable = callableFactory.createUnaryCallable(listRecommendationsTransportSettings, settings.listRecommendationsSettings(), clientContext);
        this.listRecommendationsPagedCallable = callableFactory.createPagedCallable(listRecommendationsTransportSettings, settings.listRecommendationsSettings(), clientContext);
        this.getRecommendationCallable = callableFactory.createUnaryCallable(getRecommendationTransportSettings, settings.getRecommendationSettings(), clientContext);
        this.markRecommendationDismissedCallable = callableFactory.createUnaryCallable(markRecommendationDismissedTransportSettings, settings.markRecommendationDismissedSettings(), clientContext);
        this.markRecommendationClaimedCallable = callableFactory.createUnaryCallable(markRecommendationClaimedTransportSettings, settings.markRecommendationClaimedSettings(), clientContext);
        this.markRecommendationSucceededCallable = callableFactory.createUnaryCallable(markRecommendationSucceededTransportSettings, settings.markRecommendationSucceededSettings(), clientContext);
        this.markRecommendationFailedCallable = callableFactory.createUnaryCallable(markRecommendationFailedTransportSettings, settings.markRecommendationFailedSettings(), clientContext);
        this.getRecommenderConfigCallable = callableFactory.createUnaryCallable(getRecommenderConfigTransportSettings, settings.getRecommenderConfigSettings(), clientContext);
        this.updateRecommenderConfigCallable = callableFactory.createUnaryCallable(updateRecommenderConfigTransportSettings, settings.updateRecommenderConfigSettings(), clientContext);
        this.getInsightTypeConfigCallable = callableFactory.createUnaryCallable(getInsightTypeConfigTransportSettings, settings.getInsightTypeConfigSettings(), clientContext);
        this.updateInsightTypeConfigCallable = callableFactory.createUnaryCallable(updateInsightTypeConfigTransportSettings, settings.updateInsightTypeConfigSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListInsightsRequest, ListInsightsResponse> listInsightsCallable() {
        return this.listInsightsCallable;
    }

    @Override
    public UnaryCallable<ListInsightsRequest, RecommenderClient.ListInsightsPagedResponse> listInsightsPagedCallable() {
        return this.listInsightsPagedCallable;
    }

    @Override
    public UnaryCallable<GetInsightRequest, Insight> getInsightCallable() {
        return this.getInsightCallable;
    }

    @Override
    public UnaryCallable<MarkInsightAcceptedRequest, Insight> markInsightAcceptedCallable() {
        return this.markInsightAcceptedCallable;
    }

    @Override
    public UnaryCallable<ListRecommendationsRequest, ListRecommendationsResponse> listRecommendationsCallable() {
        return this.listRecommendationsCallable;
    }

    @Override
    public UnaryCallable<ListRecommendationsRequest, RecommenderClient.ListRecommendationsPagedResponse> listRecommendationsPagedCallable() {
        return this.listRecommendationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetRecommendationRequest, Recommendation> getRecommendationCallable() {
        return this.getRecommendationCallable;
    }

    @Override
    public UnaryCallable<MarkRecommendationDismissedRequest, Recommendation> markRecommendationDismissedCallable() {
        return this.markRecommendationDismissedCallable;
    }

    @Override
    public UnaryCallable<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedCallable() {
        return this.markRecommendationClaimedCallable;
    }

    @Override
    public UnaryCallable<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededCallable() {
        return this.markRecommendationSucceededCallable;
    }

    @Override
    public UnaryCallable<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedCallable() {
        return this.markRecommendationFailedCallable;
    }

    @Override
    public UnaryCallable<GetRecommenderConfigRequest, RecommenderConfig> getRecommenderConfigCallable() {
        return this.getRecommenderConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateRecommenderConfigRequest, RecommenderConfig> updateRecommenderConfigCallable() {
        return this.updateRecommenderConfigCallable;
    }

    @Override
    public UnaryCallable<GetInsightTypeConfigRequest, InsightTypeConfig> getInsightTypeConfigCallable() {
        return this.getInsightTypeConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateInsightTypeConfigRequest, InsightTypeConfig> updateInsightTypeConfigCallable() {
        return this.updateInsightTypeConfigCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

