/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommendationengine.v1beta1;

import com.google.api.HttpBody;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recommendationengine.v1beta1.CollectUserEventRequest;
import com.google.cloud.recommendationengine.v1beta1.EventStoreName;
import com.google.cloud.recommendationengine.v1beta1.ImportErrorsConfig;
import com.google.cloud.recommendationengine.v1beta1.ImportMetadata;
import com.google.cloud.recommendationengine.v1beta1.ImportUserEventsRequest;
import com.google.cloud.recommendationengine.v1beta1.ImportUserEventsResponse;
import com.google.cloud.recommendationengine.v1beta1.InputConfig;
import com.google.cloud.recommendationengine.v1beta1.ListUserEventsRequest;
import com.google.cloud.recommendationengine.v1beta1.ListUserEventsResponse;
import com.google.cloud.recommendationengine.v1beta1.PurgeUserEventsMetadata;
import com.google.cloud.recommendationengine.v1beta1.PurgeUserEventsRequest;
import com.google.cloud.recommendationengine.v1beta1.PurgeUserEventsResponse;
import com.google.cloud.recommendationengine.v1beta1.UserEvent;
import com.google.cloud.recommendationengine.v1beta1.UserEventServiceSettings;
import com.google.cloud.recommendationengine.v1beta1.WriteUserEventRequest;
import com.google.cloud.recommendationengine.v1beta1.stub.UserEventServiceStub;
import com.google.cloud.recommendationengine.v1beta1.stub.UserEventServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class UserEventServiceClient
implements BackgroundResource {
    private final UserEventServiceSettings settings;
    private final UserEventServiceStub stub;
    private final OperationsClient operationsClient;

    public static final UserEventServiceClient create() throws IOException {
        return UserEventServiceClient.create(UserEventServiceSettings.newBuilder().build());
    }

    public static final UserEventServiceClient create(UserEventServiceSettings settings) throws IOException {
        return new UserEventServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final UserEventServiceClient create(UserEventServiceStub stub) {
        return new UserEventServiceClient(stub);
    }

    protected UserEventServiceClient(UserEventServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((UserEventServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected UserEventServiceClient(UserEventServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final UserEventServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public UserEventServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final UserEvent writeUserEvent(EventStoreName parent, UserEvent userEvent) {
        WriteUserEventRequest request = WriteUserEventRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setUserEvent(userEvent).build();
        return this.writeUserEvent(request);
    }

    public final UserEvent writeUserEvent(String parent, UserEvent userEvent) {
        WriteUserEventRequest request = WriteUserEventRequest.newBuilder().setParent(parent).setUserEvent(userEvent).build();
        return this.writeUserEvent(request);
    }

    public final UserEvent writeUserEvent(WriteUserEventRequest request) {
        return (UserEvent)this.writeUserEventCallable().call((Object)request);
    }

    public final UnaryCallable<WriteUserEventRequest, UserEvent> writeUserEventCallable() {
        return this.stub.writeUserEventCallable();
    }

    public final HttpBody collectUserEvent(EventStoreName parent, String userEvent, String uri, long ets) {
        CollectUserEventRequest request = CollectUserEventRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setUserEvent(userEvent).setUri(uri).setEts(ets).build();
        return this.collectUserEvent(request);
    }

    public final HttpBody collectUserEvent(String parent, String userEvent, String uri, long ets) {
        CollectUserEventRequest request = CollectUserEventRequest.newBuilder().setParent(parent).setUserEvent(userEvent).setUri(uri).setEts(ets).build();
        return this.collectUserEvent(request);
    }

    public final HttpBody collectUserEvent(CollectUserEventRequest request) {
        return (HttpBody)this.collectUserEventCallable().call((Object)request);
    }

    public final UnaryCallable<CollectUserEventRequest, HttpBody> collectUserEventCallable() {
        return this.stub.collectUserEventCallable();
    }

    public final ListUserEventsPagedResponse listUserEvents(EventStoreName parent, String filter) {
        ListUserEventsRequest request = ListUserEventsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.listUserEvents(request);
    }

    public final ListUserEventsPagedResponse listUserEvents(String parent, String filter) {
        ListUserEventsRequest request = ListUserEventsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listUserEvents(request);
    }

    public final ListUserEventsPagedResponse listUserEvents(ListUserEventsRequest request) {
        return (ListUserEventsPagedResponse)((Object)this.listUserEventsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUserEventsRequest, ListUserEventsPagedResponse> listUserEventsPagedCallable() {
        return this.stub.listUserEventsPagedCallable();
    }

    public final UnaryCallable<ListUserEventsRequest, ListUserEventsResponse> listUserEventsCallable() {
        return this.stub.listUserEventsCallable();
    }

    public final OperationFuture<PurgeUserEventsResponse, PurgeUserEventsMetadata> purgeUserEventsAsync(EventStoreName parent, String filter, boolean force) {
        PurgeUserEventsRequest request = PurgeUserEventsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).setForce(force).build();
        return this.purgeUserEventsAsync(request);
    }

    public final OperationFuture<PurgeUserEventsResponse, PurgeUserEventsMetadata> purgeUserEventsAsync(String parent, String filter, boolean force) {
        PurgeUserEventsRequest request = PurgeUserEventsRequest.newBuilder().setParent(parent).setFilter(filter).setForce(force).build();
        return this.purgeUserEventsAsync(request);
    }

    public final OperationFuture<PurgeUserEventsResponse, PurgeUserEventsMetadata> purgeUserEventsAsync(PurgeUserEventsRequest request) {
        return this.purgeUserEventsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PurgeUserEventsRequest, PurgeUserEventsResponse, PurgeUserEventsMetadata> purgeUserEventsOperationCallable() {
        return this.stub.purgeUserEventsOperationCallable();
    }

    public final UnaryCallable<PurgeUserEventsRequest, Operation> purgeUserEventsCallable() {
        return this.stub.purgeUserEventsCallable();
    }

    public final OperationFuture<ImportUserEventsResponse, ImportMetadata> importUserEventsAsync(EventStoreName parent, String requestId, InputConfig inputConfig, ImportErrorsConfig errorsConfig) {
        ImportUserEventsRequest request = ImportUserEventsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRequestId(requestId).setInputConfig(inputConfig).setErrorsConfig(errorsConfig).build();
        return this.importUserEventsAsync(request);
    }

    public final OperationFuture<ImportUserEventsResponse, ImportMetadata> importUserEventsAsync(String parent, String requestId, InputConfig inputConfig, ImportErrorsConfig errorsConfig) {
        ImportUserEventsRequest request = ImportUserEventsRequest.newBuilder().setParent(parent).setRequestId(requestId).setInputConfig(inputConfig).setErrorsConfig(errorsConfig).build();
        return this.importUserEventsAsync(request);
    }

    public final OperationFuture<ImportUserEventsResponse, ImportMetadata> importUserEventsAsync(ImportUserEventsRequest request) {
        return this.importUserEventsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportUserEventsRequest, ImportUserEventsResponse, ImportMetadata> importUserEventsOperationCallable() {
        return this.stub.importUserEventsOperationCallable();
    }

    public final UnaryCallable<ImportUserEventsRequest, Operation> importUserEventsCallable() {
        return this.stub.importUserEventsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListUserEventsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUserEventsRequest, ListUserEventsResponse, UserEvent, ListUserEventsPage, ListUserEventsFixedSizeCollection> {
        private ListUserEventsFixedSizeCollection(List<ListUserEventsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUserEventsFixedSizeCollection createEmptyCollection() {
            return new ListUserEventsFixedSizeCollection(null, 0);
        }

        protected ListUserEventsFixedSizeCollection createCollection(List<ListUserEventsPage> pages, int collectionSize) {
            return new ListUserEventsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUserEventsPage
    extends AbstractPage<ListUserEventsRequest, ListUserEventsResponse, UserEvent, ListUserEventsPage> {
        private ListUserEventsPage(PageContext<ListUserEventsRequest, ListUserEventsResponse, UserEvent> context, ListUserEventsResponse response) {
            super(context, (Object)response);
        }

        private static ListUserEventsPage createEmptyPage() {
            return new ListUserEventsPage(null, null);
        }

        protected ListUserEventsPage createPage(PageContext<ListUserEventsRequest, ListUserEventsResponse, UserEvent> context, ListUserEventsResponse response) {
            return new ListUserEventsPage(context, response);
        }

        public ApiFuture<ListUserEventsPage> createPageAsync(PageContext<ListUserEventsRequest, ListUserEventsResponse, UserEvent> context, ApiFuture<ListUserEventsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUserEventsPagedResponse
    extends AbstractPagedListResponse<ListUserEventsRequest, ListUserEventsResponse, UserEvent, ListUserEventsPage, ListUserEventsFixedSizeCollection> {
        public static ApiFuture<ListUserEventsPagedResponse> createAsync(PageContext<ListUserEventsRequest, ListUserEventsResponse, UserEvent> context, ApiFuture<ListUserEventsResponse> futureResponse) {
            ApiFuture<ListUserEventsPage> futurePage = ListUserEventsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUserEventsPagedResponse((ListUserEventsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListUserEventsPagedResponse(ListUserEventsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUserEventsFixedSizeCollection.createEmptyCollection());
        }
    }
}

