/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommendationengine.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recommendationengine.v1beta1.CreatePredictionApiKeyRegistrationRequest;
import com.google.cloud.recommendationengine.v1beta1.DeletePredictionApiKeyRegistrationRequest;
import com.google.cloud.recommendationengine.v1beta1.EventStoreName;
import com.google.cloud.recommendationengine.v1beta1.ListPredictionApiKeyRegistrationsRequest;
import com.google.cloud.recommendationengine.v1beta1.ListPredictionApiKeyRegistrationsResponse;
import com.google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistration;
import com.google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistrationName;
import com.google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistrySettings;
import com.google.cloud.recommendationengine.v1beta1.stub.PredictionApiKeyRegistryStub;
import com.google.cloud.recommendationengine.v1beta1.stub.PredictionApiKeyRegistryStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PredictionApiKeyRegistryClient
implements BackgroundResource {
    private final PredictionApiKeyRegistrySettings settings;
    private final PredictionApiKeyRegistryStub stub;

    public static final PredictionApiKeyRegistryClient create() throws IOException {
        return PredictionApiKeyRegistryClient.create(PredictionApiKeyRegistrySettings.newBuilder().build());
    }

    public static final PredictionApiKeyRegistryClient create(PredictionApiKeyRegistrySettings settings) throws IOException {
        return new PredictionApiKeyRegistryClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final PredictionApiKeyRegistryClient create(PredictionApiKeyRegistryStub stub) {
        return new PredictionApiKeyRegistryClient(stub);
    }

    protected PredictionApiKeyRegistryClient(PredictionApiKeyRegistrySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PredictionApiKeyRegistryStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected PredictionApiKeyRegistryClient(PredictionApiKeyRegistryStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PredictionApiKeyRegistrySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PredictionApiKeyRegistryStub getStub() {
        return this.stub;
    }

    public final PredictionApiKeyRegistration createPredictionApiKeyRegistration(EventStoreName parent, PredictionApiKeyRegistration predictionApiKeyRegistration) {
        CreatePredictionApiKeyRegistrationRequest request = CreatePredictionApiKeyRegistrationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPredictionApiKeyRegistration(predictionApiKeyRegistration).build();
        return this.createPredictionApiKeyRegistration(request);
    }

    public final PredictionApiKeyRegistration createPredictionApiKeyRegistration(String parent, PredictionApiKeyRegistration predictionApiKeyRegistration) {
        CreatePredictionApiKeyRegistrationRequest request = CreatePredictionApiKeyRegistrationRequest.newBuilder().setParent(parent).setPredictionApiKeyRegistration(predictionApiKeyRegistration).build();
        return this.createPredictionApiKeyRegistration(request);
    }

    public final PredictionApiKeyRegistration createPredictionApiKeyRegistration(CreatePredictionApiKeyRegistrationRequest request) {
        return (PredictionApiKeyRegistration)this.createPredictionApiKeyRegistrationCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePredictionApiKeyRegistrationRequest, PredictionApiKeyRegistration> createPredictionApiKeyRegistrationCallable() {
        return this.stub.createPredictionApiKeyRegistrationCallable();
    }

    public final ListPredictionApiKeyRegistrationsPagedResponse listPredictionApiKeyRegistrations(EventStoreName parent) {
        ListPredictionApiKeyRegistrationsRequest request = ListPredictionApiKeyRegistrationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPredictionApiKeyRegistrations(request);
    }

    public final ListPredictionApiKeyRegistrationsPagedResponse listPredictionApiKeyRegistrations(String parent) {
        ListPredictionApiKeyRegistrationsRequest request = ListPredictionApiKeyRegistrationsRequest.newBuilder().setParent(parent).build();
        return this.listPredictionApiKeyRegistrations(request);
    }

    public final ListPredictionApiKeyRegistrationsPagedResponse listPredictionApiKeyRegistrations(ListPredictionApiKeyRegistrationsRequest request) {
        return (ListPredictionApiKeyRegistrationsPagedResponse)((Object)this.listPredictionApiKeyRegistrationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPredictionApiKeyRegistrationsRequest, ListPredictionApiKeyRegistrationsPagedResponse> listPredictionApiKeyRegistrationsPagedCallable() {
        return this.stub.listPredictionApiKeyRegistrationsPagedCallable();
    }

    public final UnaryCallable<ListPredictionApiKeyRegistrationsRequest, ListPredictionApiKeyRegistrationsResponse> listPredictionApiKeyRegistrationsCallable() {
        return this.stub.listPredictionApiKeyRegistrationsCallable();
    }

    public final void deletePredictionApiKeyRegistration(PredictionApiKeyRegistrationName name) {
        DeletePredictionApiKeyRegistrationRequest request = DeletePredictionApiKeyRegistrationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deletePredictionApiKeyRegistration(request);
    }

    public final void deletePredictionApiKeyRegistration(String name) {
        DeletePredictionApiKeyRegistrationRequest request = DeletePredictionApiKeyRegistrationRequest.newBuilder().setName(name).build();
        this.deletePredictionApiKeyRegistration(request);
    }

    public final void deletePredictionApiKeyRegistration(DeletePredictionApiKeyRegistrationRequest request) {
        this.deletePredictionApiKeyRegistrationCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePredictionApiKeyRegistrationRequest, Empty> deletePredictionApiKeyRegistrationCallable() {
        return this.stub.deletePredictionApiKeyRegistrationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPredictionApiKeyRegistrationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPredictionApiKeyRegistrationsRequest, ListPredictionApiKeyRegistrationsResponse, PredictionApiKeyRegistration, ListPredictionApiKeyRegistrationsPage, ListPredictionApiKeyRegistrationsFixedSizeCollection> {
        private ListPredictionApiKeyRegistrationsFixedSizeCollection(List<ListPredictionApiKeyRegistrationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPredictionApiKeyRegistrationsFixedSizeCollection createEmptyCollection() {
            return new ListPredictionApiKeyRegistrationsFixedSizeCollection(null, 0);
        }

        protected ListPredictionApiKeyRegistrationsFixedSizeCollection createCollection(List<ListPredictionApiKeyRegistrationsPage> pages, int collectionSize) {
            return new ListPredictionApiKeyRegistrationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPredictionApiKeyRegistrationsPage
    extends AbstractPage<ListPredictionApiKeyRegistrationsRequest, ListPredictionApiKeyRegistrationsResponse, PredictionApiKeyRegistration, ListPredictionApiKeyRegistrationsPage> {
        private ListPredictionApiKeyRegistrationsPage(PageContext<ListPredictionApiKeyRegistrationsRequest, ListPredictionApiKeyRegistrationsResponse, PredictionApiKeyRegistration> context, ListPredictionApiKeyRegistrationsResponse response) {
            super(context, (Object)response);
        }

        private static ListPredictionApiKeyRegistrationsPage createEmptyPage() {
            return new ListPredictionApiKeyRegistrationsPage(null, null);
        }

        protected ListPredictionApiKeyRegistrationsPage createPage(PageContext<ListPredictionApiKeyRegistrationsRequest, ListPredictionApiKeyRegistrationsResponse, PredictionApiKeyRegistration> context, ListPredictionApiKeyRegistrationsResponse response) {
            return new ListPredictionApiKeyRegistrationsPage(context, response);
        }

        public ApiFuture<ListPredictionApiKeyRegistrationsPage> createPageAsync(PageContext<ListPredictionApiKeyRegistrationsRequest, ListPredictionApiKeyRegistrationsResponse, PredictionApiKeyRegistration> context, ApiFuture<ListPredictionApiKeyRegistrationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPredictionApiKeyRegistrationsPagedResponse
    extends AbstractPagedListResponse<ListPredictionApiKeyRegistrationsRequest, ListPredictionApiKeyRegistrationsResponse, PredictionApiKeyRegistration, ListPredictionApiKeyRegistrationsPage, ListPredictionApiKeyRegistrationsFixedSizeCollection> {
        public static ApiFuture<ListPredictionApiKeyRegistrationsPagedResponse> createAsync(PageContext<ListPredictionApiKeyRegistrationsRequest, ListPredictionApiKeyRegistrationsResponse, PredictionApiKeyRegistration> context, ApiFuture<ListPredictionApiKeyRegistrationsResponse> futureResponse) {
            ApiFuture<ListPredictionApiKeyRegistrationsPage> futurePage = ListPredictionApiKeyRegistrationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPredictionApiKeyRegistrationsPage, ListPredictionApiKeyRegistrationsPagedResponse>(){

                public ListPredictionApiKeyRegistrationsPagedResponse apply(ListPredictionApiKeyRegistrationsPage input) {
                    return new ListPredictionApiKeyRegistrationsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPredictionApiKeyRegistrationsPagedResponse(ListPredictionApiKeyRegistrationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPredictionApiKeyRegistrationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

