/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommendationengine.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recommendationengine.v1beta1.PlacementName;
import com.google.cloud.recommendationengine.v1beta1.PredictRequest;
import com.google.cloud.recommendationengine.v1beta1.PredictResponse;
import com.google.cloud.recommendationengine.v1beta1.PredictionServiceSettings;
import com.google.cloud.recommendationengine.v1beta1.UserEvent;
import com.google.cloud.recommendationengine.v1beta1.stub.PredictionServiceStub;
import com.google.cloud.recommendationengine.v1beta1.stub.PredictionServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PredictionServiceClient
implements BackgroundResource {
    private final PredictionServiceSettings settings;
    private final PredictionServiceStub stub;

    public static final PredictionServiceClient create() throws IOException {
        return PredictionServiceClient.create(PredictionServiceSettings.newBuilder().build());
    }

    public static final PredictionServiceClient create(PredictionServiceSettings settings) throws IOException {
        return new PredictionServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final PredictionServiceClient create(PredictionServiceStub stub) {
        return new PredictionServiceClient(stub);
    }

    protected PredictionServiceClient(PredictionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PredictionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected PredictionServiceClient(PredictionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PredictionServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PredictionServiceStub getStub() {
        return this.stub;
    }

    public final PredictPagedResponse predict(PlacementName name, UserEvent userEvent) {
        PredictRequest request = PredictRequest.newBuilder().setName(name == null ? null : name.toString()).setUserEvent(userEvent).build();
        return this.predict(request);
    }

    public final PredictPagedResponse predict(String name, UserEvent userEvent) {
        PredictRequest request = PredictRequest.newBuilder().setName(name).setUserEvent(userEvent).build();
        return this.predict(request);
    }

    public final PredictPagedResponse predict(PredictRequest request) {
        return (PredictPagedResponse)((Object)this.predictPagedCallable().call((Object)request));
    }

    public final UnaryCallable<PredictRequest, PredictPagedResponse> predictPagedCallable() {
        return this.stub.predictPagedCallable();
    }

    public final UnaryCallable<PredictRequest, PredictResponse> predictCallable() {
        return this.stub.predictCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class PredictFixedSizeCollection
    extends AbstractFixedSizeCollection<PredictRequest, PredictResponse, PredictResponse.PredictionResult, PredictPage, PredictFixedSizeCollection> {
        private PredictFixedSizeCollection(List<PredictPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static PredictFixedSizeCollection createEmptyCollection() {
            return new PredictFixedSizeCollection(null, 0);
        }

        protected PredictFixedSizeCollection createCollection(List<PredictPage> pages, int collectionSize) {
            return new PredictFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class PredictPage
    extends AbstractPage<PredictRequest, PredictResponse, PredictResponse.PredictionResult, PredictPage> {
        private PredictPage(PageContext<PredictRequest, PredictResponse, PredictResponse.PredictionResult> context, PredictResponse response) {
            super(context, (Object)response);
        }

        private static PredictPage createEmptyPage() {
            return new PredictPage(null, null);
        }

        protected PredictPage createPage(PageContext<PredictRequest, PredictResponse, PredictResponse.PredictionResult> context, PredictResponse response) {
            return new PredictPage(context, response);
        }

        public ApiFuture<PredictPage> createPageAsync(PageContext<PredictRequest, PredictResponse, PredictResponse.PredictionResult> context, ApiFuture<PredictResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class PredictPagedResponse
    extends AbstractPagedListResponse<PredictRequest, PredictResponse, PredictResponse.PredictionResult, PredictPage, PredictFixedSizeCollection> {
        public static ApiFuture<PredictPagedResponse> createAsync(PageContext<PredictRequest, PredictResponse, PredictResponse.PredictionResult> context, ApiFuture<PredictResponse> futureResponse) {
            ApiFuture<PredictPage> futurePage = PredictPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<PredictPage, PredictPagedResponse>(){

                public PredictPagedResponse apply(PredictPage input) {
                    return new PredictPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private PredictPagedResponse(PredictPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)PredictFixedSizeCollection.createEmptyCollection());
        }
    }
}

