/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recaptchaenterprise.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseServiceSettings;
import com.google.cloud.recaptchaenterprise.v1.stub.RecaptchaEnterpriseServiceStub;
import com.google.cloud.recaptchaenterprise.v1.stub.RecaptchaEnterpriseServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.recaptchaenterprise.v1.AnnotateAssessmentRequest;
import com.google.recaptchaenterprise.v1.AnnotateAssessmentResponse;
import com.google.recaptchaenterprise.v1.Assessment;
import com.google.recaptchaenterprise.v1.AssessmentName;
import com.google.recaptchaenterprise.v1.CreateAssessmentRequest;
import com.google.recaptchaenterprise.v1.CreateKeyRequest;
import com.google.recaptchaenterprise.v1.DeleteKeyRequest;
import com.google.recaptchaenterprise.v1.GetKeyRequest;
import com.google.recaptchaenterprise.v1.GetMetricsRequest;
import com.google.recaptchaenterprise.v1.Key;
import com.google.recaptchaenterprise.v1.ListKeysRequest;
import com.google.recaptchaenterprise.v1.ListKeysResponse;
import com.google.recaptchaenterprise.v1.ListRelatedAccountGroupMembershipsRequest;
import com.google.recaptchaenterprise.v1.ListRelatedAccountGroupMembershipsResponse;
import com.google.recaptchaenterprise.v1.ListRelatedAccountGroupsRequest;
import com.google.recaptchaenterprise.v1.ListRelatedAccountGroupsResponse;
import com.google.recaptchaenterprise.v1.Metrics;
import com.google.recaptchaenterprise.v1.MetricsName;
import com.google.recaptchaenterprise.v1.MigrateKeyRequest;
import com.google.recaptchaenterprise.v1.ProjectName;
import com.google.recaptchaenterprise.v1.RelatedAccountGroup;
import com.google.recaptchaenterprise.v1.RelatedAccountGroupMembership;
import com.google.recaptchaenterprise.v1.RelatedAccountGroupName;
import com.google.recaptchaenterprise.v1.SearchRelatedAccountGroupMembershipsRequest;
import com.google.recaptchaenterprise.v1.SearchRelatedAccountGroupMembershipsResponse;
import com.google.recaptchaenterprise.v1.UpdateKeyRequest;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RecaptchaEnterpriseServiceClient
implements BackgroundResource {
    private final RecaptchaEnterpriseServiceSettings settings;
    private final RecaptchaEnterpriseServiceStub stub;

    public static final RecaptchaEnterpriseServiceClient create() throws IOException {
        return RecaptchaEnterpriseServiceClient.create(RecaptchaEnterpriseServiceSettings.newBuilder().build());
    }

    public static final RecaptchaEnterpriseServiceClient create(RecaptchaEnterpriseServiceSettings settings) throws IOException {
        return new RecaptchaEnterpriseServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RecaptchaEnterpriseServiceClient create(RecaptchaEnterpriseServiceStub stub) {
        return new RecaptchaEnterpriseServiceClient(stub);
    }

    protected RecaptchaEnterpriseServiceClient(RecaptchaEnterpriseServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RecaptchaEnterpriseServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RecaptchaEnterpriseServiceClient(RecaptchaEnterpriseServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RecaptchaEnterpriseServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RecaptchaEnterpriseServiceStub getStub() {
        return this.stub;
    }

    public final Assessment createAssessment(ProjectName parent, Assessment assessment) {
        CreateAssessmentRequest request = CreateAssessmentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAssessment(assessment).build();
        return this.createAssessment(request);
    }

    public final Assessment createAssessment(String parent, Assessment assessment) {
        CreateAssessmentRequest request = CreateAssessmentRequest.newBuilder().setParent(parent).setAssessment(assessment).build();
        return this.createAssessment(request);
    }

    public final Assessment createAssessment(CreateAssessmentRequest request) {
        return (Assessment)this.createAssessmentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAssessmentRequest, Assessment> createAssessmentCallable() {
        return this.stub.createAssessmentCallable();
    }

    public final AnnotateAssessmentResponse annotateAssessment(AssessmentName name, AnnotateAssessmentRequest.Annotation annotation) {
        AnnotateAssessmentRequest request = AnnotateAssessmentRequest.newBuilder().setName(name == null ? null : name.toString()).setAnnotation(annotation).build();
        return this.annotateAssessment(request);
    }

    public final AnnotateAssessmentResponse annotateAssessment(String name, AnnotateAssessmentRequest.Annotation annotation) {
        AnnotateAssessmentRequest request = AnnotateAssessmentRequest.newBuilder().setName(name).setAnnotation(annotation).build();
        return this.annotateAssessment(request);
    }

    public final AnnotateAssessmentResponse annotateAssessment(AnnotateAssessmentRequest request) {
        return (AnnotateAssessmentResponse)this.annotateAssessmentCallable().call((Object)request);
    }

    public final UnaryCallable<AnnotateAssessmentRequest, AnnotateAssessmentResponse> annotateAssessmentCallable() {
        return this.stub.annotateAssessmentCallable();
    }

    public final Key createKey(CreateKeyRequest request) {
        return (Key)this.createKeyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateKeyRequest, Key> createKeyCallable() {
        return this.stub.createKeyCallable();
    }

    public final ListKeysPagedResponse listKeys(ListKeysRequest request) {
        return (ListKeysPagedResponse)((Object)this.listKeysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListKeysRequest, ListKeysPagedResponse> listKeysPagedCallable() {
        return this.stub.listKeysPagedCallable();
    }

    public final UnaryCallable<ListKeysRequest, ListKeysResponse> listKeysCallable() {
        return this.stub.listKeysCallable();
    }

    public final Key getKey(GetKeyRequest request) {
        return (Key)this.getKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetKeyRequest, Key> getKeyCallable() {
        return this.stub.getKeyCallable();
    }

    public final Key updateKey(UpdateKeyRequest request) {
        return (Key)this.updateKeyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateKeyRequest, Key> updateKeyCallable() {
        return this.stub.updateKeyCallable();
    }

    public final void deleteKey(DeleteKeyRequest request) {
        this.deleteKeyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteKeyRequest, Empty> deleteKeyCallable() {
        return this.stub.deleteKeyCallable();
    }

    public final Key migrateKey(MigrateKeyRequest request) {
        return (Key)this.migrateKeyCallable().call((Object)request);
    }

    public final UnaryCallable<MigrateKeyRequest, Key> migrateKeyCallable() {
        return this.stub.migrateKeyCallable();
    }

    public final Metrics getMetrics(MetricsName name) {
        GetMetricsRequest request = GetMetricsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMetrics(request);
    }

    public final Metrics getMetrics(String name) {
        GetMetricsRequest request = GetMetricsRequest.newBuilder().setName(name).build();
        return this.getMetrics(request);
    }

    public final Metrics getMetrics(GetMetricsRequest request) {
        return (Metrics)this.getMetricsCallable().call((Object)request);
    }

    public final UnaryCallable<GetMetricsRequest, Metrics> getMetricsCallable() {
        return this.stub.getMetricsCallable();
    }

    public final ListRelatedAccountGroupsPagedResponse listRelatedAccountGroups(ProjectName parent) {
        ListRelatedAccountGroupsRequest request = ListRelatedAccountGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRelatedAccountGroups(request);
    }

    public final ListRelatedAccountGroupsPagedResponse listRelatedAccountGroups(String parent) {
        ListRelatedAccountGroupsRequest request = ListRelatedAccountGroupsRequest.newBuilder().setParent(parent).build();
        return this.listRelatedAccountGroups(request);
    }

    public final ListRelatedAccountGroupsPagedResponse listRelatedAccountGroups(ListRelatedAccountGroupsRequest request) {
        return (ListRelatedAccountGroupsPagedResponse)((Object)this.listRelatedAccountGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsPagedResponse> listRelatedAccountGroupsPagedCallable() {
        return this.stub.listRelatedAccountGroupsPagedCallable();
    }

    public final UnaryCallable<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse> listRelatedAccountGroupsCallable() {
        return this.stub.listRelatedAccountGroupsCallable();
    }

    public final ListRelatedAccountGroupMembershipsPagedResponse listRelatedAccountGroupMemberships(RelatedAccountGroupName parent) {
        ListRelatedAccountGroupMembershipsRequest request = ListRelatedAccountGroupMembershipsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRelatedAccountGroupMemberships(request);
    }

    public final ListRelatedAccountGroupMembershipsPagedResponse listRelatedAccountGroupMemberships(String parent) {
        ListRelatedAccountGroupMembershipsRequest request = ListRelatedAccountGroupMembershipsRequest.newBuilder().setParent(parent).build();
        return this.listRelatedAccountGroupMemberships(request);
    }

    public final ListRelatedAccountGroupMembershipsPagedResponse listRelatedAccountGroupMemberships(ListRelatedAccountGroupMembershipsRequest request) {
        return (ListRelatedAccountGroupMembershipsPagedResponse)((Object)this.listRelatedAccountGroupMembershipsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsPagedResponse> listRelatedAccountGroupMembershipsPagedCallable() {
        return this.stub.listRelatedAccountGroupMembershipsPagedCallable();
    }

    public final UnaryCallable<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse> listRelatedAccountGroupMembershipsCallable() {
        return this.stub.listRelatedAccountGroupMembershipsCallable();
    }

    public final SearchRelatedAccountGroupMembershipsPagedResponse searchRelatedAccountGroupMemberships(RelatedAccountGroupName parent, ByteString hashedAccountId) {
        SearchRelatedAccountGroupMembershipsRequest request = SearchRelatedAccountGroupMembershipsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setHashedAccountId(hashedAccountId).build();
        return this.searchRelatedAccountGroupMemberships(request);
    }

    public final SearchRelatedAccountGroupMembershipsPagedResponse searchRelatedAccountGroupMemberships(String parent, ByteString hashedAccountId) {
        SearchRelatedAccountGroupMembershipsRequest request = SearchRelatedAccountGroupMembershipsRequest.newBuilder().setParent(parent).setHashedAccountId(hashedAccountId).build();
        return this.searchRelatedAccountGroupMemberships(request);
    }

    public final SearchRelatedAccountGroupMembershipsPagedResponse searchRelatedAccountGroupMemberships(SearchRelatedAccountGroupMembershipsRequest request) {
        return (SearchRelatedAccountGroupMembershipsPagedResponse)((Object)this.searchRelatedAccountGroupMembershipsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsPagedResponse> searchRelatedAccountGroupMembershipsPagedCallable() {
        return this.stub.searchRelatedAccountGroupMembershipsPagedCallable();
    }

    public final UnaryCallable<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse> searchRelatedAccountGroupMembershipsCallable() {
        return this.stub.searchRelatedAccountGroupMembershipsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchRelatedAccountGroupMembershipsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership, SearchRelatedAccountGroupMembershipsPage, SearchRelatedAccountGroupMembershipsFixedSizeCollection> {
        private SearchRelatedAccountGroupMembershipsFixedSizeCollection(List<SearchRelatedAccountGroupMembershipsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchRelatedAccountGroupMembershipsFixedSizeCollection createEmptyCollection() {
            return new SearchRelatedAccountGroupMembershipsFixedSizeCollection(null, 0);
        }

        protected SearchRelatedAccountGroupMembershipsFixedSizeCollection createCollection(List<SearchRelatedAccountGroupMembershipsPage> pages, int collectionSize) {
            return new SearchRelatedAccountGroupMembershipsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchRelatedAccountGroupMembershipsPage
    extends AbstractPage<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership, SearchRelatedAccountGroupMembershipsPage> {
        private SearchRelatedAccountGroupMembershipsPage(PageContext<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership> context, SearchRelatedAccountGroupMembershipsResponse response) {
            super(context, (Object)response);
        }

        private static SearchRelatedAccountGroupMembershipsPage createEmptyPage() {
            return new SearchRelatedAccountGroupMembershipsPage(null, null);
        }

        protected SearchRelatedAccountGroupMembershipsPage createPage(PageContext<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership> context, SearchRelatedAccountGroupMembershipsResponse response) {
            return new SearchRelatedAccountGroupMembershipsPage(context, response);
        }

        public ApiFuture<SearchRelatedAccountGroupMembershipsPage> createPageAsync(PageContext<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership> context, ApiFuture<SearchRelatedAccountGroupMembershipsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchRelatedAccountGroupMembershipsPagedResponse
    extends AbstractPagedListResponse<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership, SearchRelatedAccountGroupMembershipsPage, SearchRelatedAccountGroupMembershipsFixedSizeCollection> {
        public static ApiFuture<SearchRelatedAccountGroupMembershipsPagedResponse> createAsync(PageContext<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership> context, ApiFuture<SearchRelatedAccountGroupMembershipsResponse> futureResponse) {
            ApiFuture<SearchRelatedAccountGroupMembershipsPage> futurePage = SearchRelatedAccountGroupMembershipsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchRelatedAccountGroupMembershipsPagedResponse((SearchRelatedAccountGroupMembershipsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchRelatedAccountGroupMembershipsPagedResponse(SearchRelatedAccountGroupMembershipsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchRelatedAccountGroupMembershipsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRelatedAccountGroupMembershipsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership, ListRelatedAccountGroupMembershipsPage, ListRelatedAccountGroupMembershipsFixedSizeCollection> {
        private ListRelatedAccountGroupMembershipsFixedSizeCollection(List<ListRelatedAccountGroupMembershipsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRelatedAccountGroupMembershipsFixedSizeCollection createEmptyCollection() {
            return new ListRelatedAccountGroupMembershipsFixedSizeCollection(null, 0);
        }

        protected ListRelatedAccountGroupMembershipsFixedSizeCollection createCollection(List<ListRelatedAccountGroupMembershipsPage> pages, int collectionSize) {
            return new ListRelatedAccountGroupMembershipsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRelatedAccountGroupMembershipsPage
    extends AbstractPage<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership, ListRelatedAccountGroupMembershipsPage> {
        private ListRelatedAccountGroupMembershipsPage(PageContext<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership> context, ListRelatedAccountGroupMembershipsResponse response) {
            super(context, (Object)response);
        }

        private static ListRelatedAccountGroupMembershipsPage createEmptyPage() {
            return new ListRelatedAccountGroupMembershipsPage(null, null);
        }

        protected ListRelatedAccountGroupMembershipsPage createPage(PageContext<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership> context, ListRelatedAccountGroupMembershipsResponse response) {
            return new ListRelatedAccountGroupMembershipsPage(context, response);
        }

        public ApiFuture<ListRelatedAccountGroupMembershipsPage> createPageAsync(PageContext<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership> context, ApiFuture<ListRelatedAccountGroupMembershipsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRelatedAccountGroupMembershipsPagedResponse
    extends AbstractPagedListResponse<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership, ListRelatedAccountGroupMembershipsPage, ListRelatedAccountGroupMembershipsFixedSizeCollection> {
        public static ApiFuture<ListRelatedAccountGroupMembershipsPagedResponse> createAsync(PageContext<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership> context, ApiFuture<ListRelatedAccountGroupMembershipsResponse> futureResponse) {
            ApiFuture<ListRelatedAccountGroupMembershipsPage> futurePage = ListRelatedAccountGroupMembershipsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRelatedAccountGroupMembershipsPagedResponse((ListRelatedAccountGroupMembershipsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRelatedAccountGroupMembershipsPagedResponse(ListRelatedAccountGroupMembershipsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRelatedAccountGroupMembershipsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRelatedAccountGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RelatedAccountGroup, ListRelatedAccountGroupsPage, ListRelatedAccountGroupsFixedSizeCollection> {
        private ListRelatedAccountGroupsFixedSizeCollection(List<ListRelatedAccountGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRelatedAccountGroupsFixedSizeCollection createEmptyCollection() {
            return new ListRelatedAccountGroupsFixedSizeCollection(null, 0);
        }

        protected ListRelatedAccountGroupsFixedSizeCollection createCollection(List<ListRelatedAccountGroupsPage> pages, int collectionSize) {
            return new ListRelatedAccountGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRelatedAccountGroupsPage
    extends AbstractPage<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RelatedAccountGroup, ListRelatedAccountGroupsPage> {
        private ListRelatedAccountGroupsPage(PageContext<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RelatedAccountGroup> context, ListRelatedAccountGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListRelatedAccountGroupsPage createEmptyPage() {
            return new ListRelatedAccountGroupsPage(null, null);
        }

        protected ListRelatedAccountGroupsPage createPage(PageContext<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RelatedAccountGroup> context, ListRelatedAccountGroupsResponse response) {
            return new ListRelatedAccountGroupsPage(context, response);
        }

        public ApiFuture<ListRelatedAccountGroupsPage> createPageAsync(PageContext<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RelatedAccountGroup> context, ApiFuture<ListRelatedAccountGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRelatedAccountGroupsPagedResponse
    extends AbstractPagedListResponse<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RelatedAccountGroup, ListRelatedAccountGroupsPage, ListRelatedAccountGroupsFixedSizeCollection> {
        public static ApiFuture<ListRelatedAccountGroupsPagedResponse> createAsync(PageContext<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RelatedAccountGroup> context, ApiFuture<ListRelatedAccountGroupsResponse> futureResponse) {
            ApiFuture<ListRelatedAccountGroupsPage> futurePage = ListRelatedAccountGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRelatedAccountGroupsPagedResponse((ListRelatedAccountGroupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRelatedAccountGroupsPagedResponse(ListRelatedAccountGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRelatedAccountGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListKeysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListKeysRequest, ListKeysResponse, Key, ListKeysPage, ListKeysFixedSizeCollection> {
        private ListKeysFixedSizeCollection(List<ListKeysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListKeysFixedSizeCollection createEmptyCollection() {
            return new ListKeysFixedSizeCollection(null, 0);
        }

        protected ListKeysFixedSizeCollection createCollection(List<ListKeysPage> pages, int collectionSize) {
            return new ListKeysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListKeysPage
    extends AbstractPage<ListKeysRequest, ListKeysResponse, Key, ListKeysPage> {
        private ListKeysPage(PageContext<ListKeysRequest, ListKeysResponse, Key> context, ListKeysResponse response) {
            super(context, (Object)response);
        }

        private static ListKeysPage createEmptyPage() {
            return new ListKeysPage(null, null);
        }

        protected ListKeysPage createPage(PageContext<ListKeysRequest, ListKeysResponse, Key> context, ListKeysResponse response) {
            return new ListKeysPage(context, response);
        }

        public ApiFuture<ListKeysPage> createPageAsync(PageContext<ListKeysRequest, ListKeysResponse, Key> context, ApiFuture<ListKeysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListKeysPagedResponse
    extends AbstractPagedListResponse<ListKeysRequest, ListKeysResponse, Key, ListKeysPage, ListKeysFixedSizeCollection> {
        public static ApiFuture<ListKeysPagedResponse> createAsync(PageContext<ListKeysRequest, ListKeysResponse, Key> context, ApiFuture<ListKeysResponse> futureResponse) {
            ApiFuture<ListKeysPage> futurePage = ListKeysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListKeysPagedResponse((ListKeysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListKeysPagedResponse(ListKeysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListKeysFixedSizeCollection.createEmptyCollection());
        }
    }
}

