/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recaptchaenterprise.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1Client;
import com.google.cloud.recaptchaenterprise.v1beta1.stub.GrpcRecaptchaEnterpriseServiceV1Beta1CallableFactory;
import com.google.cloud.recaptchaenterprise.v1beta1.stub.RecaptchaEnterpriseServiceV1Beta1Stub;
import com.google.cloud.recaptchaenterprise.v1beta1.stub.RecaptchaEnterpriseServiceV1Beta1StubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest;
import com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentResponse;
import com.google.recaptchaenterprise.v1beta1.Assessment;
import com.google.recaptchaenterprise.v1beta1.CreateAssessmentRequest;
import com.google.recaptchaenterprise.v1beta1.CreateKeyRequest;
import com.google.recaptchaenterprise.v1beta1.DeleteKeyRequest;
import com.google.recaptchaenterprise.v1beta1.GetKeyRequest;
import com.google.recaptchaenterprise.v1beta1.Key;
import com.google.recaptchaenterprise.v1beta1.ListKeysRequest;
import com.google.recaptchaenterprise.v1beta1.ListKeysResponse;
import com.google.recaptchaenterprise.v1beta1.UpdateKeyRequest;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcRecaptchaEnterpriseServiceV1Beta1Stub
extends RecaptchaEnterpriseServiceV1Beta1Stub {
    private static final MethodDescriptor<CreateAssessmentRequest, Assessment> createAssessmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/CreateAssessment").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateAssessmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Assessment.getDefaultInstance())).build();
    private static final MethodDescriptor<AnnotateAssessmentRequest, AnnotateAssessmentResponse> annotateAssessmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/AnnotateAssessment").setRequestMarshaller(ProtoUtils.marshaller((Message)AnnotateAssessmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnnotateAssessmentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateKeyRequest, Key> createKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/CreateKey").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Key.getDefaultInstance())).build();
    private static final MethodDescriptor<ListKeysRequest, ListKeysResponse> listKeysMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/ListKeys").setRequestMarshaller(ProtoUtils.marshaller((Message)ListKeysRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListKeysResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetKeyRequest, Key> getKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/GetKey").setRequestMarshaller(ProtoUtils.marshaller((Message)GetKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Key.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateKeyRequest, Key> updateKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/UpdateKey").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Key.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteKeyRequest, Empty> deleteKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/DeleteKey").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<CreateAssessmentRequest, Assessment> createAssessmentCallable;
    private final UnaryCallable<AnnotateAssessmentRequest, AnnotateAssessmentResponse> annotateAssessmentCallable;
    private final UnaryCallable<CreateKeyRequest, Key> createKeyCallable;
    private final UnaryCallable<ListKeysRequest, ListKeysResponse> listKeysCallable;
    private final UnaryCallable<ListKeysRequest, RecaptchaEnterpriseServiceV1Beta1Client.ListKeysPagedResponse> listKeysPagedCallable;
    private final UnaryCallable<GetKeyRequest, Key> getKeyCallable;
    private final UnaryCallable<UpdateKeyRequest, Key> updateKeyCallable;
    private final UnaryCallable<DeleteKeyRequest, Empty> deleteKeyCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcRecaptchaEnterpriseServiceV1Beta1Stub create(RecaptchaEnterpriseServiceV1Beta1StubSettings settings) throws IOException {
        return new GrpcRecaptchaEnterpriseServiceV1Beta1Stub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcRecaptchaEnterpriseServiceV1Beta1Stub create(ClientContext clientContext) throws IOException {
        return new GrpcRecaptchaEnterpriseServiceV1Beta1Stub(RecaptchaEnterpriseServiceV1Beta1StubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcRecaptchaEnterpriseServiceV1Beta1Stub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcRecaptchaEnterpriseServiceV1Beta1Stub(RecaptchaEnterpriseServiceV1Beta1StubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcRecaptchaEnterpriseServiceV1Beta1Stub(RecaptchaEnterpriseServiceV1Beta1StubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcRecaptchaEnterpriseServiceV1Beta1CallableFactory());
    }

    protected GrpcRecaptchaEnterpriseServiceV1Beta1Stub(RecaptchaEnterpriseServiceV1Beta1StubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createAssessmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createAssessmentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings annotateAssessmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(annotateAssessmentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createKeyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listKeysTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listKeysMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getKeyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateKeyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"key.name", (Object)String.valueOf(request.getKey().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteKeyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.createAssessmentCallable = callableFactory.createUnaryCallable(createAssessmentTransportSettings, settings.createAssessmentSettings(), clientContext);
        this.annotateAssessmentCallable = callableFactory.createUnaryCallable(annotateAssessmentTransportSettings, settings.annotateAssessmentSettings(), clientContext);
        this.createKeyCallable = callableFactory.createUnaryCallable(createKeyTransportSettings, settings.createKeySettings(), clientContext);
        this.listKeysCallable = callableFactory.createUnaryCallable(listKeysTransportSettings, settings.listKeysSettings(), clientContext);
        this.listKeysPagedCallable = callableFactory.createPagedCallable(listKeysTransportSettings, settings.listKeysSettings(), clientContext);
        this.getKeyCallable = callableFactory.createUnaryCallable(getKeyTransportSettings, settings.getKeySettings(), clientContext);
        this.updateKeyCallable = callableFactory.createUnaryCallable(updateKeyTransportSettings, settings.updateKeySettings(), clientContext);
        this.deleteKeyCallable = callableFactory.createUnaryCallable(deleteKeyTransportSettings, settings.deleteKeySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateAssessmentRequest, Assessment> createAssessmentCallable() {
        return this.createAssessmentCallable;
    }

    @Override
    public UnaryCallable<AnnotateAssessmentRequest, AnnotateAssessmentResponse> annotateAssessmentCallable() {
        return this.annotateAssessmentCallable;
    }

    @Override
    public UnaryCallable<CreateKeyRequest, Key> createKeyCallable() {
        return this.createKeyCallable;
    }

    @Override
    public UnaryCallable<ListKeysRequest, ListKeysResponse> listKeysCallable() {
        return this.listKeysCallable;
    }

    @Override
    public UnaryCallable<ListKeysRequest, RecaptchaEnterpriseServiceV1Beta1Client.ListKeysPagedResponse> listKeysPagedCallable() {
        return this.listKeysPagedCallable;
    }

    @Override
    public UnaryCallable<GetKeyRequest, Key> getKeyCallable() {
        return this.getKeyCallable;
    }

    @Override
    public UnaryCallable<UpdateKeyRequest, Key> updateKeyCallable() {
        return this.updateKeyCallable;
    }

    @Override
    public UnaryCallable<DeleteKeyRequest, Empty> deleteKeyCallable() {
        return this.deleteKeyCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

