/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.rapidmigrationassessment.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.rapidmigrationassessment.v1.Annotation;
import com.google.cloud.rapidmigrationassessment.v1.AnnotationName;
import com.google.cloud.rapidmigrationassessment.v1.Collector;
import com.google.cloud.rapidmigrationassessment.v1.CollectorName;
import com.google.cloud.rapidmigrationassessment.v1.CreateAnnotationRequest;
import com.google.cloud.rapidmigrationassessment.v1.CreateCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.DeleteCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.GetAnnotationRequest;
import com.google.cloud.rapidmigrationassessment.v1.GetCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.ListCollectorsRequest;
import com.google.cloud.rapidmigrationassessment.v1.ListCollectorsResponse;
import com.google.cloud.rapidmigrationassessment.v1.LocationName;
import com.google.cloud.rapidmigrationassessment.v1.OperationMetadata;
import com.google.cloud.rapidmigrationassessment.v1.PauseCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.RapidMigrationAssessmentSettings;
import com.google.cloud.rapidmigrationassessment.v1.RegisterCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.ResumeCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.UpdateCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.stub.RapidMigrationAssessmentStub;
import com.google.cloud.rapidmigrationassessment.v1.stub.RapidMigrationAssessmentStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RapidMigrationAssessmentClient
implements BackgroundResource {
    private final RapidMigrationAssessmentSettings settings;
    private final RapidMigrationAssessmentStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final RapidMigrationAssessmentClient create() throws IOException {
        return RapidMigrationAssessmentClient.create(RapidMigrationAssessmentSettings.newBuilder().build());
    }

    public static final RapidMigrationAssessmentClient create(RapidMigrationAssessmentSettings settings) throws IOException {
        return new RapidMigrationAssessmentClient(settings);
    }

    public static final RapidMigrationAssessmentClient create(RapidMigrationAssessmentStub stub) {
        return new RapidMigrationAssessmentClient(stub);
    }

    protected RapidMigrationAssessmentClient(RapidMigrationAssessmentSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RapidMigrationAssessmentStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected RapidMigrationAssessmentClient(RapidMigrationAssessmentStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final RapidMigrationAssessmentSettings getSettings() {
        return this.settings;
    }

    public RapidMigrationAssessmentStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Collector, OperationMetadata> createCollectorAsync(LocationName parent, Collector collector, String collectorId) {
        CreateCollectorRequest request = CreateCollectorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCollector(collector).setCollectorId(collectorId).build();
        return this.createCollectorAsync(request);
    }

    public final OperationFuture<Collector, OperationMetadata> createCollectorAsync(String parent, Collector collector, String collectorId) {
        CreateCollectorRequest request = CreateCollectorRequest.newBuilder().setParent(parent).setCollector(collector).setCollectorId(collectorId).build();
        return this.createCollectorAsync(request);
    }

    public final OperationFuture<Collector, OperationMetadata> createCollectorAsync(CreateCollectorRequest request) {
        return this.createCollectorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCollectorRequest, Collector, OperationMetadata> createCollectorOperationCallable() {
        return this.stub.createCollectorOperationCallable();
    }

    public final UnaryCallable<CreateCollectorRequest, Operation> createCollectorCallable() {
        return this.stub.createCollectorCallable();
    }

    public final OperationFuture<Annotation, OperationMetadata> createAnnotationAsync(LocationName parent, Annotation annotation) {
        CreateAnnotationRequest request = CreateAnnotationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAnnotation(annotation).build();
        return this.createAnnotationAsync(request);
    }

    public final OperationFuture<Annotation, OperationMetadata> createAnnotationAsync(String parent, Annotation annotation) {
        CreateAnnotationRequest request = CreateAnnotationRequest.newBuilder().setParent(parent).setAnnotation(annotation).build();
        return this.createAnnotationAsync(request);
    }

    public final OperationFuture<Annotation, OperationMetadata> createAnnotationAsync(CreateAnnotationRequest request) {
        return this.createAnnotationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAnnotationRequest, Annotation, OperationMetadata> createAnnotationOperationCallable() {
        return this.stub.createAnnotationOperationCallable();
    }

    public final UnaryCallable<CreateAnnotationRequest, Operation> createAnnotationCallable() {
        return this.stub.createAnnotationCallable();
    }

    public final Annotation getAnnotation(AnnotationName name) {
        GetAnnotationRequest request = GetAnnotationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAnnotation(request);
    }

    public final Annotation getAnnotation(String name) {
        GetAnnotationRequest request = GetAnnotationRequest.newBuilder().setName(name).build();
        return this.getAnnotation(request);
    }

    public final Annotation getAnnotation(GetAnnotationRequest request) {
        return (Annotation)this.getAnnotationCallable().call((Object)request);
    }

    public final UnaryCallable<GetAnnotationRequest, Annotation> getAnnotationCallable() {
        return this.stub.getAnnotationCallable();
    }

    public final ListCollectorsPagedResponse listCollectors(LocationName parent) {
        ListCollectorsRequest request = ListCollectorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCollectors(request);
    }

    public final ListCollectorsPagedResponse listCollectors(String parent) {
        ListCollectorsRequest request = ListCollectorsRequest.newBuilder().setParent(parent).build();
        return this.listCollectors(request);
    }

    public final ListCollectorsPagedResponse listCollectors(ListCollectorsRequest request) {
        return (ListCollectorsPagedResponse)((Object)this.listCollectorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCollectorsRequest, ListCollectorsPagedResponse> listCollectorsPagedCallable() {
        return this.stub.listCollectorsPagedCallable();
    }

    public final UnaryCallable<ListCollectorsRequest, ListCollectorsResponse> listCollectorsCallable() {
        return this.stub.listCollectorsCallable();
    }

    public final Collector getCollector(CollectorName name) {
        GetCollectorRequest request = GetCollectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCollector(request);
    }

    public final Collector getCollector(String name) {
        GetCollectorRequest request = GetCollectorRequest.newBuilder().setName(name).build();
        return this.getCollector(request);
    }

    public final Collector getCollector(GetCollectorRequest request) {
        return (Collector)this.getCollectorCallable().call((Object)request);
    }

    public final UnaryCallable<GetCollectorRequest, Collector> getCollectorCallable() {
        return this.stub.getCollectorCallable();
    }

    public final OperationFuture<Collector, OperationMetadata> updateCollectorAsync(Collector collector, FieldMask updateMask) {
        UpdateCollectorRequest request = UpdateCollectorRequest.newBuilder().setCollector(collector).setUpdateMask(updateMask).build();
        return this.updateCollectorAsync(request);
    }

    public final OperationFuture<Collector, OperationMetadata> updateCollectorAsync(UpdateCollectorRequest request) {
        return this.updateCollectorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCollectorRequest, Collector, OperationMetadata> updateCollectorOperationCallable() {
        return this.stub.updateCollectorOperationCallable();
    }

    public final UnaryCallable<UpdateCollectorRequest, Operation> updateCollectorCallable() {
        return this.stub.updateCollectorCallable();
    }

    public final OperationFuture<Collector, OperationMetadata> deleteCollectorAsync(CollectorName name) {
        DeleteCollectorRequest request = DeleteCollectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCollectorAsync(request);
    }

    public final OperationFuture<Collector, OperationMetadata> deleteCollectorAsync(String name) {
        DeleteCollectorRequest request = DeleteCollectorRequest.newBuilder().setName(name).build();
        return this.deleteCollectorAsync(request);
    }

    public final OperationFuture<Collector, OperationMetadata> deleteCollectorAsync(DeleteCollectorRequest request) {
        return this.deleteCollectorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCollectorRequest, Collector, OperationMetadata> deleteCollectorOperationCallable() {
        return this.stub.deleteCollectorOperationCallable();
    }

    public final UnaryCallable<DeleteCollectorRequest, Operation> deleteCollectorCallable() {
        return this.stub.deleteCollectorCallable();
    }

    public final OperationFuture<Collector, OperationMetadata> resumeCollectorAsync(CollectorName name) {
        ResumeCollectorRequest request = ResumeCollectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.resumeCollectorAsync(request);
    }

    public final OperationFuture<Collector, OperationMetadata> resumeCollectorAsync(String name) {
        ResumeCollectorRequest request = ResumeCollectorRequest.newBuilder().setName(name).build();
        return this.resumeCollectorAsync(request);
    }

    public final OperationFuture<Collector, OperationMetadata> resumeCollectorAsync(ResumeCollectorRequest request) {
        return this.resumeCollectorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResumeCollectorRequest, Collector, OperationMetadata> resumeCollectorOperationCallable() {
        return this.stub.resumeCollectorOperationCallable();
    }

    public final UnaryCallable<ResumeCollectorRequest, Operation> resumeCollectorCallable() {
        return this.stub.resumeCollectorCallable();
    }

    public final OperationFuture<Collector, OperationMetadata> registerCollectorAsync(CollectorName name) {
        RegisterCollectorRequest request = RegisterCollectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.registerCollectorAsync(request);
    }

    public final OperationFuture<Collector, OperationMetadata> registerCollectorAsync(String name) {
        RegisterCollectorRequest request = RegisterCollectorRequest.newBuilder().setName(name).build();
        return this.registerCollectorAsync(request);
    }

    public final OperationFuture<Collector, OperationMetadata> registerCollectorAsync(RegisterCollectorRequest request) {
        return this.registerCollectorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RegisterCollectorRequest, Collector, OperationMetadata> registerCollectorOperationCallable() {
        return this.stub.registerCollectorOperationCallable();
    }

    public final UnaryCallable<RegisterCollectorRequest, Operation> registerCollectorCallable() {
        return this.stub.registerCollectorCallable();
    }

    public final OperationFuture<Collector, OperationMetadata> pauseCollectorAsync(CollectorName name) {
        PauseCollectorRequest request = PauseCollectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.pauseCollectorAsync(request);
    }

    public final OperationFuture<Collector, OperationMetadata> pauseCollectorAsync(String name) {
        PauseCollectorRequest request = PauseCollectorRequest.newBuilder().setName(name).build();
        return this.pauseCollectorAsync(request);
    }

    public final OperationFuture<Collector, OperationMetadata> pauseCollectorAsync(PauseCollectorRequest request) {
        return this.pauseCollectorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PauseCollectorRequest, Collector, OperationMetadata> pauseCollectorOperationCallable() {
        return this.stub.pauseCollectorOperationCallable();
    }

    public final UnaryCallable<PauseCollectorRequest, Operation> pauseCollectorCallable() {
        return this.stub.pauseCollectorCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCollectorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCollectorsRequest, ListCollectorsResponse, Collector, ListCollectorsPage, ListCollectorsFixedSizeCollection> {
        private ListCollectorsFixedSizeCollection(List<ListCollectorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCollectorsFixedSizeCollection createEmptyCollection() {
            return new ListCollectorsFixedSizeCollection(null, 0);
        }

        protected ListCollectorsFixedSizeCollection createCollection(List<ListCollectorsPage> pages, int collectionSize) {
            return new ListCollectorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCollectorsPage
    extends AbstractPage<ListCollectorsRequest, ListCollectorsResponse, Collector, ListCollectorsPage> {
        private ListCollectorsPage(PageContext<ListCollectorsRequest, ListCollectorsResponse, Collector> context, ListCollectorsResponse response) {
            super(context, (Object)response);
        }

        private static ListCollectorsPage createEmptyPage() {
            return new ListCollectorsPage(null, null);
        }

        protected ListCollectorsPage createPage(PageContext<ListCollectorsRequest, ListCollectorsResponse, Collector> context, ListCollectorsResponse response) {
            return new ListCollectorsPage(context, response);
        }

        public ApiFuture<ListCollectorsPage> createPageAsync(PageContext<ListCollectorsRequest, ListCollectorsResponse, Collector> context, ApiFuture<ListCollectorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCollectorsPagedResponse
    extends AbstractPagedListResponse<ListCollectorsRequest, ListCollectorsResponse, Collector, ListCollectorsPage, ListCollectorsFixedSizeCollection> {
        public static ApiFuture<ListCollectorsPagedResponse> createAsync(PageContext<ListCollectorsRequest, ListCollectorsResponse, Collector> context, ApiFuture<ListCollectorsResponse> futureResponse) {
            ApiFuture<ListCollectorsPage> futurePage = ListCollectorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCollectorsPagedResponse((ListCollectorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCollectorsPagedResponse(ListCollectorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCollectorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

