/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.rapidmigrationassessment.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.rapidmigrationassessment.v1.Annotation;
import com.google.cloud.rapidmigrationassessment.v1.Collector;
import com.google.cloud.rapidmigrationassessment.v1.CreateAnnotationRequest;
import com.google.cloud.rapidmigrationassessment.v1.CreateCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.DeleteCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.GetAnnotationRequest;
import com.google.cloud.rapidmigrationassessment.v1.GetCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.ListCollectorsRequest;
import com.google.cloud.rapidmigrationassessment.v1.ListCollectorsResponse;
import com.google.cloud.rapidmigrationassessment.v1.OperationMetadata;
import com.google.cloud.rapidmigrationassessment.v1.PauseCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.RapidMigrationAssessmentClient;
import com.google.cloud.rapidmigrationassessment.v1.RegisterCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.ResumeCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.UpdateCollectorRequest;
import com.google.cloud.rapidmigrationassessment.v1.stub.GrpcRapidMigrationAssessmentStub;
import com.google.cloud.rapidmigrationassessment.v1.stub.HttpJsonRapidMigrationAssessmentStub;
import com.google.cloud.rapidmigrationassessment.v1.stub.RapidMigrationAssessmentStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RapidMigrationAssessmentStubSettings
extends StubSettings<RapidMigrationAssessmentStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateCollectorRequest, Operation> createCollectorSettings;
    private final OperationCallSettings<CreateCollectorRequest, Collector, OperationMetadata> createCollectorOperationSettings;
    private final UnaryCallSettings<CreateAnnotationRequest, Operation> createAnnotationSettings;
    private final OperationCallSettings<CreateAnnotationRequest, Annotation, OperationMetadata> createAnnotationOperationSettings;
    private final UnaryCallSettings<GetAnnotationRequest, Annotation> getAnnotationSettings;
    private final PagedCallSettings<ListCollectorsRequest, ListCollectorsResponse, RapidMigrationAssessmentClient.ListCollectorsPagedResponse> listCollectorsSettings;
    private final UnaryCallSettings<GetCollectorRequest, Collector> getCollectorSettings;
    private final UnaryCallSettings<UpdateCollectorRequest, Operation> updateCollectorSettings;
    private final OperationCallSettings<UpdateCollectorRequest, Collector, OperationMetadata> updateCollectorOperationSettings;
    private final UnaryCallSettings<DeleteCollectorRequest, Operation> deleteCollectorSettings;
    private final OperationCallSettings<DeleteCollectorRequest, Collector, OperationMetadata> deleteCollectorOperationSettings;
    private final UnaryCallSettings<ResumeCollectorRequest, Operation> resumeCollectorSettings;
    private final OperationCallSettings<ResumeCollectorRequest, Collector, OperationMetadata> resumeCollectorOperationSettings;
    private final UnaryCallSettings<RegisterCollectorRequest, Operation> registerCollectorSettings;
    private final OperationCallSettings<RegisterCollectorRequest, Collector, OperationMetadata> registerCollectorOperationSettings;
    private final UnaryCallSettings<PauseCollectorRequest, Operation> pauseCollectorSettings;
    private final OperationCallSettings<PauseCollectorRequest, Collector, OperationMetadata> pauseCollectorOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, RapidMigrationAssessmentClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListCollectorsRequest, ListCollectorsResponse, Collector> LIST_COLLECTORS_PAGE_STR_DESC = new PagedListDescriptor<ListCollectorsRequest, ListCollectorsResponse, Collector>(){

        public String emptyToken() {
            return "";
        }

        public ListCollectorsRequest injectToken(ListCollectorsRequest payload, String token) {
            return ListCollectorsRequest.newBuilder((ListCollectorsRequest)payload).setPageToken(token).build();
        }

        public ListCollectorsRequest injectPageSize(ListCollectorsRequest payload, int pageSize) {
            return ListCollectorsRequest.newBuilder((ListCollectorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCollectorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCollectorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Collector> extractResources(ListCollectorsResponse payload) {
            return payload.getCollectorsList() == null ? ImmutableList.of() : payload.getCollectorsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListCollectorsRequest, ListCollectorsResponse, RapidMigrationAssessmentClient.ListCollectorsPagedResponse> LIST_COLLECTORS_PAGE_STR_FACT = new PagedListResponseFactory<ListCollectorsRequest, ListCollectorsResponse, RapidMigrationAssessmentClient.ListCollectorsPagedResponse>(){

        public ApiFuture<RapidMigrationAssessmentClient.ListCollectorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCollectorsRequest, ListCollectorsResponse> callable, ListCollectorsRequest request, ApiCallContext context, ApiFuture<ListCollectorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_COLLECTORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RapidMigrationAssessmentClient.ListCollectorsPagedResponse.createAsync((PageContext<ListCollectorsRequest, ListCollectorsResponse, Collector>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, RapidMigrationAssessmentClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, RapidMigrationAssessmentClient.ListLocationsPagedResponse>(){

        public ApiFuture<RapidMigrationAssessmentClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RapidMigrationAssessmentClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateCollectorRequest, Operation> createCollectorSettings() {
        return this.createCollectorSettings;
    }

    public OperationCallSettings<CreateCollectorRequest, Collector, OperationMetadata> createCollectorOperationSettings() {
        return this.createCollectorOperationSettings;
    }

    public UnaryCallSettings<CreateAnnotationRequest, Operation> createAnnotationSettings() {
        return this.createAnnotationSettings;
    }

    public OperationCallSettings<CreateAnnotationRequest, Annotation, OperationMetadata> createAnnotationOperationSettings() {
        return this.createAnnotationOperationSettings;
    }

    public UnaryCallSettings<GetAnnotationRequest, Annotation> getAnnotationSettings() {
        return this.getAnnotationSettings;
    }

    public PagedCallSettings<ListCollectorsRequest, ListCollectorsResponse, RapidMigrationAssessmentClient.ListCollectorsPagedResponse> listCollectorsSettings() {
        return this.listCollectorsSettings;
    }

    public UnaryCallSettings<GetCollectorRequest, Collector> getCollectorSettings() {
        return this.getCollectorSettings;
    }

    public UnaryCallSettings<UpdateCollectorRequest, Operation> updateCollectorSettings() {
        return this.updateCollectorSettings;
    }

    public OperationCallSettings<UpdateCollectorRequest, Collector, OperationMetadata> updateCollectorOperationSettings() {
        return this.updateCollectorOperationSettings;
    }

    public UnaryCallSettings<DeleteCollectorRequest, Operation> deleteCollectorSettings() {
        return this.deleteCollectorSettings;
    }

    public OperationCallSettings<DeleteCollectorRequest, Collector, OperationMetadata> deleteCollectorOperationSettings() {
        return this.deleteCollectorOperationSettings;
    }

    public UnaryCallSettings<ResumeCollectorRequest, Operation> resumeCollectorSettings() {
        return this.resumeCollectorSettings;
    }

    public OperationCallSettings<ResumeCollectorRequest, Collector, OperationMetadata> resumeCollectorOperationSettings() {
        return this.resumeCollectorOperationSettings;
    }

    public UnaryCallSettings<RegisterCollectorRequest, Operation> registerCollectorSettings() {
        return this.registerCollectorSettings;
    }

    public OperationCallSettings<RegisterCollectorRequest, Collector, OperationMetadata> registerCollectorOperationSettings() {
        return this.registerCollectorOperationSettings;
    }

    public UnaryCallSettings<PauseCollectorRequest, Operation> pauseCollectorSettings() {
        return this.pauseCollectorSettings;
    }

    public OperationCallSettings<PauseCollectorRequest, Collector, OperationMetadata> pauseCollectorOperationSettings() {
        return this.pauseCollectorOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, RapidMigrationAssessmentClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public RapidMigrationAssessmentStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRapidMigrationAssessmentStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRapidMigrationAssessmentStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return RapidMigrationAssessmentStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "rapidmigrationassessment";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "rapidmigrationassessment.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "rapidmigrationassessment.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RapidMigrationAssessmentStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RapidMigrationAssessmentStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RapidMigrationAssessmentStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return RapidMigrationAssessmentStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RapidMigrationAssessmentStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createCollectorSettings = settingsBuilder.createCollectorSettings().build();
        this.createCollectorOperationSettings = settingsBuilder.createCollectorOperationSettings().build();
        this.createAnnotationSettings = settingsBuilder.createAnnotationSettings().build();
        this.createAnnotationOperationSettings = settingsBuilder.createAnnotationOperationSettings().build();
        this.getAnnotationSettings = settingsBuilder.getAnnotationSettings().build();
        this.listCollectorsSettings = settingsBuilder.listCollectorsSettings().build();
        this.getCollectorSettings = settingsBuilder.getCollectorSettings().build();
        this.updateCollectorSettings = settingsBuilder.updateCollectorSettings().build();
        this.updateCollectorOperationSettings = settingsBuilder.updateCollectorOperationSettings().build();
        this.deleteCollectorSettings = settingsBuilder.deleteCollectorSettings().build();
        this.deleteCollectorOperationSettings = settingsBuilder.deleteCollectorOperationSettings().build();
        this.resumeCollectorSettings = settingsBuilder.resumeCollectorSettings().build();
        this.resumeCollectorOperationSettings = settingsBuilder.resumeCollectorOperationSettings().build();
        this.registerCollectorSettings = settingsBuilder.registerCollectorSettings().build();
        this.registerCollectorOperationSettings = settingsBuilder.registerCollectorOperationSettings().build();
        this.pauseCollectorSettings = settingsBuilder.pauseCollectorSettings().build();
        this.pauseCollectorOperationSettings = settingsBuilder.pauseCollectorOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RapidMigrationAssessmentStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateCollectorRequest, Operation> createCollectorSettings;
        private final OperationCallSettings.Builder<CreateCollectorRequest, Collector, OperationMetadata> createCollectorOperationSettings;
        private final UnaryCallSettings.Builder<CreateAnnotationRequest, Operation> createAnnotationSettings;
        private final OperationCallSettings.Builder<CreateAnnotationRequest, Annotation, OperationMetadata> createAnnotationOperationSettings;
        private final UnaryCallSettings.Builder<GetAnnotationRequest, Annotation> getAnnotationSettings;
        private final PagedCallSettings.Builder<ListCollectorsRequest, ListCollectorsResponse, RapidMigrationAssessmentClient.ListCollectorsPagedResponse> listCollectorsSettings;
        private final UnaryCallSettings.Builder<GetCollectorRequest, Collector> getCollectorSettings;
        private final UnaryCallSettings.Builder<UpdateCollectorRequest, Operation> updateCollectorSettings;
        private final OperationCallSettings.Builder<UpdateCollectorRequest, Collector, OperationMetadata> updateCollectorOperationSettings;
        private final UnaryCallSettings.Builder<DeleteCollectorRequest, Operation> deleteCollectorSettings;
        private final OperationCallSettings.Builder<DeleteCollectorRequest, Collector, OperationMetadata> deleteCollectorOperationSettings;
        private final UnaryCallSettings.Builder<ResumeCollectorRequest, Operation> resumeCollectorSettings;
        private final OperationCallSettings.Builder<ResumeCollectorRequest, Collector, OperationMetadata> resumeCollectorOperationSettings;
        private final UnaryCallSettings.Builder<RegisterCollectorRequest, Operation> registerCollectorSettings;
        private final OperationCallSettings.Builder<RegisterCollectorRequest, Collector, OperationMetadata> registerCollectorOperationSettings;
        private final UnaryCallSettings.Builder<PauseCollectorRequest, Operation> pauseCollectorSettings;
        private final OperationCallSettings.Builder<PauseCollectorRequest, Collector, OperationMetadata> pauseCollectorOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, RapidMigrationAssessmentClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createCollectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCollectorOperationSettings = OperationCallSettings.newBuilder();
            this.createAnnotationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAnnotationOperationSettings = OperationCallSettings.newBuilder();
            this.getAnnotationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCollectorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_COLLECTORS_PAGE_STR_FACT);
            this.getCollectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCollectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCollectorOperationSettings = OperationCallSettings.newBuilder();
            this.deleteCollectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCollectorOperationSettings = OperationCallSettings.newBuilder();
            this.resumeCollectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resumeCollectorOperationSettings = OperationCallSettings.newBuilder();
            this.registerCollectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.registerCollectorOperationSettings = OperationCallSettings.newBuilder();
            this.pauseCollectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.pauseCollectorOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCollectorSettings, this.createAnnotationSettings, this.getAnnotationSettings, this.listCollectorsSettings, this.getCollectorSettings, this.updateCollectorSettings, this.deleteCollectorSettings, this.resumeCollectorSettings, this.registerCollectorSettings, this.pauseCollectorSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(RapidMigrationAssessmentStubSettings settings) {
            super((StubSettings)settings);
            this.createCollectorSettings = settings.createCollectorSettings.toBuilder();
            this.createCollectorOperationSettings = settings.createCollectorOperationSettings.toBuilder();
            this.createAnnotationSettings = settings.createAnnotationSettings.toBuilder();
            this.createAnnotationOperationSettings = settings.createAnnotationOperationSettings.toBuilder();
            this.getAnnotationSettings = settings.getAnnotationSettings.toBuilder();
            this.listCollectorsSettings = settings.listCollectorsSettings.toBuilder();
            this.getCollectorSettings = settings.getCollectorSettings.toBuilder();
            this.updateCollectorSettings = settings.updateCollectorSettings.toBuilder();
            this.updateCollectorOperationSettings = settings.updateCollectorOperationSettings.toBuilder();
            this.deleteCollectorSettings = settings.deleteCollectorSettings.toBuilder();
            this.deleteCollectorOperationSettings = settings.deleteCollectorOperationSettings.toBuilder();
            this.resumeCollectorSettings = settings.resumeCollectorSettings.toBuilder();
            this.resumeCollectorOperationSettings = settings.resumeCollectorOperationSettings.toBuilder();
            this.registerCollectorSettings = settings.registerCollectorSettings.toBuilder();
            this.registerCollectorOperationSettings = settings.registerCollectorOperationSettings.toBuilder();
            this.pauseCollectorSettings = settings.pauseCollectorSettings.toBuilder();
            this.pauseCollectorOperationSettings = settings.pauseCollectorOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCollectorSettings, this.createAnnotationSettings, this.getAnnotationSettings, this.listCollectorsSettings, this.getCollectorSettings, this.updateCollectorSettings, this.deleteCollectorSettings, this.resumeCollectorSettings, this.registerCollectorSettings, this.pauseCollectorSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RapidMigrationAssessmentStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RapidMigrationAssessmentStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RapidMigrationAssessmentStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RapidMigrationAssessmentStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)RapidMigrationAssessmentStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)RapidMigrationAssessmentStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RapidMigrationAssessmentStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RapidMigrationAssessmentStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createCollectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createAnnotationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAnnotationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listCollectorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCollectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateCollectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteCollectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resumeCollectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.registerCollectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.pauseCollectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createCollectorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Collector.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createAnnotationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Annotation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateCollectorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Collector.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteCollectorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Collector.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.resumeCollectorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Collector.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.registerCollectorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Collector.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.pauseCollectorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Collector.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateCollectorRequest, Operation> createCollectorSettings() {
            return this.createCollectorSettings;
        }

        public OperationCallSettings.Builder<CreateCollectorRequest, Collector, OperationMetadata> createCollectorOperationSettings() {
            return this.createCollectorOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateAnnotationRequest, Operation> createAnnotationSettings() {
            return this.createAnnotationSettings;
        }

        public OperationCallSettings.Builder<CreateAnnotationRequest, Annotation, OperationMetadata> createAnnotationOperationSettings() {
            return this.createAnnotationOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAnnotationRequest, Annotation> getAnnotationSettings() {
            return this.getAnnotationSettings;
        }

        public PagedCallSettings.Builder<ListCollectorsRequest, ListCollectorsResponse, RapidMigrationAssessmentClient.ListCollectorsPagedResponse> listCollectorsSettings() {
            return this.listCollectorsSettings;
        }

        public UnaryCallSettings.Builder<GetCollectorRequest, Collector> getCollectorSettings() {
            return this.getCollectorSettings;
        }

        public UnaryCallSettings.Builder<UpdateCollectorRequest, Operation> updateCollectorSettings() {
            return this.updateCollectorSettings;
        }

        public OperationCallSettings.Builder<UpdateCollectorRequest, Collector, OperationMetadata> updateCollectorOperationSettings() {
            return this.updateCollectorOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteCollectorRequest, Operation> deleteCollectorSettings() {
            return this.deleteCollectorSettings;
        }

        public OperationCallSettings.Builder<DeleteCollectorRequest, Collector, OperationMetadata> deleteCollectorOperationSettings() {
            return this.deleteCollectorOperationSettings;
        }

        public UnaryCallSettings.Builder<ResumeCollectorRequest, Operation> resumeCollectorSettings() {
            return this.resumeCollectorSettings;
        }

        public OperationCallSettings.Builder<ResumeCollectorRequest, Collector, OperationMetadata> resumeCollectorOperationSettings() {
            return this.resumeCollectorOperationSettings;
        }

        public UnaryCallSettings.Builder<RegisterCollectorRequest, Operation> registerCollectorSettings() {
            return this.registerCollectorSettings;
        }

        public OperationCallSettings.Builder<RegisterCollectorRequest, Collector, OperationMetadata> registerCollectorOperationSettings() {
            return this.registerCollectorOperationSettings;
        }

        public UnaryCallSettings.Builder<PauseCollectorRequest, Operation> pauseCollectorSettings() {
            return this.pauseCollectorSettings;
        }

        public OperationCallSettings.Builder<PauseCollectorRequest, Collector, OperationMetadata> pauseCollectorOperationSettings() {
            return this.pauseCollectorOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, RapidMigrationAssessmentClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return RapidMigrationAssessmentStubSettings.getDefaultEndpoint();
        }

        public RapidMigrationAssessmentStubSettings build() throws IOException {
            return new RapidMigrationAssessmentStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

