package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceClient;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AssignerSettings extends AssignerSettings {

  private final SubscriptionPath subscriptionPath;

  private final PartitionAssignmentReceiver receiver;

  private final PartitionAssignmentServiceClient serviceClient;

  private AutoValue_AssignerSettings(
      SubscriptionPath subscriptionPath,
      PartitionAssignmentReceiver receiver,
      PartitionAssignmentServiceClient serviceClient) {
    this.subscriptionPath = subscriptionPath;
    this.receiver = receiver;
    this.serviceClient = serviceClient;
  }

  @Override
  SubscriptionPath subscriptionPath() {
    return subscriptionPath;
  }

  @Override
  PartitionAssignmentReceiver receiver() {
    return receiver;
  }

  @Override
  PartitionAssignmentServiceClient serviceClient() {
    return serviceClient;
  }

  @Override
  public String toString() {
    return "AssignerSettings{"
        + "subscriptionPath=" + subscriptionPath + ", "
        + "receiver=" + receiver + ", "
        + "serviceClient=" + serviceClient
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AssignerSettings) {
      AssignerSettings that = (AssignerSettings) o;
      return this.subscriptionPath.equals(that.subscriptionPath())
          && this.receiver.equals(that.receiver())
          && this.serviceClient.equals(that.serviceClient());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= subscriptionPath.hashCode();
    h$ *= 1000003;
    h$ ^= receiver.hashCode();
    h$ *= 1000003;
    h$ ^= serviceClient.hashCode();
    return h$;
  }

  static final class Builder extends AssignerSettings.Builder {
    private SubscriptionPath subscriptionPath;
    private PartitionAssignmentReceiver receiver;
    private PartitionAssignmentServiceClient serviceClient;
    Builder() {
    }
    @Override
    public AssignerSettings.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
      if (subscriptionPath == null) {
        throw new NullPointerException("Null subscriptionPath");
      }
      this.subscriptionPath = subscriptionPath;
      return this;
    }
    @Override
    public AssignerSettings.Builder setReceiver(PartitionAssignmentReceiver receiver) {
      if (receiver == null) {
        throw new NullPointerException("Null receiver");
      }
      this.receiver = receiver;
      return this;
    }
    @Override
    public AssignerSettings.Builder setServiceClient(PartitionAssignmentServiceClient serviceClient) {
      if (serviceClient == null) {
        throw new NullPointerException("Null serviceClient");
      }
      this.serviceClient = serviceClient;
      return this;
    }
    @Override
    public AssignerSettings build() {
      if (this.subscriptionPath == null
          || this.receiver == null
          || this.serviceClient == null) {
        StringBuilder missing = new StringBuilder();
        if (this.subscriptionPath == null) {
          missing.append(" subscriptionPath");
        }
        if (this.receiver == null) {
          missing.append(" receiver");
        }
        if (this.serviceClient == null) {
          missing.append(" serviceClient");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AssignerSettings(
          this.subscriptionPath,
          this.receiver,
          this.serviceClient);
    }
  }

}
