/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.CheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.Predicates;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Optional;

public class NextOffsetTracker {
    private Optional<Offset> nextOffset = Optional.empty();

    void onMessages(Collection<SequencedMessage> messages) throws CheckedApiException {
        CheckedApiPreconditions.checkArgument(!messages.isEmpty());
        CheckedApiPreconditions.checkArgument(Predicates.isOrdered(messages));
        long firstMessageOffset = messages.iterator().next().getCursor().getOffset();
        CheckedApiPreconditions.checkState(!this.nextOffset.isPresent() || this.nextOffset.get().value() <= firstMessageOffset, String.format("Received message with offset %s older than known cursor location %s.", firstMessageOffset, this.nextOffset));
        this.nextOffset = Optional.of(Offset.of(((SequencedMessage)Iterables.getLast(messages)).getCursor().getOffset() + 1L));
    }

    Optional<SeekRequest> requestForRestart() {
        return this.nextOffset.map(offset -> SeekRequest.newBuilder().setCursor(Cursor.newBuilder().setOffset(offset.value())).build());
    }

    void reset() {
        this.nextOffset = Optional.empty();
    }
}

