/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ApiResourceAggregation;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.cloud.pubsublite.proto.ComputeHeadCursorRequest;
import com.google.cloud.pubsublite.proto.ComputeHeadCursorResponse;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import com.google.cloud.pubsublite.proto.ComputeTimeCursorRequest;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.TimeTarget;
import com.google.cloud.pubsublite.v1.TopicStatsServiceClient;
import com.google.protobuf.Timestamp;
import java.util.Optional;
import java.util.concurrent.Executor;

public class TopicStatsClientImpl
extends ApiResourceAggregation
implements TopicStatsClient {
    private final CloudRegion region;
    private final TopicStatsServiceClient serviceClient;

    public TopicStatsClientImpl(CloudRegion region, TopicStatsServiceClient serviceClient) {
        super(serviceClient);
        this.region = region;
        this.serviceClient = serviceClient;
    }

    @Override
    public CloudRegion region() {
        return this.region;
    }

    @Override
    public ApiFuture<ComputeMessageStatsResponse> computeMessageStats(TopicPath path, Partition partition, Offset start, Offset end) {
        return this.serviceClient.computeMessageStatsCallable().futureCall((Object)ComputeMessageStatsRequest.newBuilder().setTopic(path.toString()).setPartition(partition.value()).setStartCursor(Cursor.newBuilder().setOffset(start.value()).build()).setEndCursor(Cursor.newBuilder().setOffset(end.value()).build()).build());
    }

    @Override
    public ApiFuture<Cursor> computeHeadCursor(TopicPath path, Partition partition) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.computeHeadCursorCallable().futureCall((Object)ComputeHeadCursorRequest.newBuilder().setTopic(path.toString()).setPartition(partition.value()).build()), ComputeHeadCursorResponse::getHeadCursor, (Executor)SystemExecutors.getFuturesExecutor());
    }

    @Override
    public ApiFuture<Optional<Cursor>> computeCursorForPublishTime(TopicPath path, Partition partition, Timestamp publishTime) {
        return this.computeTimeCursor(path, partition, TimeTarget.newBuilder().setPublishTime(publishTime).build());
    }

    @Override
    public ApiFuture<Optional<Cursor>> computeCursorForEventTime(TopicPath path, Partition partition, Timestamp eventTime) {
        return this.computeTimeCursor(path, partition, TimeTarget.newBuilder().setEventTime(eventTime).build());
    }

    private ApiFuture<Optional<Cursor>> computeTimeCursor(TopicPath path, Partition partition, TimeTarget target) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.computeTimeCursorCallable().futureCall((Object)ComputeTimeCursorRequest.newBuilder().setTopic(path.toString()).setPartition(partition.value()).setTarget(target).build()), response -> {
            if (response.hasCursor()) {
                return Optional.of(response.getCursor());
            }
            return Optional.empty();
        }, (Executor)SystemExecutors.getFuturesExecutor());
    }
}

