/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.common.flogger.GoogleLogger;
import java.time.Duration;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public interface AlarmFactory {
    public Future<?> newAlarm(Runnable var1);

    public static AlarmFactory create(Duration duration) {
        return runnable -> SystemExecutors.getAlarmExecutor().scheduleWithFixedDelay(() -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                ((GoogleLogger.Api)((GoogleLogger.Api)Internal.LOGGER.atSevere()).withCause(t)).log("Alarm leaked exception.");
            }
        }, 0L, duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public static final class Internal {
        private static final GoogleLogger LOGGER = GoogleLogger.forEnclosingClass();
    }
}

