/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class RoutingMetadata {
    private static final String PARAMS_HEADER = "x-goog-request-params";
    private final Map<String, String> metadata;

    public static RoutingMetadata of(TopicPath topic, Partition partition) throws ApiException {
        return new RoutingMetadata(topic, partition);
    }

    public static RoutingMetadata of(SubscriptionPath subscription, Partition partition) throws ApiException {
        return new RoutingMetadata(subscription, partition);
    }

    private RoutingMetadata(TopicPath topic, Partition partition) {
        try {
            String topic_value = URLEncoder.encode(topic.toString(), StandardCharsets.UTF_8.toString());
            String params = String.format("partition=%s&topic=%s", partition.value(), topic_value);
            this.metadata = ImmutableMap.of((Object)PARAMS_HEADER, (Object)params);
        }
        catch (UnsupportedEncodingException e) {
            throw ExtractStatus.toCanonical((Throwable)e).underlying;
        }
    }

    private RoutingMetadata(SubscriptionPath subscription, Partition partition) {
        try {
            String subscription_value = URLEncoder.encode(subscription.toString(), StandardCharsets.UTF_8.toString());
            String params = String.format("partition=%s&subscription=%s", partition.value(), subscription_value);
            this.metadata = ImmutableMap.of((Object)PARAMS_HEADER, (Object)params);
        }
        catch (UnsupportedEncodingException e) {
            throw ExtractStatus.toCanonical((Throwable)e).underlying;
        }
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

