/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.CheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.ConnectedSubscriber;
import com.google.cloud.pubsublite.internal.wire.ConnectedSubscriberFactory;
import com.google.cloud.pubsublite.internal.wire.Predicates;
import com.google.cloud.pubsublite.internal.wire.SingleConnection;
import com.google.cloud.pubsublite.internal.wire.StreamFactories;
import com.google.cloud.pubsublite.internal.wire.StreamFactory;
import com.google.cloud.pubsublite.proto.FlowControlRequest;
import com.google.cloud.pubsublite.proto.MessageResponse;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.cloud.pubsublite.proto.SubscribeRequest;
import com.google.cloud.pubsublite.proto.SubscribeResponse;
import com.google.common.base.Preconditions;
import java.util.List;

class ConnectedSubscriberImpl
extends SingleConnection<SubscribeRequest, SubscribeResponse, List<SequencedMessage>>
implements ConnectedSubscriber {
    private final SubscribeRequest initialRequest;

    private ConnectedSubscriberImpl(StreamFactories.SubscribeStreamFactory streamFactory, ResponseObserver<List<SequencedMessage>> clientStream, SubscribeRequest initialRequest) {
        super(streamFactory, clientStream);
        this.initialRequest = initialRequest;
        this.initialize(initialRequest);
    }

    @Override
    public void allowFlow(FlowControlRequest request) {
        Preconditions.checkArgument((request.getAllowedBytes() >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((request.getAllowedMessages() >= 0L ? 1 : 0) != 0);
        this.sendToStream(SubscribeRequest.newBuilder().setFlowControl(request).build());
    }

    @Override
    protected void handleStreamResponse(SubscribeResponse response) throws CheckedApiException {
        switch (response.getResponseCase()) {
            case INITIAL: {
                return;
            }
            case MESSAGES: {
                this.onMessages(response.getMessages());
                return;
            }
            case SEEK: {
                throw new CheckedApiException(String.format("Received seek response from client which never sends seek requests %s.", this.initialRequest), StatusCode.Code.FAILED_PRECONDITION);
            }
        }
        throw new CheckedApiException("Received a message on the stream with no case set.", StatusCode.Code.FAILED_PRECONDITION);
    }

    private void onMessages(MessageResponse response) throws CheckedApiException {
        CheckedApiPreconditions.checkState(response.getMessagesCount() > 0, "Received an empty MessageResponse on stream with initial request %s.", this.initialRequest);
        CheckedApiPreconditions.checkState(Predicates.isOrdered(response.getMessagesList()), "Received out of order messages on the stream with initial request %s.", this.initialRequest);
        this.sendToClient(response.getMessagesList());
    }

    static class Factory
    implements ConnectedSubscriberFactory {
        Factory() {
        }

        @Override
        public ConnectedSubscriberImpl New(StreamFactory<SubscribeRequest, SubscribeResponse> streamFactory, ResponseObserver<List<SequencedMessage>> clientStream, SubscribeRequest initialRequest) {
            return new ConnectedSubscriberImpl(streamFactory::New, clientStream, initialRequest);
        }
    }
}

