/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.wire.Assigner;
import com.google.cloud.pubsublite.internal.wire.AssignerImpl;
import com.google.cloud.pubsublite.internal.wire.AutoValue_AssignerSettings;
import com.google.cloud.pubsublite.internal.wire.PartitionAssignmentReceiver;
import com.google.cloud.pubsublite.internal.wire.UuidBuilder;
import com.google.cloud.pubsublite.proto.InitialPartitionAssignmentRequest;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceClient;
import com.google.common.flogger.GoogleLogger;
import java.util.UUID;

@AutoValue
public abstract class AssignerSettings {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    abstract SubscriptionPath subscriptionPath();

    abstract PartitionAssignmentReceiver receiver();

    abstract PartitionAssignmentServiceClient serviceClient();

    abstract UUID uuid();

    public static Builder newBuilder() {
        return new AutoValue_AssignerSettings.Builder().setUuid(UuidBuilder.generate());
    }

    public Assigner instantiate() {
        ((GoogleLogger.Api)logger.atInfo()).log("Subscription %s using UUID %s for assignment.", (Object)this.subscriptionPath(), (Object)this.uuid());
        InitialPartitionAssignmentRequest initial = InitialPartitionAssignmentRequest.newBuilder().setSubscription(this.subscriptionPath().toString()).setClientId(UuidBuilder.toByteString(this.uuid())).build();
        return new AssignerImpl(this.serviceClient(), initial, this.receiver());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setReceiver(PartitionAssignmentReceiver var1);

        public abstract Builder setServiceClient(PartitionAssignmentServiceClient var1);

        public abstract Builder setUuid(UUID var1);

        public abstract AssignerSettings build();
    }
}

