/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.cloud.pubsublite.CloudRegionOrZone;
import com.google.cloud.pubsublite.ProjectIdOrNumber;
import com.google.cloud.pubsublite.TopicName;
import com.google.cloud.pubsublite.TopicPath;

final class AutoValue_TopicPath
extends TopicPath {
    private final ProjectIdOrNumber project;
    private final CloudRegionOrZone location;
    private final TopicName name;

    private AutoValue_TopicPath(ProjectIdOrNumber project, CloudRegionOrZone location, TopicName name) {
        this.project = project;
        this.location = location;
        this.name = name;
    }

    @Override
    public ProjectIdOrNumber project() {
        return this.project;
    }

    @Override
    public CloudRegionOrZone location() {
        return this.location;
    }

    @Override
    public TopicName name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TopicPath) {
            TopicPath that = (TopicPath)o;
            return this.project.equals(that.project()) && this.location.equals(that.location()) && this.name.equals(that.name());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.project.hashCode();
        h$ *= 1000003;
        h$ ^= this.location.hashCode();
        h$ *= 1000003;
        return h$ ^= this.name.hashCode();
    }

    @Override
    public TopicPath.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TopicPath.Builder {
        private ProjectIdOrNumber project;
        private CloudRegionOrZone location;
        private TopicName name;

        Builder() {
        }

        private Builder(TopicPath source) {
            this.project = source.project();
            this.location = source.location();
            this.name = source.name();
        }

        @Override
        public TopicPath.Builder setProject(ProjectIdOrNumber project) {
            if (project == null) {
                throw new NullPointerException("Null project");
            }
            this.project = project;
            return this;
        }

        @Override
        TopicPath.Builder setLocation(CloudRegionOrZone location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public TopicPath.Builder setName(TopicName name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public TopicPath build() {
            if (this.project == null || this.location == null || this.name == null) {
                StringBuilder missing = new StringBuilder();
                if (this.project == null) {
                    missing.append(" project");
                }
                if (this.location == null) {
                    missing.append(" location");
                }
                if (this.name == null) {
                    missing.append(" name");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TopicPath(this.project, this.location, this.name);
        }
    }
}

