/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.PublishMetadata;
import com.google.cloud.pubsublite.cloudpubsub.Publisher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.TrivialProxyService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.pubsub.v1.PubsubMessage;
import java.util.concurrent.Executor;

public class WrappingPublisher
extends TrivialProxyService
implements Publisher {
    private final com.google.cloud.pubsublite.internal.Publisher<PublishMetadata> wirePublisher;
    private final MessageTransformer<PubsubMessage, Message> transformer;

    public WrappingPublisher(com.google.cloud.pubsublite.internal.Publisher<PublishMetadata> wirePublisher, MessageTransformer<PubsubMessage, Message> transformer) throws ApiException {
        super(wirePublisher);
        this.wirePublisher = wirePublisher;
        this.transformer = transformer;
    }

    public ApiFuture<String> publish(PubsubMessage message) {
        Message wireMessage;
        try {
            wireMessage = this.transformer.transform(message);
        }
        catch (Throwable t) {
            CheckedApiException e = ExtractStatus.toCanonical(t);
            this.onPermanentError(e);
            return ApiFutures.immediateFailedFuture((Throwable)e.underlying);
        }
        return ApiFutures.transform(this.wirePublisher.publish(wireMessage), PublishMetadata::encode, (Executor)MoreExecutors.directExecutor());
    }
}

