/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.wire.PartitionPublisherFactory;
import com.google.cloud.pubsublite.internal.wire.RoutingPublisherBuilder;
import java.util.Optional;

final class AutoValue_RoutingPublisherBuilder
extends RoutingPublisherBuilder {
    private final TopicPath topic;
    private final PartitionPublisherFactory publisherFactory;
    private final Optional<Integer> numPartitions;

    private AutoValue_RoutingPublisherBuilder(TopicPath topic, PartitionPublisherFactory publisherFactory, Optional<Integer> numPartitions) {
        this.topic = topic;
        this.publisherFactory = publisherFactory;
        this.numPartitions = numPartitions;
    }

    @Override
    TopicPath topic() {
        return this.topic;
    }

    @Override
    PartitionPublisherFactory publisherFactory() {
        return this.publisherFactory;
    }

    @Override
    Optional<Integer> numPartitions() {
        return this.numPartitions;
    }

    public String toString() {
        return "RoutingPublisherBuilder{topic=" + this.topic + ", publisherFactory=" + this.publisherFactory + ", numPartitions=" + this.numPartitions + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RoutingPublisherBuilder) {
            RoutingPublisherBuilder that = (RoutingPublisherBuilder)o;
            return this.topic.equals(that.topic()) && this.publisherFactory.equals(that.publisherFactory()) && this.numPartitions.equals(that.numPartitions());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.publisherFactory.hashCode();
        h$ *= 1000003;
        return h$ ^= this.numPartitions.hashCode();
    }

    static final class Builder
    extends RoutingPublisherBuilder.Builder {
        private TopicPath topic;
        private PartitionPublisherFactory publisherFactory;
        private Optional<Integer> numPartitions = Optional.empty();

        Builder() {
        }

        @Override
        public RoutingPublisherBuilder.Builder setTopic(TopicPath topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public RoutingPublisherBuilder.Builder setPublisherFactory(PartitionPublisherFactory publisherFactory) {
            if (publisherFactory == null) {
                throw new NullPointerException("Null publisherFactory");
            }
            this.publisherFactory = publisherFactory;
            return this;
        }

        @Override
        public RoutingPublisherBuilder.Builder setNumPartitions(Integer numPartitions) {
            this.numPartitions = Optional.of(numPartitions);
            return this;
        }

        @Override
        RoutingPublisherBuilder autoBuild() {
            String missing = "";
            if (this.topic == null) {
                missing = missing + " topic";
            }
            if (this.publisherFactory == null) {
                missing = missing + " publisherFactory";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RoutingPublisherBuilder(this.topic, this.publisherFactory, this.numPartitions);
        }
    }
}

