/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiService;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ProxyService
extends AbstractApiService {
    private final List<ApiService> services = new ArrayList<ApiService>();
    private final AtomicBoolean stoppedOrFailed = new AtomicBoolean(false);

    protected ProxyService() {
    }

    protected final <T extends ApiService> void addServices(Collection<T> services) throws ApiException {
        UncheckedApiPreconditions.checkState(this.state() == ApiService.State.NEW);
        for (ApiService service : services) {
            UncheckedApiPreconditions.checkArgument(service.state() == ApiService.State.NEW, "All services must not be started.");
            this.services.add(service);
        }
    }

    protected final void addServices(ApiService ... services) throws ApiException {
        this.addServices((Collection)ImmutableList.copyOf((Object[])services));
    }

    protected abstract void start() throws CheckedApiException;

    protected abstract void stop() throws CheckedApiException;

    protected abstract void handlePermanentError(CheckedApiException var1);

    protected final void onPermanentError(CheckedApiException error) {
        if (this.stoppedOrFailed.getAndSet(true)) {
            return;
        }
        for (ApiService service : this.services) {
            service.stopAsync();
        }
        this.handlePermanentError(error);
        this.notifyFailed(error.underlying);
    }

    protected final void doStart() {
        ApiService.Listener listener = new ApiService.Listener(){
            private final AtomicInteger leftToStart;
            {
                this.leftToStart = new AtomicInteger(ProxyService.this.services.size());
            }

            public void running() {
                if (this.leftToStart.decrementAndGet() == 0) {
                    try {
                        ProxyService.this.start();
                    }
                    catch (CheckedApiException e) {
                        ProxyService.this.onPermanentError(e);
                        return;
                    }
                    ProxyService.this.notifyStarted();
                }
            }

            public void failed(ApiService.State state, Throwable throwable) {
                ProxyService.this.onPermanentError(ExtractStatus.toCanonical(throwable));
            }
        };
        for (ApiService service : this.services) {
            service.addListener(listener, MoreExecutors.directExecutor());
            service.startAsync();
        }
    }

    protected final void doStop() {
        ApiService.Listener listener = new ApiService.Listener(){
            private final AtomicInteger leftToStart;
            {
                this.leftToStart = new AtomicInteger(ProxyService.this.services.size());
            }

            public void terminated(ApiService.State state) {
                if (this.leftToStart.decrementAndGet() == 0 && !ProxyService.this.stoppedOrFailed.getAndSet(true)) {
                    ProxyService.this.notifyStopped();
                }
            }
        };
        try {
            this.stop();
        }
        catch (CheckedApiException e) {
            this.onPermanentError(e);
            return;
        }
        for (ApiService service : this.services) {
            service.addListener(listener, MoreExecutors.directExecutor());
            service.stopAsync();
        }
    }
}

