/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.ProjectIdOrNumber;

final class AutoValue_LocationPath
extends LocationPath {
    private final ProjectIdOrNumber project;
    private final CloudZone location;

    private AutoValue_LocationPath(ProjectIdOrNumber project, CloudZone location) {
        this.project = project;
        this.location = location;
    }

    @Override
    public ProjectIdOrNumber project() {
        return this.project;
    }

    @Override
    public CloudZone location() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LocationPath) {
            LocationPath that = (LocationPath)o;
            return this.project.equals(that.project()) && this.location.equals(that.location());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.project.hashCode();
        h$ *= 1000003;
        return h$ ^= this.location.hashCode();
    }

    @Override
    public LocationPath.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends LocationPath.Builder {
        private ProjectIdOrNumber project;
        private CloudZone location;

        Builder() {
        }

        private Builder(LocationPath source) {
            this.project = source.project();
            this.location = source.location();
        }

        @Override
        public LocationPath.Builder setProject(ProjectIdOrNumber project) {
            if (project == null) {
                throw new NullPointerException("Null project");
            }
            this.project = project;
            return this;
        }

        @Override
        public LocationPath.Builder setLocation(CloudZone location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public LocationPath build() {
            String missing = "";
            if (this.project == null) {
                missing = missing + " project";
            }
            if (this.location == null) {
                missing = missing + " location";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_LocationPath(this.project, this.location);
        }
    }
}

