/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsublite.proto.CommitCursorRequest;
import com.google.cloud.pubsublite.proto.CommitCursorResponse;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsRequest;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsResponse;
import com.google.cloud.pubsublite.proto.StreamingCommitCursorRequest;
import com.google.cloud.pubsublite.proto.StreamingCommitCursorResponse;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.stub.CursorServiceStub;
import com.google.cloud.pubsublite.v1.stub.CursorServiceStubSettings;
import com.google.cloud.pubsublite.v1.stub.GrpcCursorServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcCursorServiceStub
extends CursorServiceStub {
    private static final MethodDescriptor<StreamingCommitCursorRequest, StreamingCommitCursorResponse> streamingCommitCursorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.pubsublite.v1.CursorService/StreamingCommitCursor").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamingCommitCursorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamingCommitCursorResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CommitCursorRequest, CommitCursorResponse> commitCursorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.CursorService/CommitCursor").setRequestMarshaller(ProtoUtils.marshaller((Message)CommitCursorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CommitCursorResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListPartitionCursorsRequest, ListPartitionCursorsResponse> listPartitionCursorsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.CursorService/ListPartitionCursors").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPartitionCursorsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPartitionCursorsResponse.getDefaultInstance())).build();
    private final BidiStreamingCallable<StreamingCommitCursorRequest, StreamingCommitCursorResponse> streamingCommitCursorCallable;
    private final UnaryCallable<CommitCursorRequest, CommitCursorResponse> commitCursorCallable;
    private final UnaryCallable<ListPartitionCursorsRequest, ListPartitionCursorsResponse> listPartitionCursorsCallable;
    private final UnaryCallable<ListPartitionCursorsRequest, CursorServiceClient.ListPartitionCursorsPagedResponse> listPartitionCursorsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCursorServiceStub create(CursorServiceStubSettings settings) throws IOException {
        return new GrpcCursorServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCursorServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCursorServiceStub(CursorServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCursorServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCursorServiceStub(CursorServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCursorServiceStub(CursorServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCursorServiceCallableFactory());
    }

    protected GrpcCursorServiceStub(CursorServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings streamingCommitCursorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamingCommitCursorMethodDescriptor).build();
        GrpcCallSettings commitCursorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(commitCursorMethodDescriptor).build();
        GrpcCallSettings listPartitionCursorsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPartitionCursorsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListPartitionCursorsRequest>(){

            public Map<String, String> extract(ListPartitionCursorsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        this.streamingCommitCursorCallable = callableFactory.createBidiStreamingCallable(streamingCommitCursorTransportSettings, settings.streamingCommitCursorSettings(), clientContext);
        this.commitCursorCallable = callableFactory.createUnaryCallable(commitCursorTransportSettings, settings.commitCursorSettings(), clientContext);
        this.listPartitionCursorsCallable = callableFactory.createUnaryCallable(listPartitionCursorsTransportSettings, settings.listPartitionCursorsSettings(), clientContext);
        this.listPartitionCursorsPagedCallable = callableFactory.createPagedCallable(listPartitionCursorsTransportSettings, settings.listPartitionCursorsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public BidiStreamingCallable<StreamingCommitCursorRequest, StreamingCommitCursorResponse> streamingCommitCursorCallable() {
        return this.streamingCommitCursorCallable;
    }

    @Override
    public UnaryCallable<CommitCursorRequest, CommitCursorResponse> commitCursorCallable() {
        return this.commitCursorCallable;
    }

    @Override
    public UnaryCallable<ListPartitionCursorsRequest, ListPartitionCursorsResponse> listPartitionCursorsCallable() {
        return this.listPartitionCursorsCallable;
    }

    @Override
    public UnaryCallable<ListPartitionCursorsRequest, CursorServiceClient.ListPartitionCursorsPagedResponse> listPartitionCursorsPagedCallable() {
        return this.listPartitionCursorsPagedCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

