/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Endpoints;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.Stubs;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.SubscriptionPaths;
import com.google.cloud.pubsublite.internal.wire.AutoValue_SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.internal.wire.SubscriberImpl;
import com.google.cloud.pubsublite.proto.InitialSubscribeRequest;
import com.google.cloud.pubsublite.proto.SubscriberServiceGrpc;
import com.google.common.collect.ImmutableList;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;

@AutoValue
public abstract class SubscriberBuilder {
    abstract Consumer<ImmutableList<SequencedMessage>> messageConsumer();

    abstract SubscriptionPath subscriptionPath();

    abstract Partition partition();

    abstract Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub();

    abstract PubsubContext context();

    public static Builder newBuilder() {
        return new AutoValue_SubscriberBuilder.Builder().setContext(PubsubContext.of());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMessageConsumer(Consumer<ImmutableList<SequencedMessage>> var1);

        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setSubscriberServiceStub(SubscriberServiceGrpc.SubscriberServiceStub var1);

        public abstract Builder setContext(PubsubContext var1);

        abstract SubscriberBuilder autoBuild();

        public Subscriber build() throws StatusException {
            SubscriberServiceGrpc.SubscriberServiceStub subscriberServiceStub;
            SubscriberBuilder builder = this.autoBuild();
            SubscriptionPaths.check(builder.subscriptionPath());
            if (builder.subscriberServiceStub().isPresent()) {
                subscriberServiceStub = builder.subscriberServiceStub().get();
            } else {
                try {
                    subscriberServiceStub = Stubs.defaultStub(Endpoints.regionalEndpoint(SubscriptionPaths.getZone(builder.subscriptionPath()).region()), SubscriberServiceGrpc::newStub);
                }
                catch (IOException e) {
                    throw Status.INTERNAL.withCause((Throwable)e).withDescription("Creating subscriber stub failed.").asException();
                }
            }
            Metadata metadata = builder.context().getMetadata();
            metadata.merge(RoutingMetadata.of(builder.subscriptionPath(), builder.partition()));
            subscriberServiceStub = (SubscriberServiceGrpc.SubscriberServiceStub)MetadataUtils.attachHeaders((AbstractStub)subscriberServiceStub, (Metadata)metadata);
            InitialSubscribeRequest initialSubscribeRequest = InitialSubscribeRequest.newBuilder().setSubscription(builder.subscriptionPath().value()).setPartition(builder.partition().value()).build();
            return new SubscriberImpl(subscriberServiceStub, initialSubscribeRequest, builder.messageConsumer());
        }
    }
}

