/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Endpoints;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.Stubs;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.SubscriptionPaths;
import com.google.cloud.pubsublite.internal.wire.AutoValue_CommitterBuilder;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.CommitterImpl;
import com.google.cloud.pubsublite.proto.CursorServiceGrpc;
import com.google.cloud.pubsublite.proto.InitialCommitCursorRequest;
import io.grpc.Status;
import io.grpc.StatusException;
import java.io.IOException;
import java.util.Optional;

@AutoValue
public abstract class CommitterBuilder {
    abstract SubscriptionPath subscriptionPath();

    abstract Partition partition();

    abstract Optional<CursorServiceGrpc.CursorServiceStub> cursorStub();

    public static Builder newBuilder() {
        return new AutoValue_CommitterBuilder.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setCursorStub(CursorServiceGrpc.CursorServiceStub var1);

        abstract CommitterBuilder autoBuild();

        public Committer build() throws StatusException {
            CursorServiceGrpc.CursorServiceStub cursorStub;
            CommitterBuilder builder = this.autoBuild();
            SubscriptionPaths.check(builder.subscriptionPath());
            if (builder.cursorStub().isPresent()) {
                cursorStub = builder.cursorStub().get();
            } else {
                try {
                    cursorStub = Stubs.defaultStub(Endpoints.regionalEndpoint(SubscriptionPaths.getZone(builder.subscriptionPath()).region()), CursorServiceGrpc::newStub);
                }
                catch (IOException e) {
                    throw Status.INTERNAL.withCause((Throwable)e).withDescription("Creating cursor stub failed.").asException();
                }
            }
            InitialCommitCursorRequest initialCommitCursorRequest = InitialCommitCursorRequest.newBuilder().setSubscription(builder.subscriptionPath().value()).setPartition(builder.partition().value()).build();
            return new CommitterImpl(cursorStub, initialCommitCursorRequest);
        }
    }
}

