/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.NanoClock;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.ErrorCodes;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.SubscriptionPaths;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.TopicPaths;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.proto.AdminServiceGrpc;
import com.google.cloud.pubsublite.proto.CreateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.CreateTopicRequest;
import com.google.cloud.pubsublite.proto.DeleteSubscriptionRequest;
import com.google.cloud.pubsublite.proto.DeleteTopicRequest;
import com.google.cloud.pubsublite.proto.GetSubscriptionRequest;
import com.google.cloud.pubsublite.proto.GetTopicPartitionsRequest;
import com.google.cloud.pubsublite.proto.GetTopicRequest;
import com.google.cloud.pubsublite.proto.ListSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListTopicsRequest;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.proto.Topic;
import com.google.cloud.pubsublite.proto.UpdateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.UpdateTopicRequest;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.FieldMask;
import io.grpc.Status;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class AdminClientImpl
extends BackgroundResourceAggregation
implements AdminClient {
    private final CloudRegion region;
    private final AdminServiceGrpc.AdminServiceBlockingStub stub;
    private final RetryingExecutor<Void> voidRetryingExecutor;
    private final RetryingExecutor<Topic> topicRetryingExecutor;
    private final RetryingExecutor<Subscription> subscriptionRetryingExecutor;
    private final RetryingExecutor<Long> partitionCountRetryingExecutor;
    private final RetryingExecutor<List<Topic>> listTopicsRetryingExecutor;
    private final RetryingExecutor<List<SubscriptionPath>> listTopicSubscriptionsRetryingExecutor;
    private final RetryingExecutor<List<Subscription>> listSubscriptionsRetryingExecutor;

    public AdminClientImpl(CloudRegion region, AdminServiceGrpc.AdminServiceBlockingStub stub, RetrySettings retrySettings) {
        this(region, stub, retrySettings, Executors.newScheduledThreadPool(6));
    }

    private AdminClientImpl(CloudRegion region, AdminServiceGrpc.AdminServiceBlockingStub stub, RetrySettings retrySettings, ScheduledExecutorService executor) {
        super((List)ImmutableList.of((Object)new ExecutorAsBackgroundResource((ExecutorService)executor)));
        this.region = region;
        this.stub = stub;
        this.voidRetryingExecutor = AdminClientImpl.retryingExecutor(retrySettings, executor);
        this.topicRetryingExecutor = AdminClientImpl.retryingExecutor(retrySettings, executor);
        this.subscriptionRetryingExecutor = AdminClientImpl.retryingExecutor(retrySettings, executor);
        this.partitionCountRetryingExecutor = AdminClientImpl.retryingExecutor(retrySettings, executor);
        this.listTopicsRetryingExecutor = AdminClientImpl.retryingExecutor(retrySettings, executor);
        this.listSubscriptionsRetryingExecutor = AdminClientImpl.retryingExecutor(retrySettings, executor);
        this.listTopicSubscriptionsRetryingExecutor = AdminClientImpl.retryingExecutor(retrySettings, executor);
    }

    private static <T> RetryingExecutor<T> retryingExecutor(RetrySettings settings, ScheduledExecutorService executor) {
        return new ScheduledRetryingExecutor(AdminClientImpl.retryAlgorithm(settings), executor);
    }

    private static <T> RetryAlgorithm<T> retryAlgorithm(RetrySettings retrySettings) {
        return new RetryAlgorithm(AdminClientImpl.resultRetryAlgorithm(), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(retrySettings, NanoClock.getDefaultClock()));
    }

    private static <T> ResultRetryAlgorithm<T> resultRetryAlgorithm() {
        return new ResultRetryAlgorithm<T>(){

            public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, T prevResponse, TimedAttemptSettings prevSettings) {
                return null;
            }

            public boolean shouldRetry(Throwable prevThrowable, T prevResponse) {
                if (null != prevResponse) {
                    return false;
                }
                Optional<Status> statusOr = ExtractStatus.extract(prevThrowable);
                if (!statusOr.isPresent()) {
                    return false;
                }
                return ErrorCodes.IsRetryable(statusOr.get().getCode());
            }
        };
    }

    @Override
    public CloudRegion region() {
        return this.region;
    }

    private static <T> ApiFuture<T> runWithRetries(Callable<T> callable, RetryingExecutor<T> executor) {
        RetryingFuture retryingFuture = executor.createFuture(callable);
        retryingFuture.setAttemptFuture(executor.submit(retryingFuture));
        return retryingFuture;
    }

    @Override
    public ApiFuture<Topic> createTopic(Topic topic) {
        return AdminClientImpl.runWithRetries(() -> {
            TopicPath path = TopicPath.of(topic.getName());
            return this.stub.createTopic(CreateTopicRequest.newBuilder().setParent(TopicPaths.getLocationPath(path).value()).setTopic(topic).setTopicId(TopicPaths.getTopicName(path).value()).build());
        }, this.topicRetryingExecutor);
    }

    @Override
    public ApiFuture<Topic> getTopic(TopicPath path) {
        return AdminClientImpl.runWithRetries(() -> this.stub.getTopic(GetTopicRequest.newBuilder().setName(path.value()).build()), this.topicRetryingExecutor);
    }

    @Override
    public ApiFuture<Long> getTopicPartitionCount(TopicPath path) {
        return AdminClientImpl.runWithRetries(() -> this.stub.getTopicPartitions(GetTopicPartitionsRequest.newBuilder().setName(path.value()).build()).getPartitionCount(), this.partitionCountRetryingExecutor);
    }

    @Override
    public ApiFuture<List<Topic>> listTopics(LocationPath path) {
        return AdminClientImpl.runWithRetries(() -> this.stub.listTopics(ListTopicsRequest.newBuilder().setParent(path.value()).build()).getTopicsList(), this.listTopicsRetryingExecutor);
    }

    @Override
    public ApiFuture<Topic> updateTopic(Topic topic, FieldMask mask) {
        return AdminClientImpl.runWithRetries(() -> this.stub.updateTopic(UpdateTopicRequest.newBuilder().setTopic(topic).setUpdateMask(mask).build()), this.topicRetryingExecutor);
    }

    @Override
    public ApiFuture<Void> deleteTopic(TopicPath path) {
        return AdminClientImpl.runWithRetries(() -> {
            this.stub.deleteTopic(DeleteTopicRequest.newBuilder().setName(path.value()).build());
            return null;
        }, this.voidRetryingExecutor);
    }

    @Override
    public ApiFuture<List<SubscriptionPath>> listTopicSubscriptions(TopicPath path) {
        return AdminClientImpl.runWithRetries(() -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String subscription : this.stub.listTopicSubscriptions(ListTopicSubscriptionsRequest.newBuilder().setName(path.value()).build()).getSubscriptionsList()) {
                SubscriptionPath subscription_path = SubscriptionPath.of(subscription);
                SubscriptionPaths.check(subscription_path);
                builder.add((Object)subscription_path);
            }
            return builder.build();
        }, this.listTopicSubscriptionsRetryingExecutor);
    }

    @Override
    public ApiFuture<Subscription> createSubscription(Subscription subscription) {
        return AdminClientImpl.runWithRetries(() -> {
            SubscriptionPath path = SubscriptionPath.of(subscription.getName());
            return this.stub.createSubscription(CreateSubscriptionRequest.newBuilder().setParent(SubscriptionPaths.getLocationPath(path).value()).setSubscription(subscription).setSubscriptionId(SubscriptionPaths.getSubscriptionName(path).value()).build());
        }, this.subscriptionRetryingExecutor);
    }

    @Override
    public ApiFuture<Subscription> getSubscription(SubscriptionPath path) {
        return AdminClientImpl.runWithRetries(() -> this.stub.getSubscription(GetSubscriptionRequest.newBuilder().setName(path.value()).build()), this.subscriptionRetryingExecutor);
    }

    @Override
    public ApiFuture<List<Subscription>> listSubscriptions(LocationPath path) {
        return AdminClientImpl.runWithRetries(() -> this.stub.listSubscriptions(ListSubscriptionsRequest.newBuilder().setParent(path.value()).build()).getSubscriptionsList(), this.listSubscriptionsRetryingExecutor);
    }

    @Override
    public ApiFuture<Subscription> updateSubscription(Subscription subscription, FieldMask mask) {
        return AdminClientImpl.runWithRetries(() -> this.stub.updateSubscription(UpdateSubscriptionRequest.newBuilder().setSubscription(subscription).setUpdateMask(mask).build()), this.subscriptionRetryingExecutor);
    }

    @Override
    public ApiFuture<Void> deleteSubscription(SubscriptionPath path) {
        return AdminClientImpl.runWithRetries(() -> {
            this.stub.deleteSubscription(DeleteSubscriptionRequest.newBuilder().setName(path.value()).build());
            return null;
        }, this.voidRetryingExecutor);
    }
}

