/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AutoValue_TopicPaths;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.LocationPaths;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.TopicName;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Preconditions;
import io.grpc.StatusException;

@AutoValue
public abstract class TopicPaths {
    abstract ProjectNumber projectNumber();

    abstract CloudZone zone();

    abstract TopicName topicName();

    public static Builder newBuilder() {
        return new AutoValue_TopicPaths.Builder();
    }

    private static void checkSplits(String[] splits) throws StatusException {
        Preconditions.checkArgument(splits.length == 6);
        Preconditions.checkArgument(splits[0].equals("projects"));
        Preconditions.checkArgument(splits[2].equals("locations"));
        Preconditions.checkArgument(splits[4].equals("topics"));
    }

    public static void check(TopicPath path) throws StatusException {
        ProjectNumber unusedProjectNumber = TopicPaths.getProjectNumber(path);
        CloudZone unusedZone = TopicPaths.getZone(path);
        TopicName unusedName = TopicPaths.getTopicName(path);
    }

    public static ProjectNumber getProjectNumber(TopicPath path) throws StatusException {
        String[] splits = path.value().split("/");
        TopicPaths.checkSplits(splits);
        try {
            return ProjectNumber.of(Long.parseLong(splits[1]));
        }
        catch (NumberFormatException e) {
            throw ExtractStatus.toCanonical(e);
        }
    }

    public static CloudZone getZone(TopicPath path) throws StatusException {
        String[] splits = path.value().split("/");
        TopicPaths.checkSplits(splits);
        return CloudZone.parse(splits[3]);
    }

    public static TopicName getTopicName(TopicPath path) throws StatusException {
        String[] splits = path.value().split("/");
        TopicPaths.checkSplits(splits);
        return TopicName.of(splits[5]);
    }

    public static LocationPath getLocationPath(TopicPath path) throws StatusException {
        return LocationPaths.newBuilder().setProjectNumber(TopicPaths.getProjectNumber(path)).setZone(TopicPaths.getZone(path)).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setProjectNumber(ProjectNumber var1);

        public abstract Builder setZone(CloudZone var1);

        public abstract Builder setTopicName(TopicName var1);

        abstract TopicPaths autoBuild();

        public TopicPath build() {
            TopicPaths built = this.autoBuild();
            return TopicPath.of(String.format("projects/%s/locations/%s/topics/%s", built.projectNumber().value(), built.zone().toString(), built.topicName().value()));
        }
    }
}

