/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AutoValue_SubscriptionPaths;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.LocationPaths;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Preconditions;
import io.grpc.StatusException;

@AutoValue
public abstract class SubscriptionPaths {
    abstract ProjectNumber projectNumber();

    abstract CloudZone zone();

    abstract SubscriptionName subscriptionName();

    public static Builder newBuilder() {
        return new AutoValue_SubscriptionPaths.Builder();
    }

    private static void checkSplits(String[] splits) throws StatusException {
        Preconditions.checkArgument(splits.length == 6);
        Preconditions.checkArgument(splits[0].equals("projects"));
        Preconditions.checkArgument(splits[2].equals("locations"));
        Preconditions.checkArgument(splits[4].equals("subscriptions"));
    }

    public static void check(SubscriptionPath path) throws StatusException {
        ProjectNumber unusedProjectNumber = SubscriptionPaths.getProjectNumber(path);
        CloudZone unusedZone = SubscriptionPaths.getZone(path);
        SubscriptionName unusedName = SubscriptionPaths.getSubscriptionName(path);
    }

    public static ProjectNumber getProjectNumber(SubscriptionPath path) throws StatusException {
        String[] splits = path.value().split("/");
        SubscriptionPaths.checkSplits(splits);
        try {
            return ProjectNumber.of(Long.parseLong(splits[1]));
        }
        catch (NumberFormatException e) {
            throw ExtractStatus.toCanonical(e);
        }
    }

    public static CloudZone getZone(SubscriptionPath path) throws StatusException {
        String[] splits = path.value().split("/");
        SubscriptionPaths.checkSplits(splits);
        return CloudZone.parse(splits[3]);
    }

    public static SubscriptionName getSubscriptionName(SubscriptionPath path) throws StatusException {
        String[] splits = path.value().split("/");
        SubscriptionPaths.checkSplits(splits);
        return SubscriptionName.of(splits[5]);
    }

    public static LocationPath getLocationPath(SubscriptionPath path) throws StatusException {
        return LocationPaths.newBuilder().setProjectNumber(SubscriptionPaths.getProjectNumber(path)).setZone(SubscriptionPaths.getZone(path)).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setProjectNumber(ProjectNumber var1);

        public abstract Builder setZone(CloudZone var1);

        public abstract Builder setSubscriptionName(SubscriptionName var1);

        abstract SubscriptionPaths autoBuild();

        public SubscriptionPath build() {
            SubscriptionPaths built = this.autoBuild();
            return SubscriptionPath.of(String.format("projects/%s/locations/%s/subscriptions/%s", built.projectNumber().value(), built.zone().toString(), built.subscriptionName().value()));
        }
    }
}

