/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.InternalApi;

class MessageWaiter {
    private int pendingMessages = 0;

    MessageWaiter() {
    }

    public synchronized void incrementPendingMessages(int messages) {
        this.pendingMessages += messages;
        if (this.pendingMessages == 0) {
            this.notifyAll();
        }
    }

    public synchronized void waitNoMessages() {
        boolean interrupted = false;
        try {
            while (this.pendingMessages > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @InternalApi
    public int pendingMessages() {
        return this.pendingMessages;
    }
}

