/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.spi;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.grpc.ApiException;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.cloud.AuthCredentials;
import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.pubsub.PubSubException;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.spi.PubSubRpc;
import com.google.cloud.pubsub.spi.v1.PublisherApi;
import com.google.cloud.pubsub.spi.v1.PublisherSettings;
import com.google.cloud.pubsub.spi.v1.SubscriberApi;
import com.google.cloud.pubsub.spi.v1.SubscriberSettings;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

public class DefaultPubSubRpc
implements PubSubRpc {
    private final PublisherApi publisherApi;
    private final SubscriberApi subscriberApi;
    private final ScheduledExecutorService executor;
    private final GrpcServiceOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    private boolean closed;

    public DefaultPubSubRpc(PubSubOptions options) throws IOException {
        InternalPubSubOptions internalOptions = new InternalPubSubOptions(options);
        this.executorFactory = internalOptions.getExecutorFactory();
        this.executor = (ScheduledExecutorService)this.executorFactory.get();
        String libraryName = options.getLibraryName();
        String libraryVersion = (String)MoreObjects.firstNonNull((Object)options.getLibraryVersion(), (Object)"");
        try {
            PublisherSettings.Builder pubBuilder = PublisherSettings.defaultBuilder().provideExecutorWith(this.executor, false).setClientLibHeader(libraryName, libraryVersion);
            SubscriberSettings.Builder subBuilder = SubscriberSettings.defaultBuilder().provideExecutorWith(this.executor, false).setClientLibHeader(libraryName, libraryVersion);
            if (options.getHost().contains("localhost") || options.getAuthCredentials().equals(AuthCredentials.noAuth())) {
                ManagedChannelImpl channel = NettyChannelBuilder.forTarget((String)options.getHost()).negotiationType(NegotiationType.PLAINTEXT).build();
                pubBuilder.provideChannelWith((ManagedChannel)channel, true);
                subBuilder.provideChannelWith((ManagedChannel)channel, true);
            } else {
                ConnectionSettings connectionSettings = internalOptions.getConnectionSettings().build();
                pubBuilder.provideChannelWith(connectionSettings);
                subBuilder.provideChannelWith(connectionSettings);
            }
            UnaryCallSettings.Builder callSettingsBuilder = internalOptions.getApiCallSettings();
            pubBuilder.applyToAllApiMethods(callSettingsBuilder);
            subBuilder.applyToAllApiMethods(callSettingsBuilder);
            this.publisherApi = PublisherApi.create(pubBuilder.build());
            this.subscriberApi = SubscriberApi.create(subBuilder.build());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private static <V> ListenableFuture<V> translate(ListenableFuture<V> from, final boolean idempotent, int ... returnNullOn) {
        final HashSet returnNullOnSet = Sets.newHashSetWithExpectedSize((int)returnNullOn.length);
        for (int value : returnNullOn) {
            returnNullOnSet.add(value);
        }
        return Futures.catching(from, ApiException.class, (Function)new Function<ApiException, V>(){

            public V apply(ApiException exception) {
                if (returnNullOnSet.contains(exception.getStatusCode().value())) {
                    return null;
                }
                throw new PubSubException(exception, idempotent);
            }
        });
    }

    @Override
    public Future<Topic> create(Topic topic) {
        return DefaultPubSubRpc.translate(this.publisherApi.createTopicCallable().futureCall((Object)topic), true, new int[0]);
    }

    @Override
    public Future<PublishResponse> publish(PublishRequest request) {
        return DefaultPubSubRpc.translate(this.publisherApi.publishCallable().futureCall((Object)request), false, new int[0]);
    }

    @Override
    public Future<Topic> get(GetTopicRequest request) {
        return DefaultPubSubRpc.translate(this.publisherApi.getTopicCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<ListTopicsResponse> list(ListTopicsRequest request) {
        return DefaultPubSubRpc.translate(this.publisherApi.listTopicsCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<ListTopicSubscriptionsResponse> list(ListTopicSubscriptionsRequest request) {
        return DefaultPubSubRpc.translate(this.publisherApi.listTopicSubscriptionsCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<Empty> delete(DeleteTopicRequest request) {
        return DefaultPubSubRpc.translate(this.publisherApi.deleteTopicCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<Subscription> create(Subscription subscription) {
        return DefaultPubSubRpc.translate(this.subscriberApi.createSubscriptionCallable().futureCall((Object)subscription), false, new int[0]);
    }

    @Override
    public Future<Subscription> get(GetSubscriptionRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberApi.getSubscriptionCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<ListSubscriptionsResponse> list(ListSubscriptionsRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberApi.listSubscriptionsCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<Empty> delete(DeleteSubscriptionRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberApi.deleteSubscriptionCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<Empty> modify(ModifyAckDeadlineRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberApi.modifyAckDeadlineCallable().futureCall((Object)request), false, new int[0]);
    }

    @Override
    public Future<Empty> acknowledge(AcknowledgeRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberApi.acknowledgeCallable().futureCall((Object)request), false, new int[0]);
    }

    @Override
    public PubSubRpc.PullFuture pull(PullRequest request) {
        return new PullFutureImpl(DefaultPubSubRpc.translate(this.subscriberApi.pullCallable().futureCall((Object)request), false, new int[0]));
    }

    @Override
    public Future<Empty> modify(ModifyPushConfigRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberApi.modifyPushConfigCallable().futureCall((Object)request), false, new int[0]);
    }

    @Override
    public Future<Policy> getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return DefaultPubSubRpc.translate(this.subscriberApi.getIamPolicyCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<Policy> setIamPolicy(SetIamPolicyRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberApi.setIamPolicyCallable().futureCall((Object)request), false, new int[0]);
    }

    @Override
    public Future<TestIamPermissionsResponse> testIamPermissions(TestIamPermissionsRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberApi.testIamPermissionsCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.subscriberApi.close();
        this.publisherApi.close();
        this.executorFactory.release((ExecutorService)this.executor);
    }

    private static final class PullFutureImpl
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<PullResponse>
    implements PubSubRpc.PullFuture {
        PullFutureImpl(ListenableFuture<PullResponse> delegate) {
            super(delegate);
        }

        @Override
        public void addCallback(final PubSubRpc.PullCallback callback) {
            Futures.addCallback((ListenableFuture)this.delegate(), (FutureCallback)new FutureCallback<PullResponse>(){

                public void onSuccess(PullResponse result) {
                    callback.success(result);
                }

                public void onFailure(Throwable error) {
                    callback.failure(error);
                }
            });
        }
    }

    private static final class InternalPubSubOptions
    extends PubSubOptions {
        private static final long serialVersionUID = -7997372049256706185L;

        private InternalPubSubOptions(PubSubOptions options) {
            super(options.toBuilder());
        }

        @Override
        protected GrpcServiceOptions.ExecutorFactory<ScheduledExecutorService> getExecutorFactory() {
            return super.getExecutorFactory();
        }

        protected UnaryCallSettings.Builder getApiCallSettings() {
            return super.getApiCallSettings();
        }

        protected ConnectionSettings.Builder getConnectionSettings() {
            return super.getConnectionSettings();
        }
    }
}

