/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.AsyncPage;
import com.google.cloud.Page;
import com.google.cloud.Policy;
import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.SubscriptionId;
import com.google.cloud.pubsub.TopicInfo;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;

public class Topic
extends TopicInfo {
    private static final long serialVersionUID = -2686692223763315944L;
    private final PubSubOptions options;
    private transient PubSub pubsub;

    Topic(PubSub pubsub, TopicInfo.BuilderImpl builder) {
        super(builder);
        this.pubsub = (PubSub)Preconditions.checkNotNull((Object)pubsub);
        this.options = (PubSubOptions)pubsub.options();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{this.options, super.hashCode()});
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Topic.class)) {
            return false;
        }
        Topic other = (Topic)obj;
        return this.baseEquals(other) && Objects.equals((Object)this.options, (Object)other.options);
    }

    public PubSub pubSub() {
        return this.pubsub;
    }

    public boolean delete() {
        return this.pubsub.deleteTopic(this.name());
    }

    public Future<Boolean> deleteAsync() {
        return this.pubsub.deleteTopicAsync(this.name());
    }

    public Topic reload() {
        return this.pubsub.getTopic(this.name());
    }

    public Future<Topic> reloadAsync() {
        return this.pubsub.getTopicAsync(this.name());
    }

    public String publish(Message message) {
        return this.pubsub.publish(this.name(), message);
    }

    public Future<String> publishAsync(Message message) {
        return this.pubsub.publishAsync(this.name(), message);
    }

    public List<String> publish(Message message, Message ... messages) {
        return this.pubsub.publish(this.name(), message, messages);
    }

    public Future<List<String>> publishAsync(Message message, Message ... messages) {
        return this.pubsub.publishAsync(this.name(), message, messages);
    }

    public List<String> publish(Iterable<Message> messages) {
        return this.pubsub.publish(this.name(), messages);
    }

    public Future<List<String>> publishAsync(Iterable<Message> messages) {
        return this.pubsub.publishAsync(this.name(), messages);
    }

    public Page<SubscriptionId> listSubscriptions(PubSub.ListOption ... options) {
        return this.pubsub.listSubscriptions(this.name(), options);
    }

    public Future<AsyncPage<SubscriptionId>> listSubscriptionsAsync(PubSub.ListOption ... options) {
        return this.pubsub.listSubscriptionsAsync(this.name(), options);
    }

    public Policy getPolicy() {
        return this.pubsub.getTopicPolicy(this.name());
    }

    public Future<Policy> getPolicyAsync() {
        return this.pubsub.getTopicPolicyAsync(this.name());
    }

    public Policy replacePolicy(Policy newPolicy) {
        return this.pubsub.replaceTopicPolicy(this.name(), newPolicy);
    }

    public Future<Policy> replacePolicyAsync(Policy newPolicy) {
        return this.pubsub.replaceTopicPolicyAsync(this.name(), newPolicy);
    }

    public List<Boolean> testPermissions(List<String> permissions) {
        return this.pubsub.testTopicPermissions(this.name(), permissions);
    }

    public Future<List<Boolean>> testPermissionsAsync(List<String> permissions) {
        return this.pubsub.testTopicPermissionsAsync(this.name(), permissions);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.pubsub = (PubSub)this.options.service();
    }

    static Topic fromPb(PubSub pubsub, com.google.pubsub.v1.Topic topicPb) {
        TopicInfo topicInfo = TopicInfo.fromPb(topicPb);
        return new Topic(pubsub, new TopicInfo.BuilderImpl(topicInfo));
    }

    static Function<com.google.pubsub.v1.Topic, Topic> fromPbFunction(final PubSub pubsub) {
        return new Function<com.google.pubsub.v1.Topic, Topic>(){

            public Topic apply(com.google.pubsub.v1.Topic topicPb) {
                return topicPb != null ? Topic.fromPb(pubsub, topicPb) : null;
            }
        };
    }

    public static final class Builder
    extends TopicInfo.Builder {
        private final PubSub pubsub;
        private final TopicInfo.BuilderImpl delegate;

        private Builder(Topic topic) {
            this.pubsub = topic.pubsub;
            this.delegate = new TopicInfo.BuilderImpl(topic);
        }

        @Override
        public Builder name(String name) {
            this.delegate.name(name);
            return this;
        }

        @Override
        public Topic build() {
            return new Topic(this.pubsub, this.delegate);
        }
    }
}

