/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.testing;

import com.google.api.gax.testing.DownloadableEmulatorRunner;
import com.google.api.gax.testing.GCloudEmulatorRunner;
import com.google.api.gax.testing.LocalServiceHelper;
import com.google.cloud.AuthCredentials;
import com.google.cloud.RetryParams;
import com.google.cloud.pubsub.PubSubOptions;
import io.grpc.ManagedChannel;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;

public class LocalPubsubHelper {
    private final int port = LocalServiceHelper.findAvailablePort((int)8080);
    private final LocalServiceHelper serviceHelper;
    private final String projectId;
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_HOST = "localhost";
    private static final URL EMULATOR_URL;
    private static final String PROJECT_ID_PREFIX = "test-project-";
    private static final String GCLOUD_CMD_TEXT = "gcloud beta emulators pubsub start";
    private static final String GCLOUD_CMD_PORT_FLAG = "--host-port=";
    private static final String VERSION_PREFIX = "pubsub-emulator";
    private static final String MIN_VERSION = "2016.01.13";
    private static final String BIN_CMD_PORT_FLAG = "--port=";
    private static final String FILENAME = "pubsub-emulator-20160113-2.zip";
    private static final String BIN_NAME = "pubsub-emulator/bin/cloud-pubsub-fake";
    private static final String MD5_CHECKSUM = "20943e9defa300f2de101568459c133d";

    private LocalPubsubHelper() {
        ArrayList<String> gcloudCommand = new ArrayList<String>(Arrays.asList(GCLOUD_CMD_TEXT.split(" ")));
        gcloudCommand.add("--host-port=localhost:" + this.port);
        GCloudEmulatorRunner gcloudRunner = new GCloudEmulatorRunner(gcloudCommand, VERSION_PREFIX, MIN_VERSION);
        DownloadableEmulatorRunner downloadRunner = new DownloadableEmulatorRunner(Arrays.asList(BIN_NAME, BIN_CMD_PORT_FLAG + this.port), EMULATOR_URL, MD5_CHECKSUM);
        this.serviceHelper = new LocalServiceHelper(Arrays.asList(gcloudRunner, downloadRunner), this.port);
        this.projectId = PROJECT_ID_PREFIX + UUID.randomUUID().toString();
    }

    public static LocalPubsubHelper create() {
        return new LocalPubsubHelper();
    }

    public void start() throws IOException, InterruptedException {
        String blockUntilOutput = "Server started, listening on " + this.port;
        this.serviceHelper.start(blockUntilOutput);
    }

    public void reset() throws IOException {
        this.serviceHelper.sendPostRequest("/reset");
    }

    public void stop() throws IOException, InterruptedException {
        this.serviceHelper.sendPostRequest("/shutdown");
        this.serviceHelper.stop();
    }

    public ManagedChannel createChannel() {
        return NettyChannelBuilder.forAddress((String)DEFAULT_HOST, (int)this.port).negotiationType(NegotiationType.PLAINTEXT).build();
    }

    public PubSubOptions options() {
        return ((PubSubOptions.Builder)((PubSubOptions.Builder)((PubSubOptions.Builder)((PubSubOptions.Builder)PubSubOptions.builder().projectId(this.projectId)).host("localhost:" + this.port)).authCredentials(AuthCredentials.noAuth())).retryParams(RetryParams.noRetries())).build();
    }

    static {
        try {
            EMULATOR_URL = new URL("http://storage.googleapis.com/pubsub/tools/pubsub-emulator-20160113-2.zip");
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

