/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.oracledatabase.v1.AutonomousDatabase;
import com.google.cloud.oracledatabase.v1.AutonomousDatabaseBackup;
import com.google.cloud.oracledatabase.v1.AutonomousDatabaseCharacterSet;
import com.google.cloud.oracledatabase.v1.AutonomousDbVersion;
import com.google.cloud.oracledatabase.v1.CloudExadataInfrastructure;
import com.google.cloud.oracledatabase.v1.CloudVmCluster;
import com.google.cloud.oracledatabase.v1.CreateAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.CreateCloudExadataInfrastructureRequest;
import com.google.cloud.oracledatabase.v1.CreateCloudVmClusterRequest;
import com.google.cloud.oracledatabase.v1.DbNode;
import com.google.cloud.oracledatabase.v1.DbServer;
import com.google.cloud.oracledatabase.v1.DbSystemShape;
import com.google.cloud.oracledatabase.v1.DeleteAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.DeleteCloudExadataInfrastructureRequest;
import com.google.cloud.oracledatabase.v1.DeleteCloudVmClusterRequest;
import com.google.cloud.oracledatabase.v1.Entitlement;
import com.google.cloud.oracledatabase.v1.GenerateAutonomousDatabaseWalletRequest;
import com.google.cloud.oracledatabase.v1.GenerateAutonomousDatabaseWalletResponse;
import com.google.cloud.oracledatabase.v1.GetAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.GetCloudExadataInfrastructureRequest;
import com.google.cloud.oracledatabase.v1.GetCloudVmClusterRequest;
import com.google.cloud.oracledatabase.v1.GiVersion;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabaseBackupsRequest;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabaseBackupsResponse;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabaseCharacterSetsRequest;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabaseCharacterSetsResponse;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabasesRequest;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabasesResponse;
import com.google.cloud.oracledatabase.v1.ListAutonomousDbVersionsRequest;
import com.google.cloud.oracledatabase.v1.ListAutonomousDbVersionsResponse;
import com.google.cloud.oracledatabase.v1.ListCloudExadataInfrastructuresRequest;
import com.google.cloud.oracledatabase.v1.ListCloudExadataInfrastructuresResponse;
import com.google.cloud.oracledatabase.v1.ListCloudVmClustersRequest;
import com.google.cloud.oracledatabase.v1.ListCloudVmClustersResponse;
import com.google.cloud.oracledatabase.v1.ListDbNodesRequest;
import com.google.cloud.oracledatabase.v1.ListDbNodesResponse;
import com.google.cloud.oracledatabase.v1.ListDbServersRequest;
import com.google.cloud.oracledatabase.v1.ListDbServersResponse;
import com.google.cloud.oracledatabase.v1.ListDbSystemShapesRequest;
import com.google.cloud.oracledatabase.v1.ListDbSystemShapesResponse;
import com.google.cloud.oracledatabase.v1.ListEntitlementsRequest;
import com.google.cloud.oracledatabase.v1.ListEntitlementsResponse;
import com.google.cloud.oracledatabase.v1.ListGiVersionsRequest;
import com.google.cloud.oracledatabase.v1.ListGiVersionsResponse;
import com.google.cloud.oracledatabase.v1.OperationMetadata;
import com.google.cloud.oracledatabase.v1.OracleDatabaseClient;
import com.google.cloud.oracledatabase.v1.RestoreAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.stub.HttpJsonOracleDatabaseStub;
import com.google.cloud.oracledatabase.v1.stub.OracleDatabaseStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class OracleDatabaseStubSettings
extends StubSettings<OracleDatabaseStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, OracleDatabaseClient.ListCloudExadataInfrastructuresPagedResponse> listCloudExadataInfrastructuresSettings;
    private final UnaryCallSettings<GetCloudExadataInfrastructureRequest, CloudExadataInfrastructure> getCloudExadataInfrastructureSettings;
    private final UnaryCallSettings<CreateCloudExadataInfrastructureRequest, Operation> createCloudExadataInfrastructureSettings;
    private final OperationCallSettings<CreateCloudExadataInfrastructureRequest, CloudExadataInfrastructure, OperationMetadata> createCloudExadataInfrastructureOperationSettings;
    private final UnaryCallSettings<DeleteCloudExadataInfrastructureRequest, Operation> deleteCloudExadataInfrastructureSettings;
    private final OperationCallSettings<DeleteCloudExadataInfrastructureRequest, Empty, OperationMetadata> deleteCloudExadataInfrastructureOperationSettings;
    private final PagedCallSettings<ListCloudVmClustersRequest, ListCloudVmClustersResponse, OracleDatabaseClient.ListCloudVmClustersPagedResponse> listCloudVmClustersSettings;
    private final UnaryCallSettings<GetCloudVmClusterRequest, CloudVmCluster> getCloudVmClusterSettings;
    private final UnaryCallSettings<CreateCloudVmClusterRequest, Operation> createCloudVmClusterSettings;
    private final OperationCallSettings<CreateCloudVmClusterRequest, CloudVmCluster, OperationMetadata> createCloudVmClusterOperationSettings;
    private final UnaryCallSettings<DeleteCloudVmClusterRequest, Operation> deleteCloudVmClusterSettings;
    private final OperationCallSettings<DeleteCloudVmClusterRequest, Empty, OperationMetadata> deleteCloudVmClusterOperationSettings;
    private final PagedCallSettings<ListEntitlementsRequest, ListEntitlementsResponse, OracleDatabaseClient.ListEntitlementsPagedResponse> listEntitlementsSettings;
    private final PagedCallSettings<ListDbServersRequest, ListDbServersResponse, OracleDatabaseClient.ListDbServersPagedResponse> listDbServersSettings;
    private final PagedCallSettings<ListDbNodesRequest, ListDbNodesResponse, OracleDatabaseClient.ListDbNodesPagedResponse> listDbNodesSettings;
    private final PagedCallSettings<ListGiVersionsRequest, ListGiVersionsResponse, OracleDatabaseClient.ListGiVersionsPagedResponse> listGiVersionsSettings;
    private final PagedCallSettings<ListDbSystemShapesRequest, ListDbSystemShapesResponse, OracleDatabaseClient.ListDbSystemShapesPagedResponse> listDbSystemShapesSettings;
    private final PagedCallSettings<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, OracleDatabaseClient.ListAutonomousDatabasesPagedResponse> listAutonomousDatabasesSettings;
    private final UnaryCallSettings<GetAutonomousDatabaseRequest, AutonomousDatabase> getAutonomousDatabaseSettings;
    private final UnaryCallSettings<CreateAutonomousDatabaseRequest, Operation> createAutonomousDatabaseSettings;
    private final OperationCallSettings<CreateAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> createAutonomousDatabaseOperationSettings;
    private final UnaryCallSettings<DeleteAutonomousDatabaseRequest, Operation> deleteAutonomousDatabaseSettings;
    private final OperationCallSettings<DeleteAutonomousDatabaseRequest, Empty, OperationMetadata> deleteAutonomousDatabaseOperationSettings;
    private final UnaryCallSettings<RestoreAutonomousDatabaseRequest, Operation> restoreAutonomousDatabaseSettings;
    private final OperationCallSettings<RestoreAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> restoreAutonomousDatabaseOperationSettings;
    private final UnaryCallSettings<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse> generateAutonomousDatabaseWalletSettings;
    private final PagedCallSettings<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, OracleDatabaseClient.ListAutonomousDbVersionsPagedResponse> listAutonomousDbVersionsSettings;
    private final PagedCallSettings<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, OracleDatabaseClient.ListAutonomousDatabaseCharacterSetsPagedResponse> listAutonomousDatabaseCharacterSetsSettings;
    private final PagedCallSettings<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, OracleDatabaseClient.ListAutonomousDatabaseBackupsPagedResponse> listAutonomousDatabaseBackupsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, OracleDatabaseClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure> LIST_CLOUD_EXADATA_INFRASTRUCTURES_PAGE_STR_DESC = new PagedListDescriptor<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure>(){

        public String emptyToken() {
            return "";
        }

        public ListCloudExadataInfrastructuresRequest injectToken(ListCloudExadataInfrastructuresRequest payload, String token) {
            return ListCloudExadataInfrastructuresRequest.newBuilder((ListCloudExadataInfrastructuresRequest)payload).setPageToken(token).build();
        }

        public ListCloudExadataInfrastructuresRequest injectPageSize(ListCloudExadataInfrastructuresRequest payload, int pageSize) {
            return ListCloudExadataInfrastructuresRequest.newBuilder((ListCloudExadataInfrastructuresRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCloudExadataInfrastructuresRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCloudExadataInfrastructuresResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CloudExadataInfrastructure> extractResources(ListCloudExadataInfrastructuresResponse payload) {
            return payload.getCloudExadataInfrastructuresList();
        }
    };
    private static final PagedListDescriptor<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster> LIST_CLOUD_VM_CLUSTERS_PAGE_STR_DESC = new PagedListDescriptor<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster>(){

        public String emptyToken() {
            return "";
        }

        public ListCloudVmClustersRequest injectToken(ListCloudVmClustersRequest payload, String token) {
            return ListCloudVmClustersRequest.newBuilder((ListCloudVmClustersRequest)payload).setPageToken(token).build();
        }

        public ListCloudVmClustersRequest injectPageSize(ListCloudVmClustersRequest payload, int pageSize) {
            return ListCloudVmClustersRequest.newBuilder((ListCloudVmClustersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCloudVmClustersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCloudVmClustersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CloudVmCluster> extractResources(ListCloudVmClustersResponse payload) {
            return payload.getCloudVmClustersList();
        }
    };
    private static final PagedListDescriptor<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> LIST_ENTITLEMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement>(){

        public String emptyToken() {
            return "";
        }

        public ListEntitlementsRequest injectToken(ListEntitlementsRequest payload, String token) {
            return ListEntitlementsRequest.newBuilder((ListEntitlementsRequest)payload).setPageToken(token).build();
        }

        public ListEntitlementsRequest injectPageSize(ListEntitlementsRequest payload, int pageSize) {
            return ListEntitlementsRequest.newBuilder((ListEntitlementsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntitlementsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntitlementsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Entitlement> extractResources(ListEntitlementsResponse payload) {
            return payload.getEntitlementsList();
        }
    };
    private static final PagedListDescriptor<ListDbServersRequest, ListDbServersResponse, DbServer> LIST_DB_SERVERS_PAGE_STR_DESC = new PagedListDescriptor<ListDbServersRequest, ListDbServersResponse, DbServer>(){

        public String emptyToken() {
            return "";
        }

        public ListDbServersRequest injectToken(ListDbServersRequest payload, String token) {
            return ListDbServersRequest.newBuilder((ListDbServersRequest)payload).setPageToken(token).build();
        }

        public ListDbServersRequest injectPageSize(ListDbServersRequest payload, int pageSize) {
            return ListDbServersRequest.newBuilder((ListDbServersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDbServersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDbServersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DbServer> extractResources(ListDbServersResponse payload) {
            return payload.getDbServersList();
        }
    };
    private static final PagedListDescriptor<ListDbNodesRequest, ListDbNodesResponse, DbNode> LIST_DB_NODES_PAGE_STR_DESC = new PagedListDescriptor<ListDbNodesRequest, ListDbNodesResponse, DbNode>(){

        public String emptyToken() {
            return "";
        }

        public ListDbNodesRequest injectToken(ListDbNodesRequest payload, String token) {
            return ListDbNodesRequest.newBuilder((ListDbNodesRequest)payload).setPageToken(token).build();
        }

        public ListDbNodesRequest injectPageSize(ListDbNodesRequest payload, int pageSize) {
            return ListDbNodesRequest.newBuilder((ListDbNodesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDbNodesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDbNodesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DbNode> extractResources(ListDbNodesResponse payload) {
            return payload.getDbNodesList();
        }
    };
    private static final PagedListDescriptor<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion> LIST_GI_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListGiVersionsRequest injectToken(ListGiVersionsRequest payload, String token) {
            return ListGiVersionsRequest.newBuilder((ListGiVersionsRequest)payload).setPageToken(token).build();
        }

        public ListGiVersionsRequest injectPageSize(ListGiVersionsRequest payload, int pageSize) {
            return ListGiVersionsRequest.newBuilder((ListGiVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGiVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGiVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GiVersion> extractResources(ListGiVersionsResponse payload) {
            return payload.getGiVersionsList();
        }
    };
    private static final PagedListDescriptor<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape> LIST_DB_SYSTEM_SHAPES_PAGE_STR_DESC = new PagedListDescriptor<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape>(){

        public String emptyToken() {
            return "";
        }

        public ListDbSystemShapesRequest injectToken(ListDbSystemShapesRequest payload, String token) {
            return ListDbSystemShapesRequest.newBuilder((ListDbSystemShapesRequest)payload).setPageToken(token).build();
        }

        public ListDbSystemShapesRequest injectPageSize(ListDbSystemShapesRequest payload, int pageSize) {
            return ListDbSystemShapesRequest.newBuilder((ListDbSystemShapesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDbSystemShapesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDbSystemShapesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DbSystemShape> extractResources(ListDbSystemShapesResponse payload) {
            return payload.getDbSystemShapesList();
        }
    };
    private static final PagedListDescriptor<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase> LIST_AUTONOMOUS_DATABASES_PAGE_STR_DESC = new PagedListDescriptor<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase>(){

        public String emptyToken() {
            return "";
        }

        public ListAutonomousDatabasesRequest injectToken(ListAutonomousDatabasesRequest payload, String token) {
            return ListAutonomousDatabasesRequest.newBuilder((ListAutonomousDatabasesRequest)payload).setPageToken(token).build();
        }

        public ListAutonomousDatabasesRequest injectPageSize(ListAutonomousDatabasesRequest payload, int pageSize) {
            return ListAutonomousDatabasesRequest.newBuilder((ListAutonomousDatabasesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAutonomousDatabasesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAutonomousDatabasesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AutonomousDatabase> extractResources(ListAutonomousDatabasesResponse payload) {
            return payload.getAutonomousDatabasesList();
        }
    };
    private static final PagedListDescriptor<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion> LIST_AUTONOMOUS_DB_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListAutonomousDbVersionsRequest injectToken(ListAutonomousDbVersionsRequest payload, String token) {
            return ListAutonomousDbVersionsRequest.newBuilder((ListAutonomousDbVersionsRequest)payload).setPageToken(token).build();
        }

        public ListAutonomousDbVersionsRequest injectPageSize(ListAutonomousDbVersionsRequest payload, int pageSize) {
            return ListAutonomousDbVersionsRequest.newBuilder((ListAutonomousDbVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAutonomousDbVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAutonomousDbVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AutonomousDbVersion> extractResources(ListAutonomousDbVersionsResponse payload) {
            return payload.getAutonomousDbVersionsList();
        }
    };
    private static final PagedListDescriptor<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet> LIST_AUTONOMOUS_DATABASE_CHARACTER_SETS_PAGE_STR_DESC = new PagedListDescriptor<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet>(){

        public String emptyToken() {
            return "";
        }

        public ListAutonomousDatabaseCharacterSetsRequest injectToken(ListAutonomousDatabaseCharacterSetsRequest payload, String token) {
            return ListAutonomousDatabaseCharacterSetsRequest.newBuilder((ListAutonomousDatabaseCharacterSetsRequest)payload).setPageToken(token).build();
        }

        public ListAutonomousDatabaseCharacterSetsRequest injectPageSize(ListAutonomousDatabaseCharacterSetsRequest payload, int pageSize) {
            return ListAutonomousDatabaseCharacterSetsRequest.newBuilder((ListAutonomousDatabaseCharacterSetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAutonomousDatabaseCharacterSetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAutonomousDatabaseCharacterSetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AutonomousDatabaseCharacterSet> extractResources(ListAutonomousDatabaseCharacterSetsResponse payload) {
            return payload.getAutonomousDatabaseCharacterSetsList();
        }
    };
    private static final PagedListDescriptor<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup> LIST_AUTONOMOUS_DATABASE_BACKUPS_PAGE_STR_DESC = new PagedListDescriptor<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup>(){

        public String emptyToken() {
            return "";
        }

        public ListAutonomousDatabaseBackupsRequest injectToken(ListAutonomousDatabaseBackupsRequest payload, String token) {
            return ListAutonomousDatabaseBackupsRequest.newBuilder((ListAutonomousDatabaseBackupsRequest)payload).setPageToken(token).build();
        }

        public ListAutonomousDatabaseBackupsRequest injectPageSize(ListAutonomousDatabaseBackupsRequest payload, int pageSize) {
            return ListAutonomousDatabaseBackupsRequest.newBuilder((ListAutonomousDatabaseBackupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAutonomousDatabaseBackupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAutonomousDatabaseBackupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AutonomousDatabaseBackup> extractResources(ListAutonomousDatabaseBackupsResponse payload) {
            return payload.getAutonomousDatabaseBackupsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, OracleDatabaseClient.ListCloudExadataInfrastructuresPagedResponse> LIST_CLOUD_EXADATA_INFRASTRUCTURES_PAGE_STR_FACT = new PagedListResponseFactory<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, OracleDatabaseClient.ListCloudExadataInfrastructuresPagedResponse>(){

        public ApiFuture<OracleDatabaseClient.ListCloudExadataInfrastructuresPagedResponse> getFuturePagedResponse(UnaryCallable<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse> callable, ListCloudExadataInfrastructuresRequest request, ApiCallContext context, ApiFuture<ListCloudExadataInfrastructuresResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CLOUD_EXADATA_INFRASTRUCTURES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OracleDatabaseClient.ListCloudExadataInfrastructuresPagedResponse.createAsync((PageContext<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCloudVmClustersRequest, ListCloudVmClustersResponse, OracleDatabaseClient.ListCloudVmClustersPagedResponse> LIST_CLOUD_VM_CLUSTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListCloudVmClustersRequest, ListCloudVmClustersResponse, OracleDatabaseClient.ListCloudVmClustersPagedResponse>(){

        public ApiFuture<OracleDatabaseClient.ListCloudVmClustersPagedResponse> getFuturePagedResponse(UnaryCallable<ListCloudVmClustersRequest, ListCloudVmClustersResponse> callable, ListCloudVmClustersRequest request, ApiCallContext context, ApiFuture<ListCloudVmClustersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CLOUD_VM_CLUSTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OracleDatabaseClient.ListCloudVmClustersPagedResponse.createAsync((PageContext<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEntitlementsRequest, ListEntitlementsResponse, OracleDatabaseClient.ListEntitlementsPagedResponse> LIST_ENTITLEMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEntitlementsRequest, ListEntitlementsResponse, OracleDatabaseClient.ListEntitlementsPagedResponse>(){

        public ApiFuture<OracleDatabaseClient.ListEntitlementsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntitlementsRequest, ListEntitlementsResponse> callable, ListEntitlementsRequest request, ApiCallContext context, ApiFuture<ListEntitlementsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTITLEMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OracleDatabaseClient.ListEntitlementsPagedResponse.createAsync((PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDbServersRequest, ListDbServersResponse, OracleDatabaseClient.ListDbServersPagedResponse> LIST_DB_SERVERS_PAGE_STR_FACT = new PagedListResponseFactory<ListDbServersRequest, ListDbServersResponse, OracleDatabaseClient.ListDbServersPagedResponse>(){

        public ApiFuture<OracleDatabaseClient.ListDbServersPagedResponse> getFuturePagedResponse(UnaryCallable<ListDbServersRequest, ListDbServersResponse> callable, ListDbServersRequest request, ApiCallContext context, ApiFuture<ListDbServersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DB_SERVERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OracleDatabaseClient.ListDbServersPagedResponse.createAsync((PageContext<ListDbServersRequest, ListDbServersResponse, DbServer>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDbNodesRequest, ListDbNodesResponse, OracleDatabaseClient.ListDbNodesPagedResponse> LIST_DB_NODES_PAGE_STR_FACT = new PagedListResponseFactory<ListDbNodesRequest, ListDbNodesResponse, OracleDatabaseClient.ListDbNodesPagedResponse>(){

        public ApiFuture<OracleDatabaseClient.ListDbNodesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDbNodesRequest, ListDbNodesResponse> callable, ListDbNodesRequest request, ApiCallContext context, ApiFuture<ListDbNodesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DB_NODES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OracleDatabaseClient.ListDbNodesPagedResponse.createAsync((PageContext<ListDbNodesRequest, ListDbNodesResponse, DbNode>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGiVersionsRequest, ListGiVersionsResponse, OracleDatabaseClient.ListGiVersionsPagedResponse> LIST_GI_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListGiVersionsRequest, ListGiVersionsResponse, OracleDatabaseClient.ListGiVersionsPagedResponse>(){

        public ApiFuture<OracleDatabaseClient.ListGiVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGiVersionsRequest, ListGiVersionsResponse> callable, ListGiVersionsRequest request, ApiCallContext context, ApiFuture<ListGiVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GI_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OracleDatabaseClient.ListGiVersionsPagedResponse.createAsync((PageContext<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDbSystemShapesRequest, ListDbSystemShapesResponse, OracleDatabaseClient.ListDbSystemShapesPagedResponse> LIST_DB_SYSTEM_SHAPES_PAGE_STR_FACT = new PagedListResponseFactory<ListDbSystemShapesRequest, ListDbSystemShapesResponse, OracleDatabaseClient.ListDbSystemShapesPagedResponse>(){

        public ApiFuture<OracleDatabaseClient.ListDbSystemShapesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDbSystemShapesRequest, ListDbSystemShapesResponse> callable, ListDbSystemShapesRequest request, ApiCallContext context, ApiFuture<ListDbSystemShapesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DB_SYSTEM_SHAPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OracleDatabaseClient.ListDbSystemShapesPagedResponse.createAsync((PageContext<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, OracleDatabaseClient.ListAutonomousDatabasesPagedResponse> LIST_AUTONOMOUS_DATABASES_PAGE_STR_FACT = new PagedListResponseFactory<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, OracleDatabaseClient.ListAutonomousDatabasesPagedResponse>(){

        public ApiFuture<OracleDatabaseClient.ListAutonomousDatabasesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse> callable, ListAutonomousDatabasesRequest request, ApiCallContext context, ApiFuture<ListAutonomousDatabasesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AUTONOMOUS_DATABASES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OracleDatabaseClient.ListAutonomousDatabasesPagedResponse.createAsync((PageContext<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, OracleDatabaseClient.ListAutonomousDbVersionsPagedResponse> LIST_AUTONOMOUS_DB_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, OracleDatabaseClient.ListAutonomousDbVersionsPagedResponse>(){

        public ApiFuture<OracleDatabaseClient.ListAutonomousDbVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse> callable, ListAutonomousDbVersionsRequest request, ApiCallContext context, ApiFuture<ListAutonomousDbVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AUTONOMOUS_DB_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OracleDatabaseClient.ListAutonomousDbVersionsPagedResponse.createAsync((PageContext<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, OracleDatabaseClient.ListAutonomousDatabaseCharacterSetsPagedResponse> LIST_AUTONOMOUS_DATABASE_CHARACTER_SETS_PAGE_STR_FACT = new PagedListResponseFactory<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, OracleDatabaseClient.ListAutonomousDatabaseCharacterSetsPagedResponse>(){

        public ApiFuture<OracleDatabaseClient.ListAutonomousDatabaseCharacterSetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse> callable, ListAutonomousDatabaseCharacterSetsRequest request, ApiCallContext context, ApiFuture<ListAutonomousDatabaseCharacterSetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AUTONOMOUS_DATABASE_CHARACTER_SETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OracleDatabaseClient.ListAutonomousDatabaseCharacterSetsPagedResponse.createAsync((PageContext<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, OracleDatabaseClient.ListAutonomousDatabaseBackupsPagedResponse> LIST_AUTONOMOUS_DATABASE_BACKUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, OracleDatabaseClient.ListAutonomousDatabaseBackupsPagedResponse>(){

        public ApiFuture<OracleDatabaseClient.ListAutonomousDatabaseBackupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse> callable, ListAutonomousDatabaseBackupsRequest request, ApiCallContext context, ApiFuture<ListAutonomousDatabaseBackupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AUTONOMOUS_DATABASE_BACKUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OracleDatabaseClient.ListAutonomousDatabaseBackupsPagedResponse.createAsync((PageContext<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, OracleDatabaseClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, OracleDatabaseClient.ListLocationsPagedResponse>(){

        public ApiFuture<OracleDatabaseClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OracleDatabaseClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, OracleDatabaseClient.ListCloudExadataInfrastructuresPagedResponse> listCloudExadataInfrastructuresSettings() {
        return this.listCloudExadataInfrastructuresSettings;
    }

    public UnaryCallSettings<GetCloudExadataInfrastructureRequest, CloudExadataInfrastructure> getCloudExadataInfrastructureSettings() {
        return this.getCloudExadataInfrastructureSettings;
    }

    public UnaryCallSettings<CreateCloudExadataInfrastructureRequest, Operation> createCloudExadataInfrastructureSettings() {
        return this.createCloudExadataInfrastructureSettings;
    }

    public OperationCallSettings<CreateCloudExadataInfrastructureRequest, CloudExadataInfrastructure, OperationMetadata> createCloudExadataInfrastructureOperationSettings() {
        return this.createCloudExadataInfrastructureOperationSettings;
    }

    public UnaryCallSettings<DeleteCloudExadataInfrastructureRequest, Operation> deleteCloudExadataInfrastructureSettings() {
        return this.deleteCloudExadataInfrastructureSettings;
    }

    public OperationCallSettings<DeleteCloudExadataInfrastructureRequest, Empty, OperationMetadata> deleteCloudExadataInfrastructureOperationSettings() {
        return this.deleteCloudExadataInfrastructureOperationSettings;
    }

    public PagedCallSettings<ListCloudVmClustersRequest, ListCloudVmClustersResponse, OracleDatabaseClient.ListCloudVmClustersPagedResponse> listCloudVmClustersSettings() {
        return this.listCloudVmClustersSettings;
    }

    public UnaryCallSettings<GetCloudVmClusterRequest, CloudVmCluster> getCloudVmClusterSettings() {
        return this.getCloudVmClusterSettings;
    }

    public UnaryCallSettings<CreateCloudVmClusterRequest, Operation> createCloudVmClusterSettings() {
        return this.createCloudVmClusterSettings;
    }

    public OperationCallSettings<CreateCloudVmClusterRequest, CloudVmCluster, OperationMetadata> createCloudVmClusterOperationSettings() {
        return this.createCloudVmClusterOperationSettings;
    }

    public UnaryCallSettings<DeleteCloudVmClusterRequest, Operation> deleteCloudVmClusterSettings() {
        return this.deleteCloudVmClusterSettings;
    }

    public OperationCallSettings<DeleteCloudVmClusterRequest, Empty, OperationMetadata> deleteCloudVmClusterOperationSettings() {
        return this.deleteCloudVmClusterOperationSettings;
    }

    public PagedCallSettings<ListEntitlementsRequest, ListEntitlementsResponse, OracleDatabaseClient.ListEntitlementsPagedResponse> listEntitlementsSettings() {
        return this.listEntitlementsSettings;
    }

    public PagedCallSettings<ListDbServersRequest, ListDbServersResponse, OracleDatabaseClient.ListDbServersPagedResponse> listDbServersSettings() {
        return this.listDbServersSettings;
    }

    public PagedCallSettings<ListDbNodesRequest, ListDbNodesResponse, OracleDatabaseClient.ListDbNodesPagedResponse> listDbNodesSettings() {
        return this.listDbNodesSettings;
    }

    public PagedCallSettings<ListGiVersionsRequest, ListGiVersionsResponse, OracleDatabaseClient.ListGiVersionsPagedResponse> listGiVersionsSettings() {
        return this.listGiVersionsSettings;
    }

    public PagedCallSettings<ListDbSystemShapesRequest, ListDbSystemShapesResponse, OracleDatabaseClient.ListDbSystemShapesPagedResponse> listDbSystemShapesSettings() {
        return this.listDbSystemShapesSettings;
    }

    public PagedCallSettings<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, OracleDatabaseClient.ListAutonomousDatabasesPagedResponse> listAutonomousDatabasesSettings() {
        return this.listAutonomousDatabasesSettings;
    }

    public UnaryCallSettings<GetAutonomousDatabaseRequest, AutonomousDatabase> getAutonomousDatabaseSettings() {
        return this.getAutonomousDatabaseSettings;
    }

    public UnaryCallSettings<CreateAutonomousDatabaseRequest, Operation> createAutonomousDatabaseSettings() {
        return this.createAutonomousDatabaseSettings;
    }

    public OperationCallSettings<CreateAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> createAutonomousDatabaseOperationSettings() {
        return this.createAutonomousDatabaseOperationSettings;
    }

    public UnaryCallSettings<DeleteAutonomousDatabaseRequest, Operation> deleteAutonomousDatabaseSettings() {
        return this.deleteAutonomousDatabaseSettings;
    }

    public OperationCallSettings<DeleteAutonomousDatabaseRequest, Empty, OperationMetadata> deleteAutonomousDatabaseOperationSettings() {
        return this.deleteAutonomousDatabaseOperationSettings;
    }

    public UnaryCallSettings<RestoreAutonomousDatabaseRequest, Operation> restoreAutonomousDatabaseSettings() {
        return this.restoreAutonomousDatabaseSettings;
    }

    public OperationCallSettings<RestoreAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> restoreAutonomousDatabaseOperationSettings() {
        return this.restoreAutonomousDatabaseOperationSettings;
    }

    public UnaryCallSettings<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse> generateAutonomousDatabaseWalletSettings() {
        return this.generateAutonomousDatabaseWalletSettings;
    }

    public PagedCallSettings<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, OracleDatabaseClient.ListAutonomousDbVersionsPagedResponse> listAutonomousDbVersionsSettings() {
        return this.listAutonomousDbVersionsSettings;
    }

    public PagedCallSettings<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, OracleDatabaseClient.ListAutonomousDatabaseCharacterSetsPagedResponse> listAutonomousDatabaseCharacterSetsSettings() {
        return this.listAutonomousDatabaseCharacterSetsSettings;
    }

    public PagedCallSettings<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, OracleDatabaseClient.ListAutonomousDatabaseBackupsPagedResponse> listAutonomousDatabaseBackupsSettings() {
        return this.listAutonomousDatabaseBackupsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, OracleDatabaseClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public OracleDatabaseStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonOracleDatabaseStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "oracledatabase";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "oracledatabase.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "oracledatabase.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OracleDatabaseStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OracleDatabaseStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OracleDatabaseStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listCloudExadataInfrastructuresSettings = settingsBuilder.listCloudExadataInfrastructuresSettings().build();
        this.getCloudExadataInfrastructureSettings = settingsBuilder.getCloudExadataInfrastructureSettings().build();
        this.createCloudExadataInfrastructureSettings = settingsBuilder.createCloudExadataInfrastructureSettings().build();
        this.createCloudExadataInfrastructureOperationSettings = settingsBuilder.createCloudExadataInfrastructureOperationSettings().build();
        this.deleteCloudExadataInfrastructureSettings = settingsBuilder.deleteCloudExadataInfrastructureSettings().build();
        this.deleteCloudExadataInfrastructureOperationSettings = settingsBuilder.deleteCloudExadataInfrastructureOperationSettings().build();
        this.listCloudVmClustersSettings = settingsBuilder.listCloudVmClustersSettings().build();
        this.getCloudVmClusterSettings = settingsBuilder.getCloudVmClusterSettings().build();
        this.createCloudVmClusterSettings = settingsBuilder.createCloudVmClusterSettings().build();
        this.createCloudVmClusterOperationSettings = settingsBuilder.createCloudVmClusterOperationSettings().build();
        this.deleteCloudVmClusterSettings = settingsBuilder.deleteCloudVmClusterSettings().build();
        this.deleteCloudVmClusterOperationSettings = settingsBuilder.deleteCloudVmClusterOperationSettings().build();
        this.listEntitlementsSettings = settingsBuilder.listEntitlementsSettings().build();
        this.listDbServersSettings = settingsBuilder.listDbServersSettings().build();
        this.listDbNodesSettings = settingsBuilder.listDbNodesSettings().build();
        this.listGiVersionsSettings = settingsBuilder.listGiVersionsSettings().build();
        this.listDbSystemShapesSettings = settingsBuilder.listDbSystemShapesSettings().build();
        this.listAutonomousDatabasesSettings = settingsBuilder.listAutonomousDatabasesSettings().build();
        this.getAutonomousDatabaseSettings = settingsBuilder.getAutonomousDatabaseSettings().build();
        this.createAutonomousDatabaseSettings = settingsBuilder.createAutonomousDatabaseSettings().build();
        this.createAutonomousDatabaseOperationSettings = settingsBuilder.createAutonomousDatabaseOperationSettings().build();
        this.deleteAutonomousDatabaseSettings = settingsBuilder.deleteAutonomousDatabaseSettings().build();
        this.deleteAutonomousDatabaseOperationSettings = settingsBuilder.deleteAutonomousDatabaseOperationSettings().build();
        this.restoreAutonomousDatabaseSettings = settingsBuilder.restoreAutonomousDatabaseSettings().build();
        this.restoreAutonomousDatabaseOperationSettings = settingsBuilder.restoreAutonomousDatabaseOperationSettings().build();
        this.generateAutonomousDatabaseWalletSettings = settingsBuilder.generateAutonomousDatabaseWalletSettings().build();
        this.listAutonomousDbVersionsSettings = settingsBuilder.listAutonomousDbVersionsSettings().build();
        this.listAutonomousDatabaseCharacterSetsSettings = settingsBuilder.listAutonomousDatabaseCharacterSetsSettings().build();
        this.listAutonomousDatabaseBackupsSettings = settingsBuilder.listAutonomousDatabaseBackupsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OracleDatabaseStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, OracleDatabaseClient.ListCloudExadataInfrastructuresPagedResponse> listCloudExadataInfrastructuresSettings;
        private final UnaryCallSettings.Builder<GetCloudExadataInfrastructureRequest, CloudExadataInfrastructure> getCloudExadataInfrastructureSettings;
        private final UnaryCallSettings.Builder<CreateCloudExadataInfrastructureRequest, Operation> createCloudExadataInfrastructureSettings;
        private final OperationCallSettings.Builder<CreateCloudExadataInfrastructureRequest, CloudExadataInfrastructure, OperationMetadata> createCloudExadataInfrastructureOperationSettings;
        private final UnaryCallSettings.Builder<DeleteCloudExadataInfrastructureRequest, Operation> deleteCloudExadataInfrastructureSettings;
        private final OperationCallSettings.Builder<DeleteCloudExadataInfrastructureRequest, Empty, OperationMetadata> deleteCloudExadataInfrastructureOperationSettings;
        private final PagedCallSettings.Builder<ListCloudVmClustersRequest, ListCloudVmClustersResponse, OracleDatabaseClient.ListCloudVmClustersPagedResponse> listCloudVmClustersSettings;
        private final UnaryCallSettings.Builder<GetCloudVmClusterRequest, CloudVmCluster> getCloudVmClusterSettings;
        private final UnaryCallSettings.Builder<CreateCloudVmClusterRequest, Operation> createCloudVmClusterSettings;
        private final OperationCallSettings.Builder<CreateCloudVmClusterRequest, CloudVmCluster, OperationMetadata> createCloudVmClusterOperationSettings;
        private final UnaryCallSettings.Builder<DeleteCloudVmClusterRequest, Operation> deleteCloudVmClusterSettings;
        private final OperationCallSettings.Builder<DeleteCloudVmClusterRequest, Empty, OperationMetadata> deleteCloudVmClusterOperationSettings;
        private final PagedCallSettings.Builder<ListEntitlementsRequest, ListEntitlementsResponse, OracleDatabaseClient.ListEntitlementsPagedResponse> listEntitlementsSettings;
        private final PagedCallSettings.Builder<ListDbServersRequest, ListDbServersResponse, OracleDatabaseClient.ListDbServersPagedResponse> listDbServersSettings;
        private final PagedCallSettings.Builder<ListDbNodesRequest, ListDbNodesResponse, OracleDatabaseClient.ListDbNodesPagedResponse> listDbNodesSettings;
        private final PagedCallSettings.Builder<ListGiVersionsRequest, ListGiVersionsResponse, OracleDatabaseClient.ListGiVersionsPagedResponse> listGiVersionsSettings;
        private final PagedCallSettings.Builder<ListDbSystemShapesRequest, ListDbSystemShapesResponse, OracleDatabaseClient.ListDbSystemShapesPagedResponse> listDbSystemShapesSettings;
        private final PagedCallSettings.Builder<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, OracleDatabaseClient.ListAutonomousDatabasesPagedResponse> listAutonomousDatabasesSettings;
        private final UnaryCallSettings.Builder<GetAutonomousDatabaseRequest, AutonomousDatabase> getAutonomousDatabaseSettings;
        private final UnaryCallSettings.Builder<CreateAutonomousDatabaseRequest, Operation> createAutonomousDatabaseSettings;
        private final OperationCallSettings.Builder<CreateAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> createAutonomousDatabaseOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAutonomousDatabaseRequest, Operation> deleteAutonomousDatabaseSettings;
        private final OperationCallSettings.Builder<DeleteAutonomousDatabaseRequest, Empty, OperationMetadata> deleteAutonomousDatabaseOperationSettings;
        private final UnaryCallSettings.Builder<RestoreAutonomousDatabaseRequest, Operation> restoreAutonomousDatabaseSettings;
        private final OperationCallSettings.Builder<RestoreAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> restoreAutonomousDatabaseOperationSettings;
        private final UnaryCallSettings.Builder<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse> generateAutonomousDatabaseWalletSettings;
        private final PagedCallSettings.Builder<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, OracleDatabaseClient.ListAutonomousDbVersionsPagedResponse> listAutonomousDbVersionsSettings;
        private final PagedCallSettings.Builder<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, OracleDatabaseClient.ListAutonomousDatabaseCharacterSetsPagedResponse> listAutonomousDatabaseCharacterSetsSettings;
        private final PagedCallSettings.Builder<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, OracleDatabaseClient.ListAutonomousDatabaseBackupsPagedResponse> listAutonomousDatabaseBackupsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, OracleDatabaseClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listCloudExadataInfrastructuresSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CLOUD_EXADATA_INFRASTRUCTURES_PAGE_STR_FACT);
            this.getCloudExadataInfrastructureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCloudExadataInfrastructureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCloudExadataInfrastructureOperationSettings = OperationCallSettings.newBuilder();
            this.deleteCloudExadataInfrastructureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCloudExadataInfrastructureOperationSettings = OperationCallSettings.newBuilder();
            this.listCloudVmClustersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CLOUD_VM_CLUSTERS_PAGE_STR_FACT);
            this.getCloudVmClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCloudVmClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCloudVmClusterOperationSettings = OperationCallSettings.newBuilder();
            this.deleteCloudVmClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCloudVmClusterOperationSettings = OperationCallSettings.newBuilder();
            this.listEntitlementsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTITLEMENTS_PAGE_STR_FACT);
            this.listDbServersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DB_SERVERS_PAGE_STR_FACT);
            this.listDbNodesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DB_NODES_PAGE_STR_FACT);
            this.listGiVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GI_VERSIONS_PAGE_STR_FACT);
            this.listDbSystemShapesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DB_SYSTEM_SHAPES_PAGE_STR_FACT);
            this.listAutonomousDatabasesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AUTONOMOUS_DATABASES_PAGE_STR_FACT);
            this.getAutonomousDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAutonomousDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAutonomousDatabaseOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAutonomousDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAutonomousDatabaseOperationSettings = OperationCallSettings.newBuilder();
            this.restoreAutonomousDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreAutonomousDatabaseOperationSettings = OperationCallSettings.newBuilder();
            this.generateAutonomousDatabaseWalletSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAutonomousDbVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AUTONOMOUS_DB_VERSIONS_PAGE_STR_FACT);
            this.listAutonomousDatabaseCharacterSetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AUTONOMOUS_DATABASE_CHARACTER_SETS_PAGE_STR_FACT);
            this.listAutonomousDatabaseBackupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AUTONOMOUS_DATABASE_BACKUPS_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCloudExadataInfrastructuresSettings, this.getCloudExadataInfrastructureSettings, this.createCloudExadataInfrastructureSettings, this.deleteCloudExadataInfrastructureSettings, this.listCloudVmClustersSettings, this.getCloudVmClusterSettings, this.createCloudVmClusterSettings, this.deleteCloudVmClusterSettings, this.listEntitlementsSettings, this.listDbServersSettings, this.listDbNodesSettings, this.listGiVersionsSettings, (Object[])new UnaryCallSettings.Builder[]{this.listDbSystemShapesSettings, this.listAutonomousDatabasesSettings, this.getAutonomousDatabaseSettings, this.createAutonomousDatabaseSettings, this.deleteAutonomousDatabaseSettings, this.restoreAutonomousDatabaseSettings, this.generateAutonomousDatabaseWalletSettings, this.listAutonomousDbVersionsSettings, this.listAutonomousDatabaseCharacterSetsSettings, this.listAutonomousDatabaseBackupsSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(OracleDatabaseStubSettings settings) {
            super((StubSettings)settings);
            this.listCloudExadataInfrastructuresSettings = settings.listCloudExadataInfrastructuresSettings.toBuilder();
            this.getCloudExadataInfrastructureSettings = settings.getCloudExadataInfrastructureSettings.toBuilder();
            this.createCloudExadataInfrastructureSettings = settings.createCloudExadataInfrastructureSettings.toBuilder();
            this.createCloudExadataInfrastructureOperationSettings = settings.createCloudExadataInfrastructureOperationSettings.toBuilder();
            this.deleteCloudExadataInfrastructureSettings = settings.deleteCloudExadataInfrastructureSettings.toBuilder();
            this.deleteCloudExadataInfrastructureOperationSettings = settings.deleteCloudExadataInfrastructureOperationSettings.toBuilder();
            this.listCloudVmClustersSettings = settings.listCloudVmClustersSettings.toBuilder();
            this.getCloudVmClusterSettings = settings.getCloudVmClusterSettings.toBuilder();
            this.createCloudVmClusterSettings = settings.createCloudVmClusterSettings.toBuilder();
            this.createCloudVmClusterOperationSettings = settings.createCloudVmClusterOperationSettings.toBuilder();
            this.deleteCloudVmClusterSettings = settings.deleteCloudVmClusterSettings.toBuilder();
            this.deleteCloudVmClusterOperationSettings = settings.deleteCloudVmClusterOperationSettings.toBuilder();
            this.listEntitlementsSettings = settings.listEntitlementsSettings.toBuilder();
            this.listDbServersSettings = settings.listDbServersSettings.toBuilder();
            this.listDbNodesSettings = settings.listDbNodesSettings.toBuilder();
            this.listGiVersionsSettings = settings.listGiVersionsSettings.toBuilder();
            this.listDbSystemShapesSettings = settings.listDbSystemShapesSettings.toBuilder();
            this.listAutonomousDatabasesSettings = settings.listAutonomousDatabasesSettings.toBuilder();
            this.getAutonomousDatabaseSettings = settings.getAutonomousDatabaseSettings.toBuilder();
            this.createAutonomousDatabaseSettings = settings.createAutonomousDatabaseSettings.toBuilder();
            this.createAutonomousDatabaseOperationSettings = settings.createAutonomousDatabaseOperationSettings.toBuilder();
            this.deleteAutonomousDatabaseSettings = settings.deleteAutonomousDatabaseSettings.toBuilder();
            this.deleteAutonomousDatabaseOperationSettings = settings.deleteAutonomousDatabaseOperationSettings.toBuilder();
            this.restoreAutonomousDatabaseSettings = settings.restoreAutonomousDatabaseSettings.toBuilder();
            this.restoreAutonomousDatabaseOperationSettings = settings.restoreAutonomousDatabaseOperationSettings.toBuilder();
            this.generateAutonomousDatabaseWalletSettings = settings.generateAutonomousDatabaseWalletSettings.toBuilder();
            this.listAutonomousDbVersionsSettings = settings.listAutonomousDbVersionsSettings.toBuilder();
            this.listAutonomousDatabaseCharacterSetsSettings = settings.listAutonomousDatabaseCharacterSetsSettings.toBuilder();
            this.listAutonomousDatabaseBackupsSettings = settings.listAutonomousDatabaseBackupsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCloudExadataInfrastructuresSettings, this.getCloudExadataInfrastructureSettings, this.createCloudExadataInfrastructureSettings, this.deleteCloudExadataInfrastructureSettings, this.listCloudVmClustersSettings, this.getCloudVmClusterSettings, this.createCloudVmClusterSettings, this.deleteCloudVmClusterSettings, this.listEntitlementsSettings, this.listDbServersSettings, this.listDbNodesSettings, this.listGiVersionsSettings, (Object[])new UnaryCallSettings.Builder[]{this.listDbSystemShapesSettings, this.listAutonomousDatabasesSettings, this.getAutonomousDatabaseSettings, this.createAutonomousDatabaseSettings, this.deleteAutonomousDatabaseSettings, this.restoreAutonomousDatabaseSettings, this.generateAutonomousDatabaseWalletSettings, this.listAutonomousDbVersionsSettings, this.listAutonomousDatabaseCharacterSetsSettings, this.listAutonomousDatabaseBackupsSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OracleDatabaseStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)OracleDatabaseStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OracleDatabaseStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OracleDatabaseStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listCloudExadataInfrastructuresSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCloudExadataInfrastructureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCloudExadataInfrastructureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteCloudExadataInfrastructureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listCloudVmClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCloudVmClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCloudVmClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteCloudVmClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listEntitlementsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDbServersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDbNodesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listGiVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDbSystemShapesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAutonomousDatabasesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAutonomousDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createAutonomousDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteAutonomousDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.restoreAutonomousDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.generateAutonomousDatabaseWalletSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listAutonomousDbVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAutonomousDatabaseCharacterSetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAutonomousDatabaseBackupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createCloudExadataInfrastructureOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CloudExadataInfrastructure.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(600000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(432000000L)).build()));
            builder.deleteCloudExadataInfrastructureOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(600000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(432000000L)).build()));
            builder.createCloudVmClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CloudVmCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(600000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(432000000L)).build()));
            builder.deleteCloudVmClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(600000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(432000000L)).build()));
            builder.createAutonomousDatabaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AutonomousDatabase.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(600000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(432000000L)).build()));
            builder.deleteAutonomousDatabaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(600000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(432000000L)).build()));
            builder.restoreAutonomousDatabaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AutonomousDatabase.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(600000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(432000000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, OracleDatabaseClient.ListCloudExadataInfrastructuresPagedResponse> listCloudExadataInfrastructuresSettings() {
            return this.listCloudExadataInfrastructuresSettings;
        }

        public UnaryCallSettings.Builder<GetCloudExadataInfrastructureRequest, CloudExadataInfrastructure> getCloudExadataInfrastructureSettings() {
            return this.getCloudExadataInfrastructureSettings;
        }

        public UnaryCallSettings.Builder<CreateCloudExadataInfrastructureRequest, Operation> createCloudExadataInfrastructureSettings() {
            return this.createCloudExadataInfrastructureSettings;
        }

        public OperationCallSettings.Builder<CreateCloudExadataInfrastructureRequest, CloudExadataInfrastructure, OperationMetadata> createCloudExadataInfrastructureOperationSettings() {
            return this.createCloudExadataInfrastructureOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteCloudExadataInfrastructureRequest, Operation> deleteCloudExadataInfrastructureSettings() {
            return this.deleteCloudExadataInfrastructureSettings;
        }

        public OperationCallSettings.Builder<DeleteCloudExadataInfrastructureRequest, Empty, OperationMetadata> deleteCloudExadataInfrastructureOperationSettings() {
            return this.deleteCloudExadataInfrastructureOperationSettings;
        }

        public PagedCallSettings.Builder<ListCloudVmClustersRequest, ListCloudVmClustersResponse, OracleDatabaseClient.ListCloudVmClustersPagedResponse> listCloudVmClustersSettings() {
            return this.listCloudVmClustersSettings;
        }

        public UnaryCallSettings.Builder<GetCloudVmClusterRequest, CloudVmCluster> getCloudVmClusterSettings() {
            return this.getCloudVmClusterSettings;
        }

        public UnaryCallSettings.Builder<CreateCloudVmClusterRequest, Operation> createCloudVmClusterSettings() {
            return this.createCloudVmClusterSettings;
        }

        public OperationCallSettings.Builder<CreateCloudVmClusterRequest, CloudVmCluster, OperationMetadata> createCloudVmClusterOperationSettings() {
            return this.createCloudVmClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteCloudVmClusterRequest, Operation> deleteCloudVmClusterSettings() {
            return this.deleteCloudVmClusterSettings;
        }

        public OperationCallSettings.Builder<DeleteCloudVmClusterRequest, Empty, OperationMetadata> deleteCloudVmClusterOperationSettings() {
            return this.deleteCloudVmClusterOperationSettings;
        }

        public PagedCallSettings.Builder<ListEntitlementsRequest, ListEntitlementsResponse, OracleDatabaseClient.ListEntitlementsPagedResponse> listEntitlementsSettings() {
            return this.listEntitlementsSettings;
        }

        public PagedCallSettings.Builder<ListDbServersRequest, ListDbServersResponse, OracleDatabaseClient.ListDbServersPagedResponse> listDbServersSettings() {
            return this.listDbServersSettings;
        }

        public PagedCallSettings.Builder<ListDbNodesRequest, ListDbNodesResponse, OracleDatabaseClient.ListDbNodesPagedResponse> listDbNodesSettings() {
            return this.listDbNodesSettings;
        }

        public PagedCallSettings.Builder<ListGiVersionsRequest, ListGiVersionsResponse, OracleDatabaseClient.ListGiVersionsPagedResponse> listGiVersionsSettings() {
            return this.listGiVersionsSettings;
        }

        public PagedCallSettings.Builder<ListDbSystemShapesRequest, ListDbSystemShapesResponse, OracleDatabaseClient.ListDbSystemShapesPagedResponse> listDbSystemShapesSettings() {
            return this.listDbSystemShapesSettings;
        }

        public PagedCallSettings.Builder<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, OracleDatabaseClient.ListAutonomousDatabasesPagedResponse> listAutonomousDatabasesSettings() {
            return this.listAutonomousDatabasesSettings;
        }

        public UnaryCallSettings.Builder<GetAutonomousDatabaseRequest, AutonomousDatabase> getAutonomousDatabaseSettings() {
            return this.getAutonomousDatabaseSettings;
        }

        public UnaryCallSettings.Builder<CreateAutonomousDatabaseRequest, Operation> createAutonomousDatabaseSettings() {
            return this.createAutonomousDatabaseSettings;
        }

        public OperationCallSettings.Builder<CreateAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> createAutonomousDatabaseOperationSettings() {
            return this.createAutonomousDatabaseOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAutonomousDatabaseRequest, Operation> deleteAutonomousDatabaseSettings() {
            return this.deleteAutonomousDatabaseSettings;
        }

        public OperationCallSettings.Builder<DeleteAutonomousDatabaseRequest, Empty, OperationMetadata> deleteAutonomousDatabaseOperationSettings() {
            return this.deleteAutonomousDatabaseOperationSettings;
        }

        public UnaryCallSettings.Builder<RestoreAutonomousDatabaseRequest, Operation> restoreAutonomousDatabaseSettings() {
            return this.restoreAutonomousDatabaseSettings;
        }

        public OperationCallSettings.Builder<RestoreAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> restoreAutonomousDatabaseOperationSettings() {
            return this.restoreAutonomousDatabaseOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse> generateAutonomousDatabaseWalletSettings() {
            return this.generateAutonomousDatabaseWalletSettings;
        }

        public PagedCallSettings.Builder<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, OracleDatabaseClient.ListAutonomousDbVersionsPagedResponse> listAutonomousDbVersionsSettings() {
            return this.listAutonomousDbVersionsSettings;
        }

        public PagedCallSettings.Builder<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, OracleDatabaseClient.ListAutonomousDatabaseCharacterSetsPagedResponse> listAutonomousDatabaseCharacterSetsSettings() {
            return this.listAutonomousDatabaseCharacterSetsSettings;
        }

        public PagedCallSettings.Builder<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, OracleDatabaseClient.ListAutonomousDatabaseBackupsPagedResponse> listAutonomousDatabaseBackupsSettings() {
            return this.listAutonomousDatabaseBackupsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, OracleDatabaseClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public OracleDatabaseStubSettings build() throws IOException {
            return new OracleDatabaseStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.INTERNAL, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

