/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkmanagement.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkmanagement.v1.CreateVpcFlowLogsConfigRequest;
import com.google.cloud.networkmanagement.v1.DeleteVpcFlowLogsConfigRequest;
import com.google.cloud.networkmanagement.v1.GetVpcFlowLogsConfigRequest;
import com.google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsRequest;
import com.google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsResponse;
import com.google.cloud.networkmanagement.v1.LocationName;
import com.google.cloud.networkmanagement.v1.OperationMetadata;
import com.google.cloud.networkmanagement.v1.UpdateVpcFlowLogsConfigRequest;
import com.google.cloud.networkmanagement.v1.VpcFlowLogsConfig;
import com.google.cloud.networkmanagement.v1.VpcFlowLogsConfigName;
import com.google.cloud.networkmanagement.v1.VpcFlowLogsServiceSettings;
import com.google.cloud.networkmanagement.v1.stub.VpcFlowLogsServiceStub;
import com.google.cloud.networkmanagement.v1.stub.VpcFlowLogsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class VpcFlowLogsServiceClient
implements BackgroundResource {
    private final VpcFlowLogsServiceSettings settings;
    private final VpcFlowLogsServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final VpcFlowLogsServiceClient create() throws IOException {
        return VpcFlowLogsServiceClient.create(VpcFlowLogsServiceSettings.newBuilder().build());
    }

    public static final VpcFlowLogsServiceClient create(VpcFlowLogsServiceSettings settings) throws IOException {
        return new VpcFlowLogsServiceClient(settings);
    }

    public static final VpcFlowLogsServiceClient create(VpcFlowLogsServiceStub stub) {
        return new VpcFlowLogsServiceClient(stub);
    }

    protected VpcFlowLogsServiceClient(VpcFlowLogsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VpcFlowLogsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected VpcFlowLogsServiceClient(VpcFlowLogsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final VpcFlowLogsServiceSettings getSettings() {
        return this.settings;
    }

    public VpcFlowLogsServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListVpcFlowLogsConfigsPagedResponse listVpcFlowLogsConfigs(LocationName parent) {
        ListVpcFlowLogsConfigsRequest request = ListVpcFlowLogsConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVpcFlowLogsConfigs(request);
    }

    public final ListVpcFlowLogsConfigsPagedResponse listVpcFlowLogsConfigs(String parent) {
        ListVpcFlowLogsConfigsRequest request = ListVpcFlowLogsConfigsRequest.newBuilder().setParent(parent).build();
        return this.listVpcFlowLogsConfigs(request);
    }

    public final ListVpcFlowLogsConfigsPagedResponse listVpcFlowLogsConfigs(ListVpcFlowLogsConfigsRequest request) {
        return (ListVpcFlowLogsConfigsPagedResponse)((Object)this.listVpcFlowLogsConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVpcFlowLogsConfigsRequest, ListVpcFlowLogsConfigsPagedResponse> listVpcFlowLogsConfigsPagedCallable() {
        return this.stub.listVpcFlowLogsConfigsPagedCallable();
    }

    public final UnaryCallable<ListVpcFlowLogsConfigsRequest, ListVpcFlowLogsConfigsResponse> listVpcFlowLogsConfigsCallable() {
        return this.stub.listVpcFlowLogsConfigsCallable();
    }

    public final VpcFlowLogsConfig getVpcFlowLogsConfig(VpcFlowLogsConfigName name) {
        GetVpcFlowLogsConfigRequest request = GetVpcFlowLogsConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVpcFlowLogsConfig(request);
    }

    public final VpcFlowLogsConfig getVpcFlowLogsConfig(String name) {
        GetVpcFlowLogsConfigRequest request = GetVpcFlowLogsConfigRequest.newBuilder().setName(name).build();
        return this.getVpcFlowLogsConfig(request);
    }

    public final VpcFlowLogsConfig getVpcFlowLogsConfig(GetVpcFlowLogsConfigRequest request) {
        return (VpcFlowLogsConfig)this.getVpcFlowLogsConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetVpcFlowLogsConfigRequest, VpcFlowLogsConfig> getVpcFlowLogsConfigCallable() {
        return this.stub.getVpcFlowLogsConfigCallable();
    }

    public final OperationFuture<VpcFlowLogsConfig, OperationMetadata> createVpcFlowLogsConfigAsync(LocationName parent, VpcFlowLogsConfig vpcFlowLogsConfig, VpcFlowLogsConfigName vpcFlowLogsConfigId) {
        CreateVpcFlowLogsConfigRequest request = CreateVpcFlowLogsConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVpcFlowLogsConfig(vpcFlowLogsConfig).setVpcFlowLogsConfigId(vpcFlowLogsConfigId == null ? null : vpcFlowLogsConfigId.toString()).build();
        return this.createVpcFlowLogsConfigAsync(request);
    }

    public final OperationFuture<VpcFlowLogsConfig, OperationMetadata> createVpcFlowLogsConfigAsync(LocationName parent, VpcFlowLogsConfig vpcFlowLogsConfig, String vpcFlowLogsConfigId) {
        CreateVpcFlowLogsConfigRequest request = CreateVpcFlowLogsConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVpcFlowLogsConfig(vpcFlowLogsConfig).setVpcFlowLogsConfigId(vpcFlowLogsConfigId).build();
        return this.createVpcFlowLogsConfigAsync(request);
    }

    public final OperationFuture<VpcFlowLogsConfig, OperationMetadata> createVpcFlowLogsConfigAsync(String parent, VpcFlowLogsConfig vpcFlowLogsConfig, VpcFlowLogsConfigName vpcFlowLogsConfigId) {
        CreateVpcFlowLogsConfigRequest request = CreateVpcFlowLogsConfigRequest.newBuilder().setParent(parent).setVpcFlowLogsConfig(vpcFlowLogsConfig).setVpcFlowLogsConfigId(vpcFlowLogsConfigId == null ? null : vpcFlowLogsConfigId.toString()).build();
        return this.createVpcFlowLogsConfigAsync(request);
    }

    public final OperationFuture<VpcFlowLogsConfig, OperationMetadata> createVpcFlowLogsConfigAsync(String parent, VpcFlowLogsConfig vpcFlowLogsConfig, String vpcFlowLogsConfigId) {
        CreateVpcFlowLogsConfigRequest request = CreateVpcFlowLogsConfigRequest.newBuilder().setParent(parent).setVpcFlowLogsConfig(vpcFlowLogsConfig).setVpcFlowLogsConfigId(vpcFlowLogsConfigId).build();
        return this.createVpcFlowLogsConfigAsync(request);
    }

    public final OperationFuture<VpcFlowLogsConfig, OperationMetadata> createVpcFlowLogsConfigAsync(CreateVpcFlowLogsConfigRequest request) {
        return this.createVpcFlowLogsConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateVpcFlowLogsConfigRequest, VpcFlowLogsConfig, OperationMetadata> createVpcFlowLogsConfigOperationCallable() {
        return this.stub.createVpcFlowLogsConfigOperationCallable();
    }

    public final UnaryCallable<CreateVpcFlowLogsConfigRequest, Operation> createVpcFlowLogsConfigCallable() {
        return this.stub.createVpcFlowLogsConfigCallable();
    }

    public final OperationFuture<VpcFlowLogsConfig, OperationMetadata> updateVpcFlowLogsConfigAsync(VpcFlowLogsConfig vpcFlowLogsConfig, FieldMask updateMask) {
        UpdateVpcFlowLogsConfigRequest request = UpdateVpcFlowLogsConfigRequest.newBuilder().setVpcFlowLogsConfig(vpcFlowLogsConfig).setUpdateMask(updateMask).build();
        return this.updateVpcFlowLogsConfigAsync(request);
    }

    public final OperationFuture<VpcFlowLogsConfig, OperationMetadata> updateVpcFlowLogsConfigAsync(UpdateVpcFlowLogsConfigRequest request) {
        return this.updateVpcFlowLogsConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateVpcFlowLogsConfigRequest, VpcFlowLogsConfig, OperationMetadata> updateVpcFlowLogsConfigOperationCallable() {
        return this.stub.updateVpcFlowLogsConfigOperationCallable();
    }

    public final UnaryCallable<UpdateVpcFlowLogsConfigRequest, Operation> updateVpcFlowLogsConfigCallable() {
        return this.stub.updateVpcFlowLogsConfigCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVpcFlowLogsConfigAsync(VpcFlowLogsConfigName name) {
        DeleteVpcFlowLogsConfigRequest request = DeleteVpcFlowLogsConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteVpcFlowLogsConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVpcFlowLogsConfigAsync(String name) {
        DeleteVpcFlowLogsConfigRequest request = DeleteVpcFlowLogsConfigRequest.newBuilder().setName(name).build();
        return this.deleteVpcFlowLogsConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVpcFlowLogsConfigAsync(DeleteVpcFlowLogsConfigRequest request) {
        return this.deleteVpcFlowLogsConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteVpcFlowLogsConfigRequest, Empty, OperationMetadata> deleteVpcFlowLogsConfigOperationCallable() {
        return this.stub.deleteVpcFlowLogsConfigOperationCallable();
    }

    public final UnaryCallable<DeleteVpcFlowLogsConfigRequest, Operation> deleteVpcFlowLogsConfigCallable() {
        return this.stub.deleteVpcFlowLogsConfigCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVpcFlowLogsConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVpcFlowLogsConfigsRequest, ListVpcFlowLogsConfigsResponse, VpcFlowLogsConfig, ListVpcFlowLogsConfigsPage, ListVpcFlowLogsConfigsFixedSizeCollection> {
        private ListVpcFlowLogsConfigsFixedSizeCollection(List<ListVpcFlowLogsConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVpcFlowLogsConfigsFixedSizeCollection createEmptyCollection() {
            return new ListVpcFlowLogsConfigsFixedSizeCollection(null, 0);
        }

        protected ListVpcFlowLogsConfigsFixedSizeCollection createCollection(List<ListVpcFlowLogsConfigsPage> pages, int collectionSize) {
            return new ListVpcFlowLogsConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVpcFlowLogsConfigsPage
    extends AbstractPage<ListVpcFlowLogsConfigsRequest, ListVpcFlowLogsConfigsResponse, VpcFlowLogsConfig, ListVpcFlowLogsConfigsPage> {
        private ListVpcFlowLogsConfigsPage(PageContext<ListVpcFlowLogsConfigsRequest, ListVpcFlowLogsConfigsResponse, VpcFlowLogsConfig> context, ListVpcFlowLogsConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListVpcFlowLogsConfigsPage createEmptyPage() {
            return new ListVpcFlowLogsConfigsPage(null, null);
        }

        protected ListVpcFlowLogsConfigsPage createPage(PageContext<ListVpcFlowLogsConfigsRequest, ListVpcFlowLogsConfigsResponse, VpcFlowLogsConfig> context, ListVpcFlowLogsConfigsResponse response) {
            return new ListVpcFlowLogsConfigsPage(context, response);
        }

        public ApiFuture<ListVpcFlowLogsConfigsPage> createPageAsync(PageContext<ListVpcFlowLogsConfigsRequest, ListVpcFlowLogsConfigsResponse, VpcFlowLogsConfig> context, ApiFuture<ListVpcFlowLogsConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVpcFlowLogsConfigsPagedResponse
    extends AbstractPagedListResponse<ListVpcFlowLogsConfigsRequest, ListVpcFlowLogsConfigsResponse, VpcFlowLogsConfig, ListVpcFlowLogsConfigsPage, ListVpcFlowLogsConfigsFixedSizeCollection> {
        public static ApiFuture<ListVpcFlowLogsConfigsPagedResponse> createAsync(PageContext<ListVpcFlowLogsConfigsRequest, ListVpcFlowLogsConfigsResponse, VpcFlowLogsConfig> context, ApiFuture<ListVpcFlowLogsConfigsResponse> futureResponse) {
            ApiFuture<ListVpcFlowLogsConfigsPage> futurePage = ListVpcFlowLogsConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVpcFlowLogsConfigsPagedResponse((ListVpcFlowLogsConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVpcFlowLogsConfigsPagedResponse(ListVpcFlowLogsConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVpcFlowLogsConfigsFixedSizeCollection.createEmptyCollection());
        }
    }
}

