/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.meet.v2beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.apps.meet.v2beta.ConnectActiveConferenceRequest;
import com.google.apps.meet.v2beta.ConnectActiveConferenceResponse;
import com.google.apps.meet.v2beta.CreateMemberRequest;
import com.google.apps.meet.v2beta.CreateSpaceRequest;
import com.google.apps.meet.v2beta.DeleteMemberRequest;
import com.google.apps.meet.v2beta.EndActiveConferenceRequest;
import com.google.apps.meet.v2beta.GetMemberRequest;
import com.google.apps.meet.v2beta.GetSpaceRequest;
import com.google.apps.meet.v2beta.ListMembersRequest;
import com.google.apps.meet.v2beta.ListMembersResponse;
import com.google.apps.meet.v2beta.Member;
import com.google.apps.meet.v2beta.MemberName;
import com.google.apps.meet.v2beta.Space;
import com.google.apps.meet.v2beta.SpaceName;
import com.google.apps.meet.v2beta.SpacesServiceSettings;
import com.google.apps.meet.v2beta.UpdateSpaceRequest;
import com.google.apps.meet.v2beta.stub.SpacesServiceStub;
import com.google.apps.meet.v2beta.stub.SpacesServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SpacesServiceClient
implements BackgroundResource {
    private final SpacesServiceSettings settings;
    private final SpacesServiceStub stub;

    public static final SpacesServiceClient create() throws IOException {
        return SpacesServiceClient.create(SpacesServiceSettings.newBuilder().build());
    }

    public static final SpacesServiceClient create(SpacesServiceSettings settings) throws IOException {
        return new SpacesServiceClient(settings);
    }

    public static final SpacesServiceClient create(SpacesServiceStub stub) {
        return new SpacesServiceClient(stub);
    }

    protected SpacesServiceClient(SpacesServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SpacesServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected SpacesServiceClient(SpacesServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SpacesServiceSettings getSettings() {
        return this.settings;
    }

    public SpacesServiceStub getStub() {
        return this.stub;
    }

    public final Space createSpace(Space space) {
        CreateSpaceRequest request = CreateSpaceRequest.newBuilder().setSpace(space).build();
        return this.createSpace(request);
    }

    public final Space createSpace(CreateSpaceRequest request) {
        return (Space)this.createSpaceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSpaceRequest, Space> createSpaceCallable() {
        return this.stub.createSpaceCallable();
    }

    public final Space getSpace(SpaceName name) {
        GetSpaceRequest request = GetSpaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSpace(request);
    }

    public final Space getSpace(String name) {
        GetSpaceRequest request = GetSpaceRequest.newBuilder().setName(name).build();
        return this.getSpace(request);
    }

    public final Space getSpace(GetSpaceRequest request) {
        return (Space)this.getSpaceCallable().call((Object)request);
    }

    public final UnaryCallable<GetSpaceRequest, Space> getSpaceCallable() {
        return this.stub.getSpaceCallable();
    }

    public final Space updateSpace(Space space, FieldMask updateMask) {
        UpdateSpaceRequest request = UpdateSpaceRequest.newBuilder().setSpace(space).setUpdateMask(updateMask).build();
        return this.updateSpace(request);
    }

    public final Space updateSpace(UpdateSpaceRequest request) {
        return (Space)this.updateSpaceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSpaceRequest, Space> updateSpaceCallable() {
        return this.stub.updateSpaceCallable();
    }

    public final ConnectActiveConferenceResponse connectActiveConference(SpaceName name) {
        ConnectActiveConferenceRequest request = ConnectActiveConferenceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.connectActiveConference(request);
    }

    public final ConnectActiveConferenceResponse connectActiveConference(String name) {
        ConnectActiveConferenceRequest request = ConnectActiveConferenceRequest.newBuilder().setName(name).build();
        return this.connectActiveConference(request);
    }

    public final ConnectActiveConferenceResponse connectActiveConference(ConnectActiveConferenceRequest request) {
        return (ConnectActiveConferenceResponse)this.connectActiveConferenceCallable().call((Object)request);
    }

    public final UnaryCallable<ConnectActiveConferenceRequest, ConnectActiveConferenceResponse> connectActiveConferenceCallable() {
        return this.stub.connectActiveConferenceCallable();
    }

    public final void endActiveConference(SpaceName name) {
        EndActiveConferenceRequest request = EndActiveConferenceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.endActiveConference(request);
    }

    public final void endActiveConference(String name) {
        EndActiveConferenceRequest request = EndActiveConferenceRequest.newBuilder().setName(name).build();
        this.endActiveConference(request);
    }

    public final void endActiveConference(EndActiveConferenceRequest request) {
        this.endActiveConferenceCallable().call((Object)request);
    }

    public final UnaryCallable<EndActiveConferenceRequest, Empty> endActiveConferenceCallable() {
        return this.stub.endActiveConferenceCallable();
    }

    public final Member createMember(SpaceName parent, Member member) {
        CreateMemberRequest request = CreateMemberRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMember(member).build();
        return this.createMember(request);
    }

    public final Member createMember(String parent, Member member) {
        CreateMemberRequest request = CreateMemberRequest.newBuilder().setParent(parent).setMember(member).build();
        return this.createMember(request);
    }

    public final Member createMember(CreateMemberRequest request) {
        return (Member)this.createMemberCallable().call((Object)request);
    }

    public final UnaryCallable<CreateMemberRequest, Member> createMemberCallable() {
        return this.stub.createMemberCallable();
    }

    public final Member getMember(MemberName name) {
        GetMemberRequest request = GetMemberRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMember(request);
    }

    public final Member getMember(String name) {
        GetMemberRequest request = GetMemberRequest.newBuilder().setName(name).build();
        return this.getMember(request);
    }

    public final Member getMember(GetMemberRequest request) {
        return (Member)this.getMemberCallable().call((Object)request);
    }

    public final UnaryCallable<GetMemberRequest, Member> getMemberCallable() {
        return this.stub.getMemberCallable();
    }

    public final ListMembersPagedResponse listMembers(SpaceName parent) {
        ListMembersRequest request = ListMembersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMembers(request);
    }

    public final ListMembersPagedResponse listMembers(String parent) {
        ListMembersRequest request = ListMembersRequest.newBuilder().setParent(parent).build();
        return this.listMembers(request);
    }

    public final ListMembersPagedResponse listMembers(ListMembersRequest request) {
        return (ListMembersPagedResponse)((Object)this.listMembersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMembersRequest, ListMembersPagedResponse> listMembersPagedCallable() {
        return this.stub.listMembersPagedCallable();
    }

    public final UnaryCallable<ListMembersRequest, ListMembersResponse> listMembersCallable() {
        return this.stub.listMembersCallable();
    }

    public final void deleteMember(MemberName name) {
        DeleteMemberRequest request = DeleteMemberRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteMember(request);
    }

    public final void deleteMember(String name) {
        DeleteMemberRequest request = DeleteMemberRequest.newBuilder().setName(name).build();
        this.deleteMember(request);
    }

    public final void deleteMember(DeleteMemberRequest request) {
        this.deleteMemberCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteMemberRequest, Empty> deleteMemberCallable() {
        return this.stub.deleteMemberCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListMembersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMembersRequest, ListMembersResponse, Member, ListMembersPage, ListMembersFixedSizeCollection> {
        private ListMembersFixedSizeCollection(List<ListMembersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMembersFixedSizeCollection createEmptyCollection() {
            return new ListMembersFixedSizeCollection(null, 0);
        }

        protected ListMembersFixedSizeCollection createCollection(List<ListMembersPage> pages, int collectionSize) {
            return new ListMembersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMembersPage
    extends AbstractPage<ListMembersRequest, ListMembersResponse, Member, ListMembersPage> {
        private ListMembersPage(PageContext<ListMembersRequest, ListMembersResponse, Member> context, ListMembersResponse response) {
            super(context, (Object)response);
        }

        private static ListMembersPage createEmptyPage() {
            return new ListMembersPage(null, null);
        }

        protected ListMembersPage createPage(PageContext<ListMembersRequest, ListMembersResponse, Member> context, ListMembersResponse response) {
            return new ListMembersPage(context, response);
        }

        public ApiFuture<ListMembersPage> createPageAsync(PageContext<ListMembersRequest, ListMembersResponse, Member> context, ApiFuture<ListMembersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMembersPagedResponse
    extends AbstractPagedListResponse<ListMembersRequest, ListMembersResponse, Member, ListMembersPage, ListMembersFixedSizeCollection> {
        public static ApiFuture<ListMembersPagedResponse> createAsync(PageContext<ListMembersRequest, ListMembersResponse, Member> context, ApiFuture<ListMembersResponse> futureResponse) {
            ApiFuture<ListMembersPage> futurePage = ListMembersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMembersPagedResponse((ListMembersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMembersPagedResponse(ListMembersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMembersFixedSizeCollection.createEmptyCollection());
        }
    }
}

