/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.managedkafka.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.managedkafka.v1.ConnectCluster;
import com.google.cloud.managedkafka.v1.ConnectClusterName;
import com.google.cloud.managedkafka.v1.Connector;
import com.google.cloud.managedkafka.v1.ConnectorName;
import com.google.cloud.managedkafka.v1.CreateConnectClusterRequest;
import com.google.cloud.managedkafka.v1.CreateConnectorRequest;
import com.google.cloud.managedkafka.v1.DeleteConnectClusterRequest;
import com.google.cloud.managedkafka.v1.DeleteConnectorRequest;
import com.google.cloud.managedkafka.v1.GetConnectClusterRequest;
import com.google.cloud.managedkafka.v1.GetConnectorRequest;
import com.google.cloud.managedkafka.v1.ListConnectClustersRequest;
import com.google.cloud.managedkafka.v1.ListConnectClustersResponse;
import com.google.cloud.managedkafka.v1.ListConnectorsRequest;
import com.google.cloud.managedkafka.v1.ListConnectorsResponse;
import com.google.cloud.managedkafka.v1.LocationName;
import com.google.cloud.managedkafka.v1.ManagedKafkaConnectSettings;
import com.google.cloud.managedkafka.v1.OperationMetadata;
import com.google.cloud.managedkafka.v1.PauseConnectorRequest;
import com.google.cloud.managedkafka.v1.PauseConnectorResponse;
import com.google.cloud.managedkafka.v1.RestartConnectorRequest;
import com.google.cloud.managedkafka.v1.RestartConnectorResponse;
import com.google.cloud.managedkafka.v1.ResumeConnectorRequest;
import com.google.cloud.managedkafka.v1.ResumeConnectorResponse;
import com.google.cloud.managedkafka.v1.StopConnectorRequest;
import com.google.cloud.managedkafka.v1.StopConnectorResponse;
import com.google.cloud.managedkafka.v1.UpdateConnectClusterRequest;
import com.google.cloud.managedkafka.v1.UpdateConnectorRequest;
import com.google.cloud.managedkafka.v1.stub.ManagedKafkaConnectStub;
import com.google.cloud.managedkafka.v1.stub.ManagedKafkaConnectStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ManagedKafkaConnectClient
implements BackgroundResource {
    private final ManagedKafkaConnectSettings settings;
    private final ManagedKafkaConnectStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ManagedKafkaConnectClient create() throws IOException {
        return ManagedKafkaConnectClient.create(ManagedKafkaConnectSettings.newBuilder().build());
    }

    public static final ManagedKafkaConnectClient create(ManagedKafkaConnectSettings settings) throws IOException {
        return new ManagedKafkaConnectClient(settings);
    }

    public static final ManagedKafkaConnectClient create(ManagedKafkaConnectStub stub) {
        return new ManagedKafkaConnectClient(stub);
    }

    protected ManagedKafkaConnectClient(ManagedKafkaConnectSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ManagedKafkaConnectStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ManagedKafkaConnectClient(ManagedKafkaConnectStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ManagedKafkaConnectSettings getSettings() {
        return this.settings;
    }

    public ManagedKafkaConnectStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListConnectClustersPagedResponse listConnectClusters(LocationName parent) {
        ListConnectClustersRequest request = ListConnectClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConnectClusters(request);
    }

    public final ListConnectClustersPagedResponse listConnectClusters(String parent) {
        ListConnectClustersRequest request = ListConnectClustersRequest.newBuilder().setParent(parent).build();
        return this.listConnectClusters(request);
    }

    public final ListConnectClustersPagedResponse listConnectClusters(ListConnectClustersRequest request) {
        return (ListConnectClustersPagedResponse)((Object)this.listConnectClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConnectClustersRequest, ListConnectClustersPagedResponse> listConnectClustersPagedCallable() {
        return this.stub.listConnectClustersPagedCallable();
    }

    public final UnaryCallable<ListConnectClustersRequest, ListConnectClustersResponse> listConnectClustersCallable() {
        return this.stub.listConnectClustersCallable();
    }

    public final ConnectCluster getConnectCluster(ConnectClusterName name) {
        GetConnectClusterRequest request = GetConnectClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConnectCluster(request);
    }

    public final ConnectCluster getConnectCluster(String name) {
        GetConnectClusterRequest request = GetConnectClusterRequest.newBuilder().setName(name).build();
        return this.getConnectCluster(request);
    }

    public final ConnectCluster getConnectCluster(GetConnectClusterRequest request) {
        return (ConnectCluster)this.getConnectClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetConnectClusterRequest, ConnectCluster> getConnectClusterCallable() {
        return this.stub.getConnectClusterCallable();
    }

    public final OperationFuture<ConnectCluster, OperationMetadata> createConnectClusterAsync(LocationName parent, ConnectCluster connectCluster, String connectClusterId) {
        CreateConnectClusterRequest request = CreateConnectClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConnectCluster(connectCluster).setConnectClusterId(connectClusterId).build();
        return this.createConnectClusterAsync(request);
    }

    public final OperationFuture<ConnectCluster, OperationMetadata> createConnectClusterAsync(String parent, ConnectCluster connectCluster, String connectClusterId) {
        CreateConnectClusterRequest request = CreateConnectClusterRequest.newBuilder().setParent(parent).setConnectCluster(connectCluster).setConnectClusterId(connectClusterId).build();
        return this.createConnectClusterAsync(request);
    }

    public final OperationFuture<ConnectCluster, OperationMetadata> createConnectClusterAsync(CreateConnectClusterRequest request) {
        return this.createConnectClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateConnectClusterRequest, ConnectCluster, OperationMetadata> createConnectClusterOperationCallable() {
        return this.stub.createConnectClusterOperationCallable();
    }

    public final UnaryCallable<CreateConnectClusterRequest, Operation> createConnectClusterCallable() {
        return this.stub.createConnectClusterCallable();
    }

    public final OperationFuture<ConnectCluster, OperationMetadata> updateConnectClusterAsync(ConnectCluster connectCluster, FieldMask updateMask) {
        UpdateConnectClusterRequest request = UpdateConnectClusterRequest.newBuilder().setConnectCluster(connectCluster).setUpdateMask(updateMask).build();
        return this.updateConnectClusterAsync(request);
    }

    public final OperationFuture<ConnectCluster, OperationMetadata> updateConnectClusterAsync(UpdateConnectClusterRequest request) {
        return this.updateConnectClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateConnectClusterRequest, ConnectCluster, OperationMetadata> updateConnectClusterOperationCallable() {
        return this.stub.updateConnectClusterOperationCallable();
    }

    public final UnaryCallable<UpdateConnectClusterRequest, Operation> updateConnectClusterCallable() {
        return this.stub.updateConnectClusterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectClusterAsync(ConnectClusterName name) {
        DeleteConnectClusterRequest request = DeleteConnectClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteConnectClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectClusterAsync(String name) {
        DeleteConnectClusterRequest request = DeleteConnectClusterRequest.newBuilder().setName(name).build();
        return this.deleteConnectClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectClusterAsync(DeleteConnectClusterRequest request) {
        return this.deleteConnectClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteConnectClusterRequest, Empty, OperationMetadata> deleteConnectClusterOperationCallable() {
        return this.stub.deleteConnectClusterOperationCallable();
    }

    public final UnaryCallable<DeleteConnectClusterRequest, Operation> deleteConnectClusterCallable() {
        return this.stub.deleteConnectClusterCallable();
    }

    public final ListConnectorsPagedResponse listConnectors(ConnectClusterName parent) {
        ListConnectorsRequest request = ListConnectorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConnectors(request);
    }

    public final ListConnectorsPagedResponse listConnectors(String parent) {
        ListConnectorsRequest request = ListConnectorsRequest.newBuilder().setParent(parent).build();
        return this.listConnectors(request);
    }

    public final ListConnectorsPagedResponse listConnectors(ListConnectorsRequest request) {
        return (ListConnectorsPagedResponse)((Object)this.listConnectorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConnectorsRequest, ListConnectorsPagedResponse> listConnectorsPagedCallable() {
        return this.stub.listConnectorsPagedCallable();
    }

    public final UnaryCallable<ListConnectorsRequest, ListConnectorsResponse> listConnectorsCallable() {
        return this.stub.listConnectorsCallable();
    }

    public final Connector getConnector(ConnectorName name) {
        GetConnectorRequest request = GetConnectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConnector(request);
    }

    public final Connector getConnector(String name) {
        GetConnectorRequest request = GetConnectorRequest.newBuilder().setName(name).build();
        return this.getConnector(request);
    }

    public final Connector getConnector(GetConnectorRequest request) {
        return (Connector)this.getConnectorCallable().call((Object)request);
    }

    public final UnaryCallable<GetConnectorRequest, Connector> getConnectorCallable() {
        return this.stub.getConnectorCallable();
    }

    public final Connector createConnector(ConnectClusterName parent, Connector connector, String connectorId) {
        CreateConnectorRequest request = CreateConnectorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConnector(connector).setConnectorId(connectorId).build();
        return this.createConnector(request);
    }

    public final Connector createConnector(String parent, Connector connector, String connectorId) {
        CreateConnectorRequest request = CreateConnectorRequest.newBuilder().setParent(parent).setConnector(connector).setConnectorId(connectorId).build();
        return this.createConnector(request);
    }

    public final Connector createConnector(CreateConnectorRequest request) {
        return (Connector)this.createConnectorCallable().call((Object)request);
    }

    public final UnaryCallable<CreateConnectorRequest, Connector> createConnectorCallable() {
        return this.stub.createConnectorCallable();
    }

    public final Connector updateConnector(Connector connector, FieldMask updateMask) {
        UpdateConnectorRequest request = UpdateConnectorRequest.newBuilder().setConnector(connector).setUpdateMask(updateMask).build();
        return this.updateConnector(request);
    }

    public final Connector updateConnector(UpdateConnectorRequest request) {
        return (Connector)this.updateConnectorCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateConnectorRequest, Connector> updateConnectorCallable() {
        return this.stub.updateConnectorCallable();
    }

    public final void deleteConnector(ConnectorName name) {
        DeleteConnectorRequest request = DeleteConnectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteConnector(request);
    }

    public final void deleteConnector(String name) {
        DeleteConnectorRequest request = DeleteConnectorRequest.newBuilder().setName(name).build();
        this.deleteConnector(request);
    }

    public final void deleteConnector(DeleteConnectorRequest request) {
        this.deleteConnectorCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteConnectorRequest, Empty> deleteConnectorCallable() {
        return this.stub.deleteConnectorCallable();
    }

    public final PauseConnectorResponse pauseConnector(ConnectorName name) {
        PauseConnectorRequest request = PauseConnectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.pauseConnector(request);
    }

    public final PauseConnectorResponse pauseConnector(String name) {
        PauseConnectorRequest request = PauseConnectorRequest.newBuilder().setName(name).build();
        return this.pauseConnector(request);
    }

    public final PauseConnectorResponse pauseConnector(PauseConnectorRequest request) {
        return (PauseConnectorResponse)this.pauseConnectorCallable().call((Object)request);
    }

    public final UnaryCallable<PauseConnectorRequest, PauseConnectorResponse> pauseConnectorCallable() {
        return this.stub.pauseConnectorCallable();
    }

    public final ResumeConnectorResponse resumeConnector(ConnectorName name) {
        ResumeConnectorRequest request = ResumeConnectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.resumeConnector(request);
    }

    public final ResumeConnectorResponse resumeConnector(String name) {
        ResumeConnectorRequest request = ResumeConnectorRequest.newBuilder().setName(name).build();
        return this.resumeConnector(request);
    }

    public final ResumeConnectorResponse resumeConnector(ResumeConnectorRequest request) {
        return (ResumeConnectorResponse)this.resumeConnectorCallable().call((Object)request);
    }

    public final UnaryCallable<ResumeConnectorRequest, ResumeConnectorResponse> resumeConnectorCallable() {
        return this.stub.resumeConnectorCallable();
    }

    public final RestartConnectorResponse restartConnector(ConnectorName name) {
        RestartConnectorRequest request = RestartConnectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.restartConnector(request);
    }

    public final RestartConnectorResponse restartConnector(String name) {
        RestartConnectorRequest request = RestartConnectorRequest.newBuilder().setName(name).build();
        return this.restartConnector(request);
    }

    public final RestartConnectorResponse restartConnector(RestartConnectorRequest request) {
        return (RestartConnectorResponse)this.restartConnectorCallable().call((Object)request);
    }

    public final UnaryCallable<RestartConnectorRequest, RestartConnectorResponse> restartConnectorCallable() {
        return this.stub.restartConnectorCallable();
    }

    public final StopConnectorResponse stopConnector(ConnectorName name) {
        StopConnectorRequest request = StopConnectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.stopConnector(request);
    }

    public final StopConnectorResponse stopConnector(String name) {
        StopConnectorRequest request = StopConnectorRequest.newBuilder().setName(name).build();
        return this.stopConnector(request);
    }

    public final StopConnectorResponse stopConnector(StopConnectorRequest request) {
        return (StopConnectorResponse)this.stopConnectorCallable().call((Object)request);
    }

    public final UnaryCallable<StopConnectorRequest, StopConnectorResponse> stopConnectorCallable() {
        return this.stub.stopConnectorCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConnectorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConnectorsRequest, ListConnectorsResponse, Connector, ListConnectorsPage, ListConnectorsFixedSizeCollection> {
        private ListConnectorsFixedSizeCollection(List<ListConnectorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConnectorsFixedSizeCollection createEmptyCollection() {
            return new ListConnectorsFixedSizeCollection(null, 0);
        }

        protected ListConnectorsFixedSizeCollection createCollection(List<ListConnectorsPage> pages, int collectionSize) {
            return new ListConnectorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConnectorsPage
    extends AbstractPage<ListConnectorsRequest, ListConnectorsResponse, Connector, ListConnectorsPage> {
        private ListConnectorsPage(PageContext<ListConnectorsRequest, ListConnectorsResponse, Connector> context, ListConnectorsResponse response) {
            super(context, (Object)response);
        }

        private static ListConnectorsPage createEmptyPage() {
            return new ListConnectorsPage(null, null);
        }

        protected ListConnectorsPage createPage(PageContext<ListConnectorsRequest, ListConnectorsResponse, Connector> context, ListConnectorsResponse response) {
            return new ListConnectorsPage(context, response);
        }

        public ApiFuture<ListConnectorsPage> createPageAsync(PageContext<ListConnectorsRequest, ListConnectorsResponse, Connector> context, ApiFuture<ListConnectorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConnectorsPagedResponse
    extends AbstractPagedListResponse<ListConnectorsRequest, ListConnectorsResponse, Connector, ListConnectorsPage, ListConnectorsFixedSizeCollection> {
        public static ApiFuture<ListConnectorsPagedResponse> createAsync(PageContext<ListConnectorsRequest, ListConnectorsResponse, Connector> context, ApiFuture<ListConnectorsResponse> futureResponse) {
            ApiFuture<ListConnectorsPage> futurePage = ListConnectorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConnectorsPagedResponse((ListConnectorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConnectorsPagedResponse(ListConnectorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConnectorsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConnectClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConnectClustersRequest, ListConnectClustersResponse, ConnectCluster, ListConnectClustersPage, ListConnectClustersFixedSizeCollection> {
        private ListConnectClustersFixedSizeCollection(List<ListConnectClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConnectClustersFixedSizeCollection createEmptyCollection() {
            return new ListConnectClustersFixedSizeCollection(null, 0);
        }

        protected ListConnectClustersFixedSizeCollection createCollection(List<ListConnectClustersPage> pages, int collectionSize) {
            return new ListConnectClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConnectClustersPage
    extends AbstractPage<ListConnectClustersRequest, ListConnectClustersResponse, ConnectCluster, ListConnectClustersPage> {
        private ListConnectClustersPage(PageContext<ListConnectClustersRequest, ListConnectClustersResponse, ConnectCluster> context, ListConnectClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListConnectClustersPage createEmptyPage() {
            return new ListConnectClustersPage(null, null);
        }

        protected ListConnectClustersPage createPage(PageContext<ListConnectClustersRequest, ListConnectClustersResponse, ConnectCluster> context, ListConnectClustersResponse response) {
            return new ListConnectClustersPage(context, response);
        }

        public ApiFuture<ListConnectClustersPage> createPageAsync(PageContext<ListConnectClustersRequest, ListConnectClustersResponse, ConnectCluster> context, ApiFuture<ListConnectClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConnectClustersPagedResponse
    extends AbstractPagedListResponse<ListConnectClustersRequest, ListConnectClustersResponse, ConnectCluster, ListConnectClustersPage, ListConnectClustersFixedSizeCollection> {
        public static ApiFuture<ListConnectClustersPagedResponse> createAsync(PageContext<ListConnectClustersRequest, ListConnectClustersResponse, ConnectCluster> context, ApiFuture<ListConnectClustersResponse> futureResponse) {
            ApiFuture<ListConnectClustersPage> futurePage = ListConnectClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConnectClustersPagedResponse((ListConnectClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConnectClustersPagedResponse(ListConnectClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConnectClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

