/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.managedkafka.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.managedkafka.v1.Cluster;
import com.google.cloud.managedkafka.v1.ClusterName;
import com.google.cloud.managedkafka.v1.ConsumerGroup;
import com.google.cloud.managedkafka.v1.ConsumerGroupName;
import com.google.cloud.managedkafka.v1.CreateClusterRequest;
import com.google.cloud.managedkafka.v1.CreateTopicRequest;
import com.google.cloud.managedkafka.v1.DeleteClusterRequest;
import com.google.cloud.managedkafka.v1.DeleteConsumerGroupRequest;
import com.google.cloud.managedkafka.v1.DeleteTopicRequest;
import com.google.cloud.managedkafka.v1.GetClusterRequest;
import com.google.cloud.managedkafka.v1.GetConsumerGroupRequest;
import com.google.cloud.managedkafka.v1.GetTopicRequest;
import com.google.cloud.managedkafka.v1.ListClustersRequest;
import com.google.cloud.managedkafka.v1.ListClustersResponse;
import com.google.cloud.managedkafka.v1.ListConsumerGroupsRequest;
import com.google.cloud.managedkafka.v1.ListConsumerGroupsResponse;
import com.google.cloud.managedkafka.v1.ListTopicsRequest;
import com.google.cloud.managedkafka.v1.ListTopicsResponse;
import com.google.cloud.managedkafka.v1.LocationName;
import com.google.cloud.managedkafka.v1.ManagedKafkaSettings;
import com.google.cloud.managedkafka.v1.OperationMetadata;
import com.google.cloud.managedkafka.v1.Topic;
import com.google.cloud.managedkafka.v1.TopicName;
import com.google.cloud.managedkafka.v1.UpdateClusterRequest;
import com.google.cloud.managedkafka.v1.UpdateConsumerGroupRequest;
import com.google.cloud.managedkafka.v1.UpdateTopicRequest;
import com.google.cloud.managedkafka.v1.stub.ManagedKafkaStub;
import com.google.cloud.managedkafka.v1.stub.ManagedKafkaStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ManagedKafkaClient
implements BackgroundResource {
    private final ManagedKafkaSettings settings;
    private final ManagedKafkaStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ManagedKafkaClient create() throws IOException {
        return ManagedKafkaClient.create(ManagedKafkaSettings.newBuilder().build());
    }

    public static final ManagedKafkaClient create(ManagedKafkaSettings settings) throws IOException {
        return new ManagedKafkaClient(settings);
    }

    public static final ManagedKafkaClient create(ManagedKafkaStub stub) {
        return new ManagedKafkaClient(stub);
    }

    protected ManagedKafkaClient(ManagedKafkaSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ManagedKafkaStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ManagedKafkaClient(ManagedKafkaStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ManagedKafkaSettings getSettings() {
        return this.settings;
    }

    public ManagedKafkaStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListClustersPagedResponse listClusters(LocationName parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(String parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(ListClustersRequest request) {
        return (ListClustersPagedResponse)((Object)this.listClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListClustersRequest, ListClustersPagedResponse> listClustersPagedCallable() {
        return this.stub.listClustersPagedCallable();
    }

    public final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.stub.listClustersCallable();
    }

    public final Cluster getCluster(ClusterName name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(String name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(GetClusterRequest request) {
        return (Cluster)this.getClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.stub.getClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(LocationName parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(String parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationCallable() {
        return this.stub.createClusterOperationCallable();
    }

    public final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.stub.createClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> updateClusterAsync(Cluster cluster, FieldMask updateMask) {
        UpdateClusterRequest request = UpdateClusterRequest.newBuilder().setCluster(cluster).setUpdateMask(updateMask).build();
        return this.updateClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> updateClusterAsync(UpdateClusterRequest request) {
        return this.updateClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationCallable() {
        return this.stub.updateClusterOperationCallable();
    }

    public final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.stub.updateClusterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(ClusterName name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(String name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationCallable() {
        return this.stub.deleteClusterOperationCallable();
    }

    public final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.stub.deleteClusterCallable();
    }

    public final ListTopicsPagedResponse listTopics(ClusterName parent) {
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTopics(request);
    }

    public final ListTopicsPagedResponse listTopics(String parent) {
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setParent(parent).build();
        return this.listTopics(request);
    }

    public final ListTopicsPagedResponse listTopics(ListTopicsRequest request) {
        return (ListTopicsPagedResponse)((Object)this.listTopicsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTopicsRequest, ListTopicsPagedResponse> listTopicsPagedCallable() {
        return this.stub.listTopicsPagedCallable();
    }

    public final UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable() {
        return this.stub.listTopicsCallable();
    }

    public final Topic getTopic(TopicName name) {
        GetTopicRequest request = GetTopicRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTopic(request);
    }

    public final Topic getTopic(String name) {
        GetTopicRequest request = GetTopicRequest.newBuilder().setName(name).build();
        return this.getTopic(request);
    }

    public final Topic getTopic(GetTopicRequest request) {
        return (Topic)this.getTopicCallable().call((Object)request);
    }

    public final UnaryCallable<GetTopicRequest, Topic> getTopicCallable() {
        return this.stub.getTopicCallable();
    }

    public final Topic createTopic(ClusterName parent, Topic topic, String topicId) {
        CreateTopicRequest request = CreateTopicRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTopic(topic).setTopicId(topicId).build();
        return this.createTopic(request);
    }

    public final Topic createTopic(String parent, Topic topic, String topicId) {
        CreateTopicRequest request = CreateTopicRequest.newBuilder().setParent(parent).setTopic(topic).setTopicId(topicId).build();
        return this.createTopic(request);
    }

    public final Topic createTopic(CreateTopicRequest request) {
        return (Topic)this.createTopicCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTopicRequest, Topic> createTopicCallable() {
        return this.stub.createTopicCallable();
    }

    public final Topic updateTopic(Topic topic, FieldMask updateMask) {
        UpdateTopicRequest request = UpdateTopicRequest.newBuilder().setTopic(topic).setUpdateMask(updateMask).build();
        return this.updateTopic(request);
    }

    public final Topic updateTopic(UpdateTopicRequest request) {
        return (Topic)this.updateTopicCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable() {
        return this.stub.updateTopicCallable();
    }

    public final void deleteTopic(TopicName name) {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTopic(request);
    }

    public final void deleteTopic(String name) {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setName(name).build();
        this.deleteTopic(request);
    }

    public final void deleteTopic(DeleteTopicRequest request) {
        this.deleteTopicCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable() {
        return this.stub.deleteTopicCallable();
    }

    public final ListConsumerGroupsPagedResponse listConsumerGroups(ClusterName parent) {
        ListConsumerGroupsRequest request = ListConsumerGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConsumerGroups(request);
    }

    public final ListConsumerGroupsPagedResponse listConsumerGroups(String parent) {
        ListConsumerGroupsRequest request = ListConsumerGroupsRequest.newBuilder().setParent(parent).build();
        return this.listConsumerGroups(request);
    }

    public final ListConsumerGroupsPagedResponse listConsumerGroups(ListConsumerGroupsRequest request) {
        return (ListConsumerGroupsPagedResponse)((Object)this.listConsumerGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConsumerGroupsRequest, ListConsumerGroupsPagedResponse> listConsumerGroupsPagedCallable() {
        return this.stub.listConsumerGroupsPagedCallable();
    }

    public final UnaryCallable<ListConsumerGroupsRequest, ListConsumerGroupsResponse> listConsumerGroupsCallable() {
        return this.stub.listConsumerGroupsCallable();
    }

    public final ConsumerGroup getConsumerGroup(ConsumerGroupName name) {
        GetConsumerGroupRequest request = GetConsumerGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConsumerGroup(request);
    }

    public final ConsumerGroup getConsumerGroup(String name) {
        GetConsumerGroupRequest request = GetConsumerGroupRequest.newBuilder().setName(name).build();
        return this.getConsumerGroup(request);
    }

    public final ConsumerGroup getConsumerGroup(GetConsumerGroupRequest request) {
        return (ConsumerGroup)this.getConsumerGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetConsumerGroupRequest, ConsumerGroup> getConsumerGroupCallable() {
        return this.stub.getConsumerGroupCallable();
    }

    public final ConsumerGroup updateConsumerGroup(ConsumerGroup consumerGroup, FieldMask updateMask) {
        UpdateConsumerGroupRequest request = UpdateConsumerGroupRequest.newBuilder().setConsumerGroup(consumerGroup).setUpdateMask(updateMask).build();
        return this.updateConsumerGroup(request);
    }

    public final ConsumerGroup updateConsumerGroup(UpdateConsumerGroupRequest request) {
        return (ConsumerGroup)this.updateConsumerGroupCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateConsumerGroupRequest, ConsumerGroup> updateConsumerGroupCallable() {
        return this.stub.updateConsumerGroupCallable();
    }

    public final void deleteConsumerGroup(ConsumerGroupName name) {
        DeleteConsumerGroupRequest request = DeleteConsumerGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteConsumerGroup(request);
    }

    public final void deleteConsumerGroup(String name) {
        DeleteConsumerGroupRequest request = DeleteConsumerGroupRequest.newBuilder().setName(name).build();
        this.deleteConsumerGroup(request);
    }

    public final void deleteConsumerGroup(DeleteConsumerGroupRequest request) {
        this.deleteConsumerGroupCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteConsumerGroupRequest, Empty> deleteConsumerGroupCallable() {
        return this.stub.deleteConsumerGroupCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConsumerGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConsumerGroupsRequest, ListConsumerGroupsResponse, ConsumerGroup, ListConsumerGroupsPage, ListConsumerGroupsFixedSizeCollection> {
        private ListConsumerGroupsFixedSizeCollection(List<ListConsumerGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConsumerGroupsFixedSizeCollection createEmptyCollection() {
            return new ListConsumerGroupsFixedSizeCollection(null, 0);
        }

        protected ListConsumerGroupsFixedSizeCollection createCollection(List<ListConsumerGroupsPage> pages, int collectionSize) {
            return new ListConsumerGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConsumerGroupsPage
    extends AbstractPage<ListConsumerGroupsRequest, ListConsumerGroupsResponse, ConsumerGroup, ListConsumerGroupsPage> {
        private ListConsumerGroupsPage(PageContext<ListConsumerGroupsRequest, ListConsumerGroupsResponse, ConsumerGroup> context, ListConsumerGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListConsumerGroupsPage createEmptyPage() {
            return new ListConsumerGroupsPage(null, null);
        }

        protected ListConsumerGroupsPage createPage(PageContext<ListConsumerGroupsRequest, ListConsumerGroupsResponse, ConsumerGroup> context, ListConsumerGroupsResponse response) {
            return new ListConsumerGroupsPage(context, response);
        }

        public ApiFuture<ListConsumerGroupsPage> createPageAsync(PageContext<ListConsumerGroupsRequest, ListConsumerGroupsResponse, ConsumerGroup> context, ApiFuture<ListConsumerGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConsumerGroupsPagedResponse
    extends AbstractPagedListResponse<ListConsumerGroupsRequest, ListConsumerGroupsResponse, ConsumerGroup, ListConsumerGroupsPage, ListConsumerGroupsFixedSizeCollection> {
        public static ApiFuture<ListConsumerGroupsPagedResponse> createAsync(PageContext<ListConsumerGroupsRequest, ListConsumerGroupsResponse, ConsumerGroup> context, ApiFuture<ListConsumerGroupsResponse> futureResponse) {
            ApiFuture<ListConsumerGroupsPage> futurePage = ListConsumerGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConsumerGroupsPagedResponse((ListConsumerGroupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConsumerGroupsPagedResponse(ListConsumerGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConsumerGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTopicsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTopicsRequest, ListTopicsResponse, Topic, ListTopicsPage, ListTopicsFixedSizeCollection> {
        private ListTopicsFixedSizeCollection(List<ListTopicsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTopicsFixedSizeCollection createEmptyCollection() {
            return new ListTopicsFixedSizeCollection(null, 0);
        }

        protected ListTopicsFixedSizeCollection createCollection(List<ListTopicsPage> pages, int collectionSize) {
            return new ListTopicsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTopicsPage
    extends AbstractPage<ListTopicsRequest, ListTopicsResponse, Topic, ListTopicsPage> {
        private ListTopicsPage(PageContext<ListTopicsRequest, ListTopicsResponse, Topic> context, ListTopicsResponse response) {
            super(context, (Object)response);
        }

        private static ListTopicsPage createEmptyPage() {
            return new ListTopicsPage(null, null);
        }

        protected ListTopicsPage createPage(PageContext<ListTopicsRequest, ListTopicsResponse, Topic> context, ListTopicsResponse response) {
            return new ListTopicsPage(context, response);
        }

        public ApiFuture<ListTopicsPage> createPageAsync(PageContext<ListTopicsRequest, ListTopicsResponse, Topic> context, ApiFuture<ListTopicsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTopicsPagedResponse
    extends AbstractPagedListResponse<ListTopicsRequest, ListTopicsResponse, Topic, ListTopicsPage, ListTopicsFixedSizeCollection> {
        public static ApiFuture<ListTopicsPagedResponse> createAsync(PageContext<ListTopicsRequest, ListTopicsResponse, Topic> context, ApiFuture<ListTopicsResponse> futureResponse) {
            ApiFuture<ListTopicsPage> futurePage = ListTopicsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTopicsPagedResponse((ListTopicsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTopicsPagedResponse(ListTopicsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTopicsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        private ListClustersFixedSizeCollection(List<ListClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListClustersFixedSizeCollection createEmptyCollection() {
            return new ListClustersFixedSizeCollection(null, 0);
        }

        protected ListClustersFixedSizeCollection createCollection(List<ListClustersPage> pages, int collectionSize) {
            return new ListClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListClustersPage
    extends AbstractPage<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage> {
        private ListClustersPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListClustersPage createEmptyPage() {
            return new ListClustersPage(null, null);
        }

        protected ListClustersPage createPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            return new ListClustersPage(context, response);
        }

        public ApiFuture<ListClustersPage> createPageAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListClustersPagedResponse
    extends AbstractPagedListResponse<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        public static ApiFuture<ListClustersPagedResponse> createAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            ApiFuture<ListClustersPage> futurePage = ListClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListClustersPagedResponse((ListClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListClustersPagedResponse(ListClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

