/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.maintenance.api.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.maintenance.api.v1beta.GetResourceMaintenanceRequest;
import com.google.cloud.maintenance.api.v1beta.ListResourceMaintenancesRequest;
import com.google.cloud.maintenance.api.v1beta.ListResourceMaintenancesResponse;
import com.google.cloud.maintenance.api.v1beta.LocationName;
import com.google.cloud.maintenance.api.v1beta.MaintenanceSettings;
import com.google.cloud.maintenance.api.v1beta.MaintenanceSummary;
import com.google.cloud.maintenance.api.v1beta.ResourceMaintenance;
import com.google.cloud.maintenance.api.v1beta.ResourceMaintenanceName;
import com.google.cloud.maintenance.api.v1beta.SummarizeMaintenancesRequest;
import com.google.cloud.maintenance.api.v1beta.SummarizeMaintenancesResponse;
import com.google.cloud.maintenance.api.v1beta.stub.MaintenanceStub;
import com.google.cloud.maintenance.api.v1beta.stub.MaintenanceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class MaintenanceClient
implements BackgroundResource {
    private final MaintenanceSettings settings;
    private final MaintenanceStub stub;

    public static final MaintenanceClient create() throws IOException {
        return MaintenanceClient.create(MaintenanceSettings.newBuilder().build());
    }

    public static final MaintenanceClient create(MaintenanceSettings settings) throws IOException {
        return new MaintenanceClient(settings);
    }

    public static final MaintenanceClient create(MaintenanceStub stub) {
        return new MaintenanceClient(stub);
    }

    protected MaintenanceClient(MaintenanceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MaintenanceStubSettings)settings.getStubSettings()).createStub();
    }

    protected MaintenanceClient(MaintenanceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MaintenanceSettings getSettings() {
        return this.settings;
    }

    public MaintenanceStub getStub() {
        return this.stub;
    }

    public final SummarizeMaintenancesPagedResponse summarizeMaintenances(LocationName parent) {
        SummarizeMaintenancesRequest request = SummarizeMaintenancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.summarizeMaintenances(request);
    }

    public final SummarizeMaintenancesPagedResponse summarizeMaintenances(String parent) {
        SummarizeMaintenancesRequest request = SummarizeMaintenancesRequest.newBuilder().setParent(parent).build();
        return this.summarizeMaintenances(request);
    }

    public final SummarizeMaintenancesPagedResponse summarizeMaintenances(SummarizeMaintenancesRequest request) {
        return (SummarizeMaintenancesPagedResponse)((Object)this.summarizeMaintenancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SummarizeMaintenancesRequest, SummarizeMaintenancesPagedResponse> summarizeMaintenancesPagedCallable() {
        return this.stub.summarizeMaintenancesPagedCallable();
    }

    public final UnaryCallable<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse> summarizeMaintenancesCallable() {
        return this.stub.summarizeMaintenancesCallable();
    }

    public final ListResourceMaintenancesPagedResponse listResourceMaintenances(LocationName parent) {
        ListResourceMaintenancesRequest request = ListResourceMaintenancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listResourceMaintenances(request);
    }

    public final ListResourceMaintenancesPagedResponse listResourceMaintenances(String parent) {
        ListResourceMaintenancesRequest request = ListResourceMaintenancesRequest.newBuilder().setParent(parent).build();
        return this.listResourceMaintenances(request);
    }

    public final ListResourceMaintenancesPagedResponse listResourceMaintenances(ListResourceMaintenancesRequest request) {
        return (ListResourceMaintenancesPagedResponse)((Object)this.listResourceMaintenancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListResourceMaintenancesRequest, ListResourceMaintenancesPagedResponse> listResourceMaintenancesPagedCallable() {
        return this.stub.listResourceMaintenancesPagedCallable();
    }

    public final UnaryCallable<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse> listResourceMaintenancesCallable() {
        return this.stub.listResourceMaintenancesCallable();
    }

    public final ResourceMaintenance getResourceMaintenance(ResourceMaintenanceName name) {
        GetResourceMaintenanceRequest request = GetResourceMaintenanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getResourceMaintenance(request);
    }

    public final ResourceMaintenance getResourceMaintenance(String name) {
        GetResourceMaintenanceRequest request = GetResourceMaintenanceRequest.newBuilder().setName(name).build();
        return this.getResourceMaintenance(request);
    }

    public final ResourceMaintenance getResourceMaintenance(GetResourceMaintenanceRequest request) {
        return (ResourceMaintenance)this.getResourceMaintenanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetResourceMaintenanceRequest, ResourceMaintenance> getResourceMaintenanceCallable() {
        return this.stub.getResourceMaintenanceCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListResourceMaintenancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, ResourceMaintenance, ListResourceMaintenancesPage, ListResourceMaintenancesFixedSizeCollection> {
        private ListResourceMaintenancesFixedSizeCollection(List<ListResourceMaintenancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListResourceMaintenancesFixedSizeCollection createEmptyCollection() {
            return new ListResourceMaintenancesFixedSizeCollection(null, 0);
        }

        protected ListResourceMaintenancesFixedSizeCollection createCollection(List<ListResourceMaintenancesPage> pages, int collectionSize) {
            return new ListResourceMaintenancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListResourceMaintenancesPage
    extends AbstractPage<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, ResourceMaintenance, ListResourceMaintenancesPage> {
        private ListResourceMaintenancesPage(PageContext<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, ResourceMaintenance> context, ListResourceMaintenancesResponse response) {
            super(context, (Object)response);
        }

        private static ListResourceMaintenancesPage createEmptyPage() {
            return new ListResourceMaintenancesPage(null, null);
        }

        protected ListResourceMaintenancesPage createPage(PageContext<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, ResourceMaintenance> context, ListResourceMaintenancesResponse response) {
            return new ListResourceMaintenancesPage(context, response);
        }

        public ApiFuture<ListResourceMaintenancesPage> createPageAsync(PageContext<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, ResourceMaintenance> context, ApiFuture<ListResourceMaintenancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListResourceMaintenancesPagedResponse
    extends AbstractPagedListResponse<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, ResourceMaintenance, ListResourceMaintenancesPage, ListResourceMaintenancesFixedSizeCollection> {
        public static ApiFuture<ListResourceMaintenancesPagedResponse> createAsync(PageContext<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, ResourceMaintenance> context, ApiFuture<ListResourceMaintenancesResponse> futureResponse) {
            ApiFuture<ListResourceMaintenancesPage> futurePage = ListResourceMaintenancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListResourceMaintenancesPagedResponse((ListResourceMaintenancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListResourceMaintenancesPagedResponse(ListResourceMaintenancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListResourceMaintenancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SummarizeMaintenancesFixedSizeCollection
    extends AbstractFixedSizeCollection<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceSummary, SummarizeMaintenancesPage, SummarizeMaintenancesFixedSizeCollection> {
        private SummarizeMaintenancesFixedSizeCollection(List<SummarizeMaintenancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SummarizeMaintenancesFixedSizeCollection createEmptyCollection() {
            return new SummarizeMaintenancesFixedSizeCollection(null, 0);
        }

        protected SummarizeMaintenancesFixedSizeCollection createCollection(List<SummarizeMaintenancesPage> pages, int collectionSize) {
            return new SummarizeMaintenancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SummarizeMaintenancesPage
    extends AbstractPage<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceSummary, SummarizeMaintenancesPage> {
        private SummarizeMaintenancesPage(PageContext<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceSummary> context, SummarizeMaintenancesResponse response) {
            super(context, (Object)response);
        }

        private static SummarizeMaintenancesPage createEmptyPage() {
            return new SummarizeMaintenancesPage(null, null);
        }

        protected SummarizeMaintenancesPage createPage(PageContext<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceSummary> context, SummarizeMaintenancesResponse response) {
            return new SummarizeMaintenancesPage(context, response);
        }

        public ApiFuture<SummarizeMaintenancesPage> createPageAsync(PageContext<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceSummary> context, ApiFuture<SummarizeMaintenancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SummarizeMaintenancesPagedResponse
    extends AbstractPagedListResponse<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceSummary, SummarizeMaintenancesPage, SummarizeMaintenancesFixedSizeCollection> {
        public static ApiFuture<SummarizeMaintenancesPagedResponse> createAsync(PageContext<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceSummary> context, ApiFuture<SummarizeMaintenancesResponse> futureResponse) {
            ApiFuture<SummarizeMaintenancesPage> futurePage = SummarizeMaintenancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SummarizeMaintenancesPagedResponse((SummarizeMaintenancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SummarizeMaintenancesPagedResponse(SummarizeMaintenancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SummarizeMaintenancesFixedSizeCollection.createEmptyCollection());
        }
    }
}

