/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.livestream.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.video.livestream.v1.Channel;
import com.google.cloud.video.livestream.v1.ChannelName;
import com.google.cloud.video.livestream.v1.ChannelOperationResponse;
import com.google.cloud.video.livestream.v1.CreateChannelRequest;
import com.google.cloud.video.livestream.v1.CreateEventRequest;
import com.google.cloud.video.livestream.v1.CreateInputRequest;
import com.google.cloud.video.livestream.v1.DeleteChannelRequest;
import com.google.cloud.video.livestream.v1.DeleteEventRequest;
import com.google.cloud.video.livestream.v1.DeleteInputRequest;
import com.google.cloud.video.livestream.v1.Event;
import com.google.cloud.video.livestream.v1.EventName;
import com.google.cloud.video.livestream.v1.GetChannelRequest;
import com.google.cloud.video.livestream.v1.GetEventRequest;
import com.google.cloud.video.livestream.v1.GetInputRequest;
import com.google.cloud.video.livestream.v1.Input;
import com.google.cloud.video.livestream.v1.InputName;
import com.google.cloud.video.livestream.v1.ListChannelsRequest;
import com.google.cloud.video.livestream.v1.ListChannelsResponse;
import com.google.cloud.video.livestream.v1.ListEventsRequest;
import com.google.cloud.video.livestream.v1.ListEventsResponse;
import com.google.cloud.video.livestream.v1.ListInputsRequest;
import com.google.cloud.video.livestream.v1.ListInputsResponse;
import com.google.cloud.video.livestream.v1.LivestreamServiceSettings;
import com.google.cloud.video.livestream.v1.LocationName;
import com.google.cloud.video.livestream.v1.OperationMetadata;
import com.google.cloud.video.livestream.v1.StartChannelRequest;
import com.google.cloud.video.livestream.v1.StopChannelRequest;
import com.google.cloud.video.livestream.v1.UpdateChannelRequest;
import com.google.cloud.video.livestream.v1.UpdateInputRequest;
import com.google.cloud.video.livestream.v1.stub.LivestreamServiceStub;
import com.google.cloud.video.livestream.v1.stub.LivestreamServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class LivestreamServiceClient
implements BackgroundResource {
    private final LivestreamServiceSettings settings;
    private final LivestreamServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final LivestreamServiceClient create() throws IOException {
        return LivestreamServiceClient.create(LivestreamServiceSettings.newBuilder().build());
    }

    public static final LivestreamServiceClient create(LivestreamServiceSettings settings) throws IOException {
        return new LivestreamServiceClient(settings);
    }

    public static final LivestreamServiceClient create(LivestreamServiceStub stub) {
        return new LivestreamServiceClient(stub);
    }

    protected LivestreamServiceClient(LivestreamServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LivestreamServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected LivestreamServiceClient(LivestreamServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final LivestreamServiceSettings getSettings() {
        return this.settings;
    }

    public LivestreamServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Channel, OperationMetadata> createChannelAsync(LocationName parent, Channel channel, String channelId) {
        CreateChannelRequest request = CreateChannelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setChannel(channel).setChannelId(channelId).build();
        return this.createChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> createChannelAsync(String parent, Channel channel, String channelId) {
        CreateChannelRequest request = CreateChannelRequest.newBuilder().setParent(parent).setChannel(channel).setChannelId(channelId).build();
        return this.createChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> createChannelAsync(CreateChannelRequest request) {
        return this.createChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationCallable() {
        return this.stub.createChannelOperationCallable();
    }

    public final UnaryCallable<CreateChannelRequest, Operation> createChannelCallable() {
        return this.stub.createChannelCallable();
    }

    public final ListChannelsPagedResponse listChannels(LocationName parent) {
        ListChannelsRequest request = ListChannelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listChannels(request);
    }

    public final ListChannelsPagedResponse listChannels(String parent) {
        ListChannelsRequest request = ListChannelsRequest.newBuilder().setParent(parent).build();
        return this.listChannels(request);
    }

    public final ListChannelsPagedResponse listChannels(ListChannelsRequest request) {
        return (ListChannelsPagedResponse)((Object)this.listChannelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListChannelsRequest, ListChannelsPagedResponse> listChannelsPagedCallable() {
        return this.stub.listChannelsPagedCallable();
    }

    public final UnaryCallable<ListChannelsRequest, ListChannelsResponse> listChannelsCallable() {
        return this.stub.listChannelsCallable();
    }

    public final Channel getChannel(ChannelName name) {
        GetChannelRequest request = GetChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getChannel(request);
    }

    public final Channel getChannel(String name) {
        GetChannelRequest request = GetChannelRequest.newBuilder().setName(name).build();
        return this.getChannel(request);
    }

    public final Channel getChannel(GetChannelRequest request) {
        return (Channel)this.getChannelCallable().call((Object)request);
    }

    public final UnaryCallable<GetChannelRequest, Channel> getChannelCallable() {
        return this.stub.getChannelCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteChannelAsync(ChannelName name) {
        DeleteChannelRequest request = DeleteChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteChannelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteChannelAsync(String name) {
        DeleteChannelRequest request = DeleteChannelRequest.newBuilder().setName(name).build();
        return this.deleteChannelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteChannelAsync(DeleteChannelRequest request) {
        return this.deleteChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteChannelRequest, Empty, OperationMetadata> deleteChannelOperationCallable() {
        return this.stub.deleteChannelOperationCallable();
    }

    public final UnaryCallable<DeleteChannelRequest, Operation> deleteChannelCallable() {
        return this.stub.deleteChannelCallable();
    }

    public final OperationFuture<Channel, OperationMetadata> updateChannelAsync(Channel channel, FieldMask updateMask) {
        UpdateChannelRequest request = UpdateChannelRequest.newBuilder().setChannel(channel).setUpdateMask(updateMask).build();
        return this.updateChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> updateChannelAsync(UpdateChannelRequest request) {
        return this.updateChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationCallable() {
        return this.stub.updateChannelOperationCallable();
    }

    public final UnaryCallable<UpdateChannelRequest, Operation> updateChannelCallable() {
        return this.stub.updateChannelCallable();
    }

    public final OperationFuture<ChannelOperationResponse, OperationMetadata> startChannelAsync(ChannelName name) {
        StartChannelRequest request = StartChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.startChannelAsync(request);
    }

    public final OperationFuture<ChannelOperationResponse, OperationMetadata> startChannelAsync(String name) {
        StartChannelRequest request = StartChannelRequest.newBuilder().setName(name).build();
        return this.startChannelAsync(request);
    }

    public final OperationFuture<ChannelOperationResponse, OperationMetadata> startChannelAsync(StartChannelRequest request) {
        return this.startChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartChannelRequest, ChannelOperationResponse, OperationMetadata> startChannelOperationCallable() {
        return this.stub.startChannelOperationCallable();
    }

    public final UnaryCallable<StartChannelRequest, Operation> startChannelCallable() {
        return this.stub.startChannelCallable();
    }

    public final OperationFuture<ChannelOperationResponse, OperationMetadata> stopChannelAsync(ChannelName name) {
        StopChannelRequest request = StopChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.stopChannelAsync(request);
    }

    public final OperationFuture<ChannelOperationResponse, OperationMetadata> stopChannelAsync(String name) {
        StopChannelRequest request = StopChannelRequest.newBuilder().setName(name).build();
        return this.stopChannelAsync(request);
    }

    public final OperationFuture<ChannelOperationResponse, OperationMetadata> stopChannelAsync(StopChannelRequest request) {
        return this.stopChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopChannelRequest, ChannelOperationResponse, OperationMetadata> stopChannelOperationCallable() {
        return this.stub.stopChannelOperationCallable();
    }

    public final UnaryCallable<StopChannelRequest, Operation> stopChannelCallable() {
        return this.stub.stopChannelCallable();
    }

    public final OperationFuture<Input, OperationMetadata> createInputAsync(LocationName parent, Input input, String inputId) {
        CreateInputRequest request = CreateInputRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInput(input).setInputId(inputId).build();
        return this.createInputAsync(request);
    }

    public final OperationFuture<Input, OperationMetadata> createInputAsync(String parent, Input input, String inputId) {
        CreateInputRequest request = CreateInputRequest.newBuilder().setParent(parent).setInput(input).setInputId(inputId).build();
        return this.createInputAsync(request);
    }

    public final OperationFuture<Input, OperationMetadata> createInputAsync(CreateInputRequest request) {
        return this.createInputOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInputRequest, Input, OperationMetadata> createInputOperationCallable() {
        return this.stub.createInputOperationCallable();
    }

    public final UnaryCallable<CreateInputRequest, Operation> createInputCallable() {
        return this.stub.createInputCallable();
    }

    public final ListInputsPagedResponse listInputs(LocationName parent) {
        ListInputsRequest request = ListInputsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInputs(request);
    }

    public final ListInputsPagedResponse listInputs(String parent) {
        ListInputsRequest request = ListInputsRequest.newBuilder().setParent(parent).build();
        return this.listInputs(request);
    }

    public final ListInputsPagedResponse listInputs(ListInputsRequest request) {
        return (ListInputsPagedResponse)((Object)this.listInputsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInputsRequest, ListInputsPagedResponse> listInputsPagedCallable() {
        return this.stub.listInputsPagedCallable();
    }

    public final UnaryCallable<ListInputsRequest, ListInputsResponse> listInputsCallable() {
        return this.stub.listInputsCallable();
    }

    public final Input getInput(InputName name) {
        GetInputRequest request = GetInputRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInput(request);
    }

    public final Input getInput(String name) {
        GetInputRequest request = GetInputRequest.newBuilder().setName(name).build();
        return this.getInput(request);
    }

    public final Input getInput(GetInputRequest request) {
        return (Input)this.getInputCallable().call((Object)request);
    }

    public final UnaryCallable<GetInputRequest, Input> getInputCallable() {
        return this.stub.getInputCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInputAsync(InputName name) {
        DeleteInputRequest request = DeleteInputRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteInputAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInputAsync(String name) {
        DeleteInputRequest request = DeleteInputRequest.newBuilder().setName(name).build();
        return this.deleteInputAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInputAsync(DeleteInputRequest request) {
        return this.deleteInputOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInputRequest, Empty, OperationMetadata> deleteInputOperationCallable() {
        return this.stub.deleteInputOperationCallable();
    }

    public final UnaryCallable<DeleteInputRequest, Operation> deleteInputCallable() {
        return this.stub.deleteInputCallable();
    }

    public final OperationFuture<Input, OperationMetadata> updateInputAsync(Input input, FieldMask updateMask) {
        UpdateInputRequest request = UpdateInputRequest.newBuilder().setInput(input).setUpdateMask(updateMask).build();
        return this.updateInputAsync(request);
    }

    public final OperationFuture<Input, OperationMetadata> updateInputAsync(UpdateInputRequest request) {
        return this.updateInputOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInputRequest, Input, OperationMetadata> updateInputOperationCallable() {
        return this.stub.updateInputOperationCallable();
    }

    public final UnaryCallable<UpdateInputRequest, Operation> updateInputCallable() {
        return this.stub.updateInputCallable();
    }

    public final Event createEvent(ChannelName parent, Event event, String eventId) {
        CreateEventRequest request = CreateEventRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEvent(event).setEventId(eventId).build();
        return this.createEvent(request);
    }

    public final Event createEvent(String parent, Event event, String eventId) {
        CreateEventRequest request = CreateEventRequest.newBuilder().setParent(parent).setEvent(event).setEventId(eventId).build();
        return this.createEvent(request);
    }

    public final Event createEvent(CreateEventRequest request) {
        return (Event)this.createEventCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEventRequest, Event> createEventCallable() {
        return this.stub.createEventCallable();
    }

    public final ListEventsPagedResponse listEvents(ChannelName parent) {
        ListEventsRequest request = ListEventsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEvents(request);
    }

    public final ListEventsPagedResponse listEvents(String parent) {
        ListEventsRequest request = ListEventsRequest.newBuilder().setParent(parent).build();
        return this.listEvents(request);
    }

    public final ListEventsPagedResponse listEvents(ListEventsRequest request) {
        return (ListEventsPagedResponse)((Object)this.listEventsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEventsRequest, ListEventsPagedResponse> listEventsPagedCallable() {
        return this.stub.listEventsPagedCallable();
    }

    public final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable() {
        return this.stub.listEventsCallable();
    }

    public final Event getEvent(EventName name) {
        GetEventRequest request = GetEventRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEvent(request);
    }

    public final Event getEvent(String name) {
        GetEventRequest request = GetEventRequest.newBuilder().setName(name).build();
        return this.getEvent(request);
    }

    public final Event getEvent(GetEventRequest request) {
        return (Event)this.getEventCallable().call((Object)request);
    }

    public final UnaryCallable<GetEventRequest, Event> getEventCallable() {
        return this.stub.getEventCallable();
    }

    public final void deleteEvent(EventName name) {
        DeleteEventRequest request = DeleteEventRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteEvent(request);
    }

    public final void deleteEvent(String name) {
        DeleteEventRequest request = DeleteEventRequest.newBuilder().setName(name).build();
        this.deleteEvent(request);
    }

    public final void deleteEvent(DeleteEventRequest request) {
        this.deleteEventCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEventRequest, Empty> deleteEventCallable() {
        return this.stub.deleteEventCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEventsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEventsRequest, ListEventsResponse, Event, ListEventsPage, ListEventsFixedSizeCollection> {
        private ListEventsFixedSizeCollection(List<ListEventsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEventsFixedSizeCollection createEmptyCollection() {
            return new ListEventsFixedSizeCollection(null, 0);
        }

        protected ListEventsFixedSizeCollection createCollection(List<ListEventsPage> pages, int collectionSize) {
            return new ListEventsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEventsPage
    extends AbstractPage<ListEventsRequest, ListEventsResponse, Event, ListEventsPage> {
        private ListEventsPage(PageContext<ListEventsRequest, ListEventsResponse, Event> context, ListEventsResponse response) {
            super(context, (Object)response);
        }

        private static ListEventsPage createEmptyPage() {
            return new ListEventsPage(null, null);
        }

        protected ListEventsPage createPage(PageContext<ListEventsRequest, ListEventsResponse, Event> context, ListEventsResponse response) {
            return new ListEventsPage(context, response);
        }

        public ApiFuture<ListEventsPage> createPageAsync(PageContext<ListEventsRequest, ListEventsResponse, Event> context, ApiFuture<ListEventsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEventsPagedResponse
    extends AbstractPagedListResponse<ListEventsRequest, ListEventsResponse, Event, ListEventsPage, ListEventsFixedSizeCollection> {
        public static ApiFuture<ListEventsPagedResponse> createAsync(PageContext<ListEventsRequest, ListEventsResponse, Event> context, ApiFuture<ListEventsResponse> futureResponse) {
            ApiFuture<ListEventsPage> futurePage = ListEventsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEventsPagedResponse((ListEventsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEventsPagedResponse(ListEventsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEventsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInputsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInputsRequest, ListInputsResponse, Input, ListInputsPage, ListInputsFixedSizeCollection> {
        private ListInputsFixedSizeCollection(List<ListInputsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInputsFixedSizeCollection createEmptyCollection() {
            return new ListInputsFixedSizeCollection(null, 0);
        }

        protected ListInputsFixedSizeCollection createCollection(List<ListInputsPage> pages, int collectionSize) {
            return new ListInputsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInputsPage
    extends AbstractPage<ListInputsRequest, ListInputsResponse, Input, ListInputsPage> {
        private ListInputsPage(PageContext<ListInputsRequest, ListInputsResponse, Input> context, ListInputsResponse response) {
            super(context, (Object)response);
        }

        private static ListInputsPage createEmptyPage() {
            return new ListInputsPage(null, null);
        }

        protected ListInputsPage createPage(PageContext<ListInputsRequest, ListInputsResponse, Input> context, ListInputsResponse response) {
            return new ListInputsPage(context, response);
        }

        public ApiFuture<ListInputsPage> createPageAsync(PageContext<ListInputsRequest, ListInputsResponse, Input> context, ApiFuture<ListInputsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInputsPagedResponse
    extends AbstractPagedListResponse<ListInputsRequest, ListInputsResponse, Input, ListInputsPage, ListInputsFixedSizeCollection> {
        public static ApiFuture<ListInputsPagedResponse> createAsync(PageContext<ListInputsRequest, ListInputsResponse, Input> context, ApiFuture<ListInputsResponse> futureResponse) {
            ApiFuture<ListInputsPage> futurePage = ListInputsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInputsPagedResponse((ListInputsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInputsPagedResponse(ListInputsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInputsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListChannelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListChannelsRequest, ListChannelsResponse, Channel, ListChannelsPage, ListChannelsFixedSizeCollection> {
        private ListChannelsFixedSizeCollection(List<ListChannelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListChannelsFixedSizeCollection createEmptyCollection() {
            return new ListChannelsFixedSizeCollection(null, 0);
        }

        protected ListChannelsFixedSizeCollection createCollection(List<ListChannelsPage> pages, int collectionSize) {
            return new ListChannelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListChannelsPage
    extends AbstractPage<ListChannelsRequest, ListChannelsResponse, Channel, ListChannelsPage> {
        private ListChannelsPage(PageContext<ListChannelsRequest, ListChannelsResponse, Channel> context, ListChannelsResponse response) {
            super(context, (Object)response);
        }

        private static ListChannelsPage createEmptyPage() {
            return new ListChannelsPage(null, null);
        }

        protected ListChannelsPage createPage(PageContext<ListChannelsRequest, ListChannelsResponse, Channel> context, ListChannelsResponse response) {
            return new ListChannelsPage(context, response);
        }

        public ApiFuture<ListChannelsPage> createPageAsync(PageContext<ListChannelsRequest, ListChannelsResponse, Channel> context, ApiFuture<ListChannelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListChannelsPagedResponse
    extends AbstractPagedListResponse<ListChannelsRequest, ListChannelsResponse, Channel, ListChannelsPage, ListChannelsFixedSizeCollection> {
        public static ApiFuture<ListChannelsPagedResponse> createAsync(PageContext<ListChannelsRequest, ListChannelsResponse, Channel> context, ApiFuture<ListChannelsResponse> futureResponse) {
            ApiFuture<ListChannelsPage> futurePage = ListChannelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListChannelsPagedResponse((ListChannelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListChannelsPagedResponse(ListChannelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListChannelsFixedSizeCollection.createEmptyCollection());
        }
    }
}

