/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.licensemanager.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.licensemanager.v1.AggregateUsageRequest;
import com.google.cloud.licensemanager.v1.AggregateUsageResponse;
import com.google.cloud.licensemanager.v1.Configuration;
import com.google.cloud.licensemanager.v1.CreateConfigurationRequest;
import com.google.cloud.licensemanager.v1.DeactivateConfigurationRequest;
import com.google.cloud.licensemanager.v1.DeleteConfigurationRequest;
import com.google.cloud.licensemanager.v1.GetConfigurationRequest;
import com.google.cloud.licensemanager.v1.GetInstanceRequest;
import com.google.cloud.licensemanager.v1.GetProductRequest;
import com.google.cloud.licensemanager.v1.Instance;
import com.google.cloud.licensemanager.v1.LicenseManagerClient;
import com.google.cloud.licensemanager.v1.ListConfigurationsRequest;
import com.google.cloud.licensemanager.v1.ListConfigurationsResponse;
import com.google.cloud.licensemanager.v1.ListInstancesRequest;
import com.google.cloud.licensemanager.v1.ListInstancesResponse;
import com.google.cloud.licensemanager.v1.ListProductsRequest;
import com.google.cloud.licensemanager.v1.ListProductsResponse;
import com.google.cloud.licensemanager.v1.OperationMetadata;
import com.google.cloud.licensemanager.v1.Product;
import com.google.cloud.licensemanager.v1.QueryConfigurationLicenseUsageRequest;
import com.google.cloud.licensemanager.v1.QueryConfigurationLicenseUsageResponse;
import com.google.cloud.licensemanager.v1.ReactivateConfigurationRequest;
import com.google.cloud.licensemanager.v1.UpdateConfigurationRequest;
import com.google.cloud.licensemanager.v1.Usage;
import com.google.cloud.licensemanager.v1.stub.GrpcLicenseManagerStub;
import com.google.cloud.licensemanager.v1.stub.HttpJsonLicenseManagerStub;
import com.google.cloud.licensemanager.v1.stub.LicenseManagerStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class LicenseManagerStubSettings
extends StubSettings<LicenseManagerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListConfigurationsRequest, ListConfigurationsResponse, LicenseManagerClient.ListConfigurationsPagedResponse> listConfigurationsSettings;
    private final UnaryCallSettings<GetConfigurationRequest, Configuration> getConfigurationSettings;
    private final UnaryCallSettings<CreateConfigurationRequest, Operation> createConfigurationSettings;
    private final OperationCallSettings<CreateConfigurationRequest, Configuration, OperationMetadata> createConfigurationOperationSettings;
    private final UnaryCallSettings<UpdateConfigurationRequest, Operation> updateConfigurationSettings;
    private final OperationCallSettings<UpdateConfigurationRequest, Configuration, OperationMetadata> updateConfigurationOperationSettings;
    private final UnaryCallSettings<DeleteConfigurationRequest, Operation> deleteConfigurationSettings;
    private final OperationCallSettings<DeleteConfigurationRequest, Empty, OperationMetadata> deleteConfigurationOperationSettings;
    private final PagedCallSettings<ListInstancesRequest, ListInstancesResponse, LicenseManagerClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<DeactivateConfigurationRequest, Operation> deactivateConfigurationSettings;
    private final OperationCallSettings<DeactivateConfigurationRequest, Configuration, OperationMetadata> deactivateConfigurationOperationSettings;
    private final UnaryCallSettings<ReactivateConfigurationRequest, Operation> reactivateConfigurationSettings;
    private final OperationCallSettings<ReactivateConfigurationRequest, Configuration, OperationMetadata> reactivateConfigurationOperationSettings;
    private final UnaryCallSettings<QueryConfigurationLicenseUsageRequest, QueryConfigurationLicenseUsageResponse> queryConfigurationLicenseUsageSettings;
    private final PagedCallSettings<AggregateUsageRequest, AggregateUsageResponse, LicenseManagerClient.AggregateUsagePagedResponse> aggregateUsageSettings;
    private final PagedCallSettings<ListProductsRequest, ListProductsResponse, LicenseManagerClient.ListProductsPagedResponse> listProductsSettings;
    private final UnaryCallSettings<GetProductRequest, Product> getProductSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, LicenseManagerClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListConfigurationsRequest, ListConfigurationsResponse, Configuration> LIST_CONFIGURATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListConfigurationsRequest, ListConfigurationsResponse, Configuration>(){

        public String emptyToken() {
            return "";
        }

        public ListConfigurationsRequest injectToken(ListConfigurationsRequest payload, String token) {
            return ListConfigurationsRequest.newBuilder((ListConfigurationsRequest)payload).setPageToken(token).build();
        }

        public ListConfigurationsRequest injectPageSize(ListConfigurationsRequest payload, int pageSize) {
            return ListConfigurationsRequest.newBuilder((ListConfigurationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConfigurationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConfigurationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Configuration> extractResources(ListConfigurationsResponse payload) {
            return payload.getConfigurationsList();
        }
    };
    private static final PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(ListInstancesResponse payload) {
            return payload.getInstancesList();
        }
    };
    private static final PagedListDescriptor<AggregateUsageRequest, AggregateUsageResponse, Usage> AGGREGATE_USAGE_PAGE_STR_DESC = new PagedListDescriptor<AggregateUsageRequest, AggregateUsageResponse, Usage>(){

        public String emptyToken() {
            return "";
        }

        public AggregateUsageRequest injectToken(AggregateUsageRequest payload, String token) {
            return AggregateUsageRequest.newBuilder((AggregateUsageRequest)payload).setPageToken(token).build();
        }

        public AggregateUsageRequest injectPageSize(AggregateUsageRequest payload, int pageSize) {
            return AggregateUsageRequest.newBuilder((AggregateUsageRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(AggregateUsageRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(AggregateUsageResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Usage> extractResources(AggregateUsageResponse payload) {
            return payload.getUsagesList();
        }
    };
    private static final PagedListDescriptor<ListProductsRequest, ListProductsResponse, Product> LIST_PRODUCTS_PAGE_STR_DESC = new PagedListDescriptor<ListProductsRequest, ListProductsResponse, Product>(){

        public String emptyToken() {
            return "";
        }

        public ListProductsRequest injectToken(ListProductsRequest payload, String token) {
            return ListProductsRequest.newBuilder((ListProductsRequest)payload).setPageToken(token).build();
        }

        public ListProductsRequest injectPageSize(ListProductsRequest payload, int pageSize) {
            return ListProductsRequest.newBuilder((ListProductsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProductsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProductsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Product> extractResources(ListProductsResponse payload) {
            return payload.getProductsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListConfigurationsRequest, ListConfigurationsResponse, LicenseManagerClient.ListConfigurationsPagedResponse> LIST_CONFIGURATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListConfigurationsRequest, ListConfigurationsResponse, LicenseManagerClient.ListConfigurationsPagedResponse>(){

        public ApiFuture<LicenseManagerClient.ListConfigurationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConfigurationsRequest, ListConfigurationsResponse> callable, ListConfigurationsRequest request, ApiCallContext context, ApiFuture<ListConfigurationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONFIGURATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LicenseManagerClient.ListConfigurationsPagedResponse.createAsync((PageContext<ListConfigurationsRequest, ListConfigurationsResponse, Configuration>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, LicenseManagerClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, LicenseManagerClient.ListInstancesPagedResponse>(){

        public ApiFuture<LicenseManagerClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, ListInstancesResponse> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<ListInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LicenseManagerClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesRequest, ListInstancesResponse, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<AggregateUsageRequest, AggregateUsageResponse, LicenseManagerClient.AggregateUsagePagedResponse> AGGREGATE_USAGE_PAGE_STR_FACT = new PagedListResponseFactory<AggregateUsageRequest, AggregateUsageResponse, LicenseManagerClient.AggregateUsagePagedResponse>(){

        public ApiFuture<LicenseManagerClient.AggregateUsagePagedResponse> getFuturePagedResponse(UnaryCallable<AggregateUsageRequest, AggregateUsageResponse> callable, AggregateUsageRequest request, ApiCallContext context, ApiFuture<AggregateUsageResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATE_USAGE_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LicenseManagerClient.AggregateUsagePagedResponse.createAsync((PageContext<AggregateUsageRequest, AggregateUsageResponse, Usage>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListProductsRequest, ListProductsResponse, LicenseManagerClient.ListProductsPagedResponse> LIST_PRODUCTS_PAGE_STR_FACT = new PagedListResponseFactory<ListProductsRequest, ListProductsResponse, LicenseManagerClient.ListProductsPagedResponse>(){

        public ApiFuture<LicenseManagerClient.ListProductsPagedResponse> getFuturePagedResponse(UnaryCallable<ListProductsRequest, ListProductsResponse> callable, ListProductsRequest request, ApiCallContext context, ApiFuture<ListProductsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PRODUCTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LicenseManagerClient.ListProductsPagedResponse.createAsync((PageContext<ListProductsRequest, ListProductsResponse, Product>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, LicenseManagerClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, LicenseManagerClient.ListLocationsPagedResponse>(){

        public ApiFuture<LicenseManagerClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LicenseManagerClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListConfigurationsRequest, ListConfigurationsResponse, LicenseManagerClient.ListConfigurationsPagedResponse> listConfigurationsSettings() {
        return this.listConfigurationsSettings;
    }

    public UnaryCallSettings<GetConfigurationRequest, Configuration> getConfigurationSettings() {
        return this.getConfigurationSettings;
    }

    public UnaryCallSettings<CreateConfigurationRequest, Operation> createConfigurationSettings() {
        return this.createConfigurationSettings;
    }

    public OperationCallSettings<CreateConfigurationRequest, Configuration, OperationMetadata> createConfigurationOperationSettings() {
        return this.createConfigurationOperationSettings;
    }

    public UnaryCallSettings<UpdateConfigurationRequest, Operation> updateConfigurationSettings() {
        return this.updateConfigurationSettings;
    }

    public OperationCallSettings<UpdateConfigurationRequest, Configuration, OperationMetadata> updateConfigurationOperationSettings() {
        return this.updateConfigurationOperationSettings;
    }

    public UnaryCallSettings<DeleteConfigurationRequest, Operation> deleteConfigurationSettings() {
        return this.deleteConfigurationSettings;
    }

    public OperationCallSettings<DeleteConfigurationRequest, Empty, OperationMetadata> deleteConfigurationOperationSettings() {
        return this.deleteConfigurationOperationSettings;
    }

    public PagedCallSettings<ListInstancesRequest, ListInstancesResponse, LicenseManagerClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<DeactivateConfigurationRequest, Operation> deactivateConfigurationSettings() {
        return this.deactivateConfigurationSettings;
    }

    public OperationCallSettings<DeactivateConfigurationRequest, Configuration, OperationMetadata> deactivateConfigurationOperationSettings() {
        return this.deactivateConfigurationOperationSettings;
    }

    public UnaryCallSettings<ReactivateConfigurationRequest, Operation> reactivateConfigurationSettings() {
        return this.reactivateConfigurationSettings;
    }

    public OperationCallSettings<ReactivateConfigurationRequest, Configuration, OperationMetadata> reactivateConfigurationOperationSettings() {
        return this.reactivateConfigurationOperationSettings;
    }

    public UnaryCallSettings<QueryConfigurationLicenseUsageRequest, QueryConfigurationLicenseUsageResponse> queryConfigurationLicenseUsageSettings() {
        return this.queryConfigurationLicenseUsageSettings;
    }

    public PagedCallSettings<AggregateUsageRequest, AggregateUsageResponse, LicenseManagerClient.AggregateUsagePagedResponse> aggregateUsageSettings() {
        return this.aggregateUsageSettings;
    }

    public PagedCallSettings<ListProductsRequest, ListProductsResponse, LicenseManagerClient.ListProductsPagedResponse> listProductsSettings() {
        return this.listProductsSettings;
    }

    public UnaryCallSettings<GetProductRequest, Product> getProductSettings() {
        return this.getProductSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, LicenseManagerClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public LicenseManagerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcLicenseManagerStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonLicenseManagerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "licensemanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "licensemanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "licensemanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return LicenseManagerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LicenseManagerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LicenseManagerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return LicenseManagerStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected LicenseManagerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listConfigurationsSettings = settingsBuilder.listConfigurationsSettings().build();
        this.getConfigurationSettings = settingsBuilder.getConfigurationSettings().build();
        this.createConfigurationSettings = settingsBuilder.createConfigurationSettings().build();
        this.createConfigurationOperationSettings = settingsBuilder.createConfigurationOperationSettings().build();
        this.updateConfigurationSettings = settingsBuilder.updateConfigurationSettings().build();
        this.updateConfigurationOperationSettings = settingsBuilder.updateConfigurationOperationSettings().build();
        this.deleteConfigurationSettings = settingsBuilder.deleteConfigurationSettings().build();
        this.deleteConfigurationOperationSettings = settingsBuilder.deleteConfigurationOperationSettings().build();
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.deactivateConfigurationSettings = settingsBuilder.deactivateConfigurationSettings().build();
        this.deactivateConfigurationOperationSettings = settingsBuilder.deactivateConfigurationOperationSettings().build();
        this.reactivateConfigurationSettings = settingsBuilder.reactivateConfigurationSettings().build();
        this.reactivateConfigurationOperationSettings = settingsBuilder.reactivateConfigurationOperationSettings().build();
        this.queryConfigurationLicenseUsageSettings = settingsBuilder.queryConfigurationLicenseUsageSettings().build();
        this.aggregateUsageSettings = settingsBuilder.aggregateUsageSettings().build();
        this.listProductsSettings = settingsBuilder.listProductsSettings().build();
        this.getProductSettings = settingsBuilder.getProductSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<LicenseManagerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListConfigurationsRequest, ListConfigurationsResponse, LicenseManagerClient.ListConfigurationsPagedResponse> listConfigurationsSettings;
        private final UnaryCallSettings.Builder<GetConfigurationRequest, Configuration> getConfigurationSettings;
        private final UnaryCallSettings.Builder<CreateConfigurationRequest, Operation> createConfigurationSettings;
        private final OperationCallSettings.Builder<CreateConfigurationRequest, Configuration, OperationMetadata> createConfigurationOperationSettings;
        private final UnaryCallSettings.Builder<UpdateConfigurationRequest, Operation> updateConfigurationSettings;
        private final OperationCallSettings.Builder<UpdateConfigurationRequest, Configuration, OperationMetadata> updateConfigurationOperationSettings;
        private final UnaryCallSettings.Builder<DeleteConfigurationRequest, Operation> deleteConfigurationSettings;
        private final OperationCallSettings.Builder<DeleteConfigurationRequest, Empty, OperationMetadata> deleteConfigurationOperationSettings;
        private final PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, LicenseManagerClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<DeactivateConfigurationRequest, Operation> deactivateConfigurationSettings;
        private final OperationCallSettings.Builder<DeactivateConfigurationRequest, Configuration, OperationMetadata> deactivateConfigurationOperationSettings;
        private final UnaryCallSettings.Builder<ReactivateConfigurationRequest, Operation> reactivateConfigurationSettings;
        private final OperationCallSettings.Builder<ReactivateConfigurationRequest, Configuration, OperationMetadata> reactivateConfigurationOperationSettings;
        private final UnaryCallSettings.Builder<QueryConfigurationLicenseUsageRequest, QueryConfigurationLicenseUsageResponse> queryConfigurationLicenseUsageSettings;
        private final PagedCallSettings.Builder<AggregateUsageRequest, AggregateUsageResponse, LicenseManagerClient.AggregateUsagePagedResponse> aggregateUsageSettings;
        private final PagedCallSettings.Builder<ListProductsRequest, ListProductsResponse, LicenseManagerClient.ListProductsPagedResponse> listProductsSettings;
        private final UnaryCallSettings.Builder<GetProductRequest, Product> getProductSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, LicenseManagerClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listConfigurationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONFIGURATIONS_PAGE_STR_FACT);
            this.getConfigurationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConfigurationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConfigurationOperationSettings = OperationCallSettings.newBuilder();
            this.updateConfigurationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConfigurationOperationSettings = OperationCallSettings.newBuilder();
            this.deleteConfigurationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConfigurationOperationSettings = OperationCallSettings.newBuilder();
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deactivateConfigurationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deactivateConfigurationOperationSettings = OperationCallSettings.newBuilder();
            this.reactivateConfigurationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reactivateConfigurationOperationSettings = OperationCallSettings.newBuilder();
            this.queryConfigurationLicenseUsageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.aggregateUsageSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATE_USAGE_PAGE_STR_FACT);
            this.listProductsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PRODUCTS_PAGE_STR_FACT);
            this.getProductSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConfigurationsSettings, this.getConfigurationSettings, this.createConfigurationSettings, this.updateConfigurationSettings, this.deleteConfigurationSettings, this.listInstancesSettings, this.getInstanceSettings, this.deactivateConfigurationSettings, this.reactivateConfigurationSettings, this.queryConfigurationLicenseUsageSettings, this.aggregateUsageSettings, this.listProductsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getProductSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(LicenseManagerStubSettings settings) {
            super((StubSettings)settings);
            this.listConfigurationsSettings = settings.listConfigurationsSettings.toBuilder();
            this.getConfigurationSettings = settings.getConfigurationSettings.toBuilder();
            this.createConfigurationSettings = settings.createConfigurationSettings.toBuilder();
            this.createConfigurationOperationSettings = settings.createConfigurationOperationSettings.toBuilder();
            this.updateConfigurationSettings = settings.updateConfigurationSettings.toBuilder();
            this.updateConfigurationOperationSettings = settings.updateConfigurationOperationSettings.toBuilder();
            this.deleteConfigurationSettings = settings.deleteConfigurationSettings.toBuilder();
            this.deleteConfigurationOperationSettings = settings.deleteConfigurationOperationSettings.toBuilder();
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.deactivateConfigurationSettings = settings.deactivateConfigurationSettings.toBuilder();
            this.deactivateConfigurationOperationSettings = settings.deactivateConfigurationOperationSettings.toBuilder();
            this.reactivateConfigurationSettings = settings.reactivateConfigurationSettings.toBuilder();
            this.reactivateConfigurationOperationSettings = settings.reactivateConfigurationOperationSettings.toBuilder();
            this.queryConfigurationLicenseUsageSettings = settings.queryConfigurationLicenseUsageSettings.toBuilder();
            this.aggregateUsageSettings = settings.aggregateUsageSettings.toBuilder();
            this.listProductsSettings = settings.listProductsSettings.toBuilder();
            this.getProductSettings = settings.getProductSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConfigurationsSettings, this.getConfigurationSettings, this.createConfigurationSettings, this.updateConfigurationSettings, this.deleteConfigurationSettings, this.listInstancesSettings, this.getInstanceSettings, this.deactivateConfigurationSettings, this.reactivateConfigurationSettings, this.queryConfigurationLicenseUsageSettings, this.aggregateUsageSettings, this.listProductsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getProductSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(LicenseManagerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)LicenseManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LicenseManagerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(LicenseManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)LicenseManagerStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)LicenseManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LicenseManagerStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(LicenseManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listConfigurationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getConfigurationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createConfigurationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateConfigurationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteConfigurationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deactivateConfigurationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.reactivateConfigurationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.queryConfigurationLicenseUsageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.aggregateUsageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listProductsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getProductSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createConfigurationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Configuration.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateConfigurationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Configuration.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteConfigurationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deactivateConfigurationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Configuration.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.reactivateConfigurationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Configuration.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListConfigurationsRequest, ListConfigurationsResponse, LicenseManagerClient.ListConfigurationsPagedResponse> listConfigurationsSettings() {
            return this.listConfigurationsSettings;
        }

        public UnaryCallSettings.Builder<GetConfigurationRequest, Configuration> getConfigurationSettings() {
            return this.getConfigurationSettings;
        }

        public UnaryCallSettings.Builder<CreateConfigurationRequest, Operation> createConfigurationSettings() {
            return this.createConfigurationSettings;
        }

        public OperationCallSettings.Builder<CreateConfigurationRequest, Configuration, OperationMetadata> createConfigurationOperationSettings() {
            return this.createConfigurationOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateConfigurationRequest, Operation> updateConfigurationSettings() {
            return this.updateConfigurationSettings;
        }

        public OperationCallSettings.Builder<UpdateConfigurationRequest, Configuration, OperationMetadata> updateConfigurationOperationSettings() {
            return this.updateConfigurationOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteConfigurationRequest, Operation> deleteConfigurationSettings() {
            return this.deleteConfigurationSettings;
        }

        public OperationCallSettings.Builder<DeleteConfigurationRequest, Empty, OperationMetadata> deleteConfigurationOperationSettings() {
            return this.deleteConfigurationOperationSettings;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, LicenseManagerClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<DeactivateConfigurationRequest, Operation> deactivateConfigurationSettings() {
            return this.deactivateConfigurationSettings;
        }

        public OperationCallSettings.Builder<DeactivateConfigurationRequest, Configuration, OperationMetadata> deactivateConfigurationOperationSettings() {
            return this.deactivateConfigurationOperationSettings;
        }

        public UnaryCallSettings.Builder<ReactivateConfigurationRequest, Operation> reactivateConfigurationSettings() {
            return this.reactivateConfigurationSettings;
        }

        public OperationCallSettings.Builder<ReactivateConfigurationRequest, Configuration, OperationMetadata> reactivateConfigurationOperationSettings() {
            return this.reactivateConfigurationOperationSettings;
        }

        public UnaryCallSettings.Builder<QueryConfigurationLicenseUsageRequest, QueryConfigurationLicenseUsageResponse> queryConfigurationLicenseUsageSettings() {
            return this.queryConfigurationLicenseUsageSettings;
        }

        public PagedCallSettings.Builder<AggregateUsageRequest, AggregateUsageResponse, LicenseManagerClient.AggregateUsagePagedResponse> aggregateUsageSettings() {
            return this.aggregateUsageSettings;
        }

        public PagedCallSettings.Builder<ListProductsRequest, ListProductsResponse, LicenseManagerClient.ListProductsPagedResponse> listProductsSettings() {
            return this.listProductsSettings;
        }

        public UnaryCallSettings.Builder<GetProductRequest, Product> getProductSettings() {
            return this.getProductSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, LicenseManagerClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public LicenseManagerStubSettings build() throws IOException {
            return new LicenseManagerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

