/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.inventory.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.inventory.v1.KeyDashboardServiceClient;
import com.google.cloud.kms.inventory.v1.ListCryptoKeysRequest;
import com.google.cloud.kms.inventory.v1.ListCryptoKeysResponse;
import com.google.cloud.kms.inventory.v1.stub.GrpcKeyDashboardServiceStub;
import com.google.cloud.kms.inventory.v1.stub.HttpJsonKeyDashboardServiceStub;
import com.google.cloud.kms.inventory.v1.stub.KeyDashboardServiceStub;
import com.google.cloud.kms.v1.CryptoKey;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class KeyDashboardServiceStubSettings
extends StubSettings<KeyDashboardServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListCryptoKeysRequest, ListCryptoKeysResponse, KeyDashboardServiceClient.ListCryptoKeysPagedResponse> listCryptoKeysSettings;
    private static final PagedListDescriptor<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey> LIST_CRYPTO_KEYS_PAGE_STR_DESC = new PagedListDescriptor<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey>(){

        public String emptyToken() {
            return "";
        }

        public ListCryptoKeysRequest injectToken(ListCryptoKeysRequest payload, String token) {
            return ListCryptoKeysRequest.newBuilder((ListCryptoKeysRequest)payload).setPageToken(token).build();
        }

        public ListCryptoKeysRequest injectPageSize(ListCryptoKeysRequest payload, int pageSize) {
            return ListCryptoKeysRequest.newBuilder((ListCryptoKeysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCryptoKeysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCryptoKeysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CryptoKey> extractResources(ListCryptoKeysResponse payload) {
            return payload.getCryptoKeysList();
        }
    };
    private static final PagedListResponseFactory<ListCryptoKeysRequest, ListCryptoKeysResponse, KeyDashboardServiceClient.ListCryptoKeysPagedResponse> LIST_CRYPTO_KEYS_PAGE_STR_FACT = new PagedListResponseFactory<ListCryptoKeysRequest, ListCryptoKeysResponse, KeyDashboardServiceClient.ListCryptoKeysPagedResponse>(){

        public ApiFuture<KeyDashboardServiceClient.ListCryptoKeysPagedResponse> getFuturePagedResponse(UnaryCallable<ListCryptoKeysRequest, ListCryptoKeysResponse> callable, ListCryptoKeysRequest request, ApiCallContext context, ApiFuture<ListCryptoKeysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CRYPTO_KEYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return KeyDashboardServiceClient.ListCryptoKeysPagedResponse.createAsync((PageContext<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListCryptoKeysRequest, ListCryptoKeysResponse, KeyDashboardServiceClient.ListCryptoKeysPagedResponse> listCryptoKeysSettings() {
        return this.listCryptoKeysSettings;
    }

    public KeyDashboardServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcKeyDashboardServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonKeyDashboardServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "kmsinventory";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "kmsinventory.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "kmsinventory.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return KeyDashboardServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(KeyDashboardServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(KeyDashboardServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return KeyDashboardServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected KeyDashboardServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listCryptoKeysSettings = settingsBuilder.listCryptoKeysSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<KeyDashboardServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListCryptoKeysRequest, ListCryptoKeysResponse, KeyDashboardServiceClient.ListCryptoKeysPagedResponse> listCryptoKeysSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listCryptoKeysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CRYPTO_KEYS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCryptoKeysSettings);
            Builder.initDefaults(this);
        }

        protected Builder(KeyDashboardServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listCryptoKeysSettings = settings.listCryptoKeysSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCryptoKeysSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(KeyDashboardServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)KeyDashboardServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)KeyDashboardServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(KeyDashboardServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)KeyDashboardServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)KeyDashboardServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)KeyDashboardServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(KeyDashboardServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listCryptoKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListCryptoKeysRequest, ListCryptoKeysResponse, KeyDashboardServiceClient.ListCryptoKeysPagedResponse> listCryptoKeysSettings() {
            return this.listCryptoKeysSettings;
        }

        public KeyDashboardServiceStubSettings build() throws IOException {
            return new KeyDashboardServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

