/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.inventory.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.kms.inventory.v1.GetProtectedResourcesSummaryRequest;
import com.google.cloud.kms.inventory.v1.KeyTrackingServiceSettings;
import com.google.cloud.kms.inventory.v1.OrganizationName;
import com.google.cloud.kms.inventory.v1.ProtectedResource;
import com.google.cloud.kms.inventory.v1.ProtectedResourcesSummary;
import com.google.cloud.kms.inventory.v1.ProtectedResourcesSummaryName;
import com.google.cloud.kms.inventory.v1.SearchProtectedResourcesRequest;
import com.google.cloud.kms.inventory.v1.SearchProtectedResourcesResponse;
import com.google.cloud.kms.inventory.v1.stub.KeyTrackingServiceStub;
import com.google.cloud.kms.inventory.v1.stub.KeyTrackingServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class KeyTrackingServiceClient
implements BackgroundResource {
    private final KeyTrackingServiceSettings settings;
    private final KeyTrackingServiceStub stub;

    public static final KeyTrackingServiceClient create() throws IOException {
        return KeyTrackingServiceClient.create(KeyTrackingServiceSettings.newBuilder().build());
    }

    public static final KeyTrackingServiceClient create(KeyTrackingServiceSettings settings) throws IOException {
        return new KeyTrackingServiceClient(settings);
    }

    public static final KeyTrackingServiceClient create(KeyTrackingServiceStub stub) {
        return new KeyTrackingServiceClient(stub);
    }

    protected KeyTrackingServiceClient(KeyTrackingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((KeyTrackingServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected KeyTrackingServiceClient(KeyTrackingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final KeyTrackingServiceSettings getSettings() {
        return this.settings;
    }

    public KeyTrackingServiceStub getStub() {
        return this.stub;
    }

    public final ProtectedResourcesSummary getProtectedResourcesSummary(ProtectedResourcesSummaryName name) {
        GetProtectedResourcesSummaryRequest request = GetProtectedResourcesSummaryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProtectedResourcesSummary(request);
    }

    public final ProtectedResourcesSummary getProtectedResourcesSummary(String name) {
        GetProtectedResourcesSummaryRequest request = GetProtectedResourcesSummaryRequest.newBuilder().setName(name).build();
        return this.getProtectedResourcesSummary(request);
    }

    public final ProtectedResourcesSummary getProtectedResourcesSummary(GetProtectedResourcesSummaryRequest request) {
        return (ProtectedResourcesSummary)this.getProtectedResourcesSummaryCallable().call((Object)request);
    }

    public final UnaryCallable<GetProtectedResourcesSummaryRequest, ProtectedResourcesSummary> getProtectedResourcesSummaryCallable() {
        return this.stub.getProtectedResourcesSummaryCallable();
    }

    public final SearchProtectedResourcesPagedResponse searchProtectedResources(OrganizationName scope, ResourceName cryptoKey) {
        SearchProtectedResourcesRequest request = SearchProtectedResourcesRequest.newBuilder().setScope(scope == null ? null : scope.toString()).setCryptoKey(cryptoKey == null ? null : cryptoKey.toString()).build();
        return this.searchProtectedResources(request);
    }

    public final SearchProtectedResourcesPagedResponse searchProtectedResources(OrganizationName scope, String cryptoKey) {
        SearchProtectedResourcesRequest request = SearchProtectedResourcesRequest.newBuilder().setScope(scope == null ? null : scope.toString()).setCryptoKey(cryptoKey).build();
        return this.searchProtectedResources(request);
    }

    public final SearchProtectedResourcesPagedResponse searchProtectedResources(String scope, ResourceName cryptoKey) {
        SearchProtectedResourcesRequest request = SearchProtectedResourcesRequest.newBuilder().setScope(scope).setCryptoKey(cryptoKey == null ? null : cryptoKey.toString()).build();
        return this.searchProtectedResources(request);
    }

    public final SearchProtectedResourcesPagedResponse searchProtectedResources(String scope, String cryptoKey) {
        SearchProtectedResourcesRequest request = SearchProtectedResourcesRequest.newBuilder().setScope(scope).setCryptoKey(cryptoKey).build();
        return this.searchProtectedResources(request);
    }

    public final SearchProtectedResourcesPagedResponse searchProtectedResources(SearchProtectedResourcesRequest request) {
        return (SearchProtectedResourcesPagedResponse)((Object)this.searchProtectedResourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchProtectedResourcesRequest, SearchProtectedResourcesPagedResponse> searchProtectedResourcesPagedCallable() {
        return this.stub.searchProtectedResourcesPagedCallable();
    }

    public final UnaryCallable<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse> searchProtectedResourcesCallable() {
        return this.stub.searchProtectedResourcesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchProtectedResourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, ProtectedResource, SearchProtectedResourcesPage, SearchProtectedResourcesFixedSizeCollection> {
        private SearchProtectedResourcesFixedSizeCollection(List<SearchProtectedResourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchProtectedResourcesFixedSizeCollection createEmptyCollection() {
            return new SearchProtectedResourcesFixedSizeCollection(null, 0);
        }

        protected SearchProtectedResourcesFixedSizeCollection createCollection(List<SearchProtectedResourcesPage> pages, int collectionSize) {
            return new SearchProtectedResourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchProtectedResourcesPage
    extends AbstractPage<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, ProtectedResource, SearchProtectedResourcesPage> {
        private SearchProtectedResourcesPage(PageContext<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, ProtectedResource> context, SearchProtectedResourcesResponse response) {
            super(context, (Object)response);
        }

        private static SearchProtectedResourcesPage createEmptyPage() {
            return new SearchProtectedResourcesPage(null, null);
        }

        protected SearchProtectedResourcesPage createPage(PageContext<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, ProtectedResource> context, SearchProtectedResourcesResponse response) {
            return new SearchProtectedResourcesPage(context, response);
        }

        public ApiFuture<SearchProtectedResourcesPage> createPageAsync(PageContext<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, ProtectedResource> context, ApiFuture<SearchProtectedResourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchProtectedResourcesPagedResponse
    extends AbstractPagedListResponse<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, ProtectedResource, SearchProtectedResourcesPage, SearchProtectedResourcesFixedSizeCollection> {
        public static ApiFuture<SearchProtectedResourcesPagedResponse> createAsync(PageContext<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, ProtectedResource> context, ApiFuture<SearchProtectedResourcesResponse> futureResponse) {
            ApiFuture<SearchProtectedResourcesPage> futurePage = SearchProtectedResourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchProtectedResourcesPagedResponse((SearchProtectedResourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchProtectedResourcesPagedResponse(SearchProtectedResourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchProtectedResourcesFixedSizeCollection.createEmptyCollection());
        }
    }
}

