/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.inventory.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.inventory.v1.GetProtectedResourcesSummaryRequest;
import com.google.cloud.kms.inventory.v1.KeyTrackingServiceClient;
import com.google.cloud.kms.inventory.v1.ProtectedResourcesSummary;
import com.google.cloud.kms.inventory.v1.SearchProtectedResourcesRequest;
import com.google.cloud.kms.inventory.v1.SearchProtectedResourcesResponse;
import com.google.cloud.kms.inventory.v1.stub.HttpJsonKeyTrackingServiceCallableFactory;
import com.google.cloud.kms.inventory.v1.stub.KeyTrackingServiceStub;
import com.google.cloud.kms.inventory.v1.stub.KeyTrackingServiceStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonKeyTrackingServiceStub
extends KeyTrackingServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetProtectedResourcesSummaryRequest, ProtectedResourcesSummary> getProtectedResourcesSummaryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.inventory.v1.KeyTrackingService/GetProtectedResourcesSummary").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/**}/protectedResourcesSummary", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ProtectedResourcesSummary.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse> searchProtectedResourcesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.inventory.v1.KeyTrackingService/SearchProtectedResources").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{scope=organizations/*}/protectedResources:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "scope", (Object)request.getScope());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "cryptoKey", (Object)request.getCryptoKey());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "resourceTypes", (Object)request.getResourceTypesList());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchProtectedResourcesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetProtectedResourcesSummaryRequest, ProtectedResourcesSummary> getProtectedResourcesSummaryCallable;
    private final UnaryCallable<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse> searchProtectedResourcesCallable;
    private final UnaryCallable<SearchProtectedResourcesRequest, KeyTrackingServiceClient.SearchProtectedResourcesPagedResponse> searchProtectedResourcesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonKeyTrackingServiceStub create(KeyTrackingServiceStubSettings settings) throws IOException {
        return new HttpJsonKeyTrackingServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonKeyTrackingServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonKeyTrackingServiceStub(KeyTrackingServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonKeyTrackingServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonKeyTrackingServiceStub(KeyTrackingServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonKeyTrackingServiceStub(KeyTrackingServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonKeyTrackingServiceCallableFactory());
    }

    protected HttpJsonKeyTrackingServiceStub(KeyTrackingServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getProtectedResourcesSummaryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getProtectedResourcesSummaryMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings searchProtectedResourcesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchProtectedResourcesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("scope", String.valueOf(request.getScope()));
            return builder.build();
        }).build();
        this.getProtectedResourcesSummaryCallable = callableFactory.createUnaryCallable(getProtectedResourcesSummaryTransportSettings, settings.getProtectedResourcesSummarySettings(), clientContext);
        this.searchProtectedResourcesCallable = callableFactory.createUnaryCallable(searchProtectedResourcesTransportSettings, settings.searchProtectedResourcesSettings(), clientContext);
        this.searchProtectedResourcesPagedCallable = callableFactory.createPagedCallable(searchProtectedResourcesTransportSettings, settings.searchProtectedResourcesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getProtectedResourcesSummaryMethodDescriptor);
        methodDescriptors.add(searchProtectedResourcesMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetProtectedResourcesSummaryRequest, ProtectedResourcesSummary> getProtectedResourcesSummaryCallable() {
        return this.getProtectedResourcesSummaryCallable;
    }

    @Override
    public UnaryCallable<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse> searchProtectedResourcesCallable() {
        return this.searchProtectedResourcesCallable;
    }

    @Override
    public UnaryCallable<SearchProtectedResourcesRequest, KeyTrackingServiceClient.SearchProtectedResourcesPagedResponse> searchProtectedResourcesPagedCallable() {
        return this.searchProtectedResourcesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

