/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.inventory.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.inventory.v1.KeyDashboardServiceSettings;
import com.google.cloud.kms.inventory.v1.ListCryptoKeysRequest;
import com.google.cloud.kms.inventory.v1.ListCryptoKeysResponse;
import com.google.cloud.kms.inventory.v1.ProjectName;
import com.google.cloud.kms.inventory.v1.stub.KeyDashboardServiceStub;
import com.google.cloud.kms.inventory.v1.stub.KeyDashboardServiceStubSettings;
import com.google.cloud.kms.v1.CryptoKey;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class KeyDashboardServiceClient
implements BackgroundResource {
    private final KeyDashboardServiceSettings settings;
    private final KeyDashboardServiceStub stub;

    public static final KeyDashboardServiceClient create() throws IOException {
        return KeyDashboardServiceClient.create(KeyDashboardServiceSettings.newBuilder().build());
    }

    public static final KeyDashboardServiceClient create(KeyDashboardServiceSettings settings) throws IOException {
        return new KeyDashboardServiceClient(settings);
    }

    public static final KeyDashboardServiceClient create(KeyDashboardServiceStub stub) {
        return new KeyDashboardServiceClient(stub);
    }

    protected KeyDashboardServiceClient(KeyDashboardServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((KeyDashboardServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected KeyDashboardServiceClient(KeyDashboardServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final KeyDashboardServiceSettings getSettings() {
        return this.settings;
    }

    public KeyDashboardServiceStub getStub() {
        return this.stub;
    }

    public final ListCryptoKeysPagedResponse listCryptoKeys(ProjectName parent) {
        ListCryptoKeysRequest request = ListCryptoKeysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCryptoKeys(request);
    }

    public final ListCryptoKeysPagedResponse listCryptoKeys(String parent) {
        ListCryptoKeysRequest request = ListCryptoKeysRequest.newBuilder().setParent(parent).build();
        return this.listCryptoKeys(request);
    }

    public final ListCryptoKeysPagedResponse listCryptoKeys(ListCryptoKeysRequest request) {
        return (ListCryptoKeysPagedResponse)((Object)this.listCryptoKeysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCryptoKeysRequest, ListCryptoKeysPagedResponse> listCryptoKeysPagedCallable() {
        return this.stub.listCryptoKeysPagedCallable();
    }

    public final UnaryCallable<ListCryptoKeysRequest, ListCryptoKeysResponse> listCryptoKeysCallable() {
        return this.stub.listCryptoKeysCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCryptoKeysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey, ListCryptoKeysPage, ListCryptoKeysFixedSizeCollection> {
        private ListCryptoKeysFixedSizeCollection(List<ListCryptoKeysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCryptoKeysFixedSizeCollection createEmptyCollection() {
            return new ListCryptoKeysFixedSizeCollection(null, 0);
        }

        protected ListCryptoKeysFixedSizeCollection createCollection(List<ListCryptoKeysPage> pages, int collectionSize) {
            return new ListCryptoKeysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCryptoKeysPage
    extends AbstractPage<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey, ListCryptoKeysPage> {
        private ListCryptoKeysPage(PageContext<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey> context, ListCryptoKeysResponse response) {
            super(context, (Object)response);
        }

        private static ListCryptoKeysPage createEmptyPage() {
            return new ListCryptoKeysPage(null, null);
        }

        protected ListCryptoKeysPage createPage(PageContext<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey> context, ListCryptoKeysResponse response) {
            return new ListCryptoKeysPage(context, response);
        }

        public ApiFuture<ListCryptoKeysPage> createPageAsync(PageContext<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey> context, ApiFuture<ListCryptoKeysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCryptoKeysPagedResponse
    extends AbstractPagedListResponse<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey, ListCryptoKeysPage, ListCryptoKeysFixedSizeCollection> {
        public static ApiFuture<ListCryptoKeysPagedResponse> createAsync(PageContext<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey> context, ApiFuture<ListCryptoKeysResponse> futureResponse) {
            ApiFuture<ListCryptoKeysPage> futurePage = ListCryptoKeysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCryptoKeysPagedResponse((ListCryptoKeysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCryptoKeysPagedResponse(ListCryptoKeysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCryptoKeysFixedSizeCollection.createEmptyCollection());
        }
    }
}

