/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iap.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.iap.v1.CreateTunnelDestGroupRequest;
import com.google.cloud.iap.v1.DeleteTunnelDestGroupRequest;
import com.google.cloud.iap.v1.GetIapSettingsRequest;
import com.google.cloud.iap.v1.GetTunnelDestGroupRequest;
import com.google.cloud.iap.v1.IapSettings;
import com.google.cloud.iap.v1.IdentityAwareProxyAdminServiceClient;
import com.google.cloud.iap.v1.ListTunnelDestGroupsRequest;
import com.google.cloud.iap.v1.ListTunnelDestGroupsResponse;
import com.google.cloud.iap.v1.TunnelDestGroup;
import com.google.cloud.iap.v1.UpdateIapSettingsRequest;
import com.google.cloud.iap.v1.UpdateTunnelDestGroupRequest;
import com.google.cloud.iap.v1.ValidateIapAttributeExpressionRequest;
import com.google.cloud.iap.v1.ValidateIapAttributeExpressionResponse;
import com.google.cloud.iap.v1.stub.GrpcIdentityAwareProxyAdminServiceStub;
import com.google.cloud.iap.v1.stub.HttpJsonIdentityAwareProxyAdminServiceStub;
import com.google.cloud.iap.v1.stub.IdentityAwareProxyAdminServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class IdentityAwareProxyAdminServiceStubSettings
extends StubSettings<IdentityAwareProxyAdminServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<GetIapSettingsRequest, IapSettings> getIapSettingsSettings;
    private final UnaryCallSettings<UpdateIapSettingsRequest, IapSettings> updateIapSettingsSettings;
    private final UnaryCallSettings<ValidateIapAttributeExpressionRequest, ValidateIapAttributeExpressionResponse> validateIapAttributeExpressionSettings;
    private final PagedCallSettings<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, IdentityAwareProxyAdminServiceClient.ListTunnelDestGroupsPagedResponse> listTunnelDestGroupsSettings;
    private final UnaryCallSettings<CreateTunnelDestGroupRequest, TunnelDestGroup> createTunnelDestGroupSettings;
    private final UnaryCallSettings<GetTunnelDestGroupRequest, TunnelDestGroup> getTunnelDestGroupSettings;
    private final UnaryCallSettings<DeleteTunnelDestGroupRequest, Empty> deleteTunnelDestGroupSettings;
    private final UnaryCallSettings<UpdateTunnelDestGroupRequest, TunnelDestGroup> updateTunnelDestGroupSettings;
    private static final PagedListDescriptor<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, TunnelDestGroup> LIST_TUNNEL_DEST_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, TunnelDestGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListTunnelDestGroupsRequest injectToken(ListTunnelDestGroupsRequest payload, String token) {
            return ListTunnelDestGroupsRequest.newBuilder((ListTunnelDestGroupsRequest)payload).setPageToken(token).build();
        }

        public ListTunnelDestGroupsRequest injectPageSize(ListTunnelDestGroupsRequest payload, int pageSize) {
            return ListTunnelDestGroupsRequest.newBuilder((ListTunnelDestGroupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTunnelDestGroupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTunnelDestGroupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TunnelDestGroup> extractResources(ListTunnelDestGroupsResponse payload) {
            return payload.getTunnelDestGroupsList();
        }
    };
    private static final PagedListResponseFactory<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, IdentityAwareProxyAdminServiceClient.ListTunnelDestGroupsPagedResponse> LIST_TUNNEL_DEST_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, IdentityAwareProxyAdminServiceClient.ListTunnelDestGroupsPagedResponse>(){

        public ApiFuture<IdentityAwareProxyAdminServiceClient.ListTunnelDestGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse> callable, ListTunnelDestGroupsRequest request, ApiCallContext context, ApiFuture<ListTunnelDestGroupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TUNNEL_DEST_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IdentityAwareProxyAdminServiceClient.ListTunnelDestGroupsPagedResponse.createAsync((PageContext<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, TunnelDestGroup>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<GetIapSettingsRequest, IapSettings> getIapSettingsSettings() {
        return this.getIapSettingsSettings;
    }

    public UnaryCallSettings<UpdateIapSettingsRequest, IapSettings> updateIapSettingsSettings() {
        return this.updateIapSettingsSettings;
    }

    public UnaryCallSettings<ValidateIapAttributeExpressionRequest, ValidateIapAttributeExpressionResponse> validateIapAttributeExpressionSettings() {
        return this.validateIapAttributeExpressionSettings;
    }

    public PagedCallSettings<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, IdentityAwareProxyAdminServiceClient.ListTunnelDestGroupsPagedResponse> listTunnelDestGroupsSettings() {
        return this.listTunnelDestGroupsSettings;
    }

    public UnaryCallSettings<CreateTunnelDestGroupRequest, TunnelDestGroup> createTunnelDestGroupSettings() {
        return this.createTunnelDestGroupSettings;
    }

    public UnaryCallSettings<GetTunnelDestGroupRequest, TunnelDestGroup> getTunnelDestGroupSettings() {
        return this.getTunnelDestGroupSettings;
    }

    public UnaryCallSettings<DeleteTunnelDestGroupRequest, Empty> deleteTunnelDestGroupSettings() {
        return this.deleteTunnelDestGroupSettings;
    }

    public UnaryCallSettings<UpdateTunnelDestGroupRequest, TunnelDestGroup> updateTunnelDestGroupSettings() {
        return this.updateTunnelDestGroupSettings;
    }

    public IdentityAwareProxyAdminServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcIdentityAwareProxyAdminServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonIdentityAwareProxyAdminServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "iap";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "iap.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "iap.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return IdentityAwareProxyAdminServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IdentityAwareProxyAdminServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IdentityAwareProxyAdminServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return IdentityAwareProxyAdminServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected IdentityAwareProxyAdminServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.getIapSettingsSettings = settingsBuilder.getIapSettingsSettings().build();
        this.updateIapSettingsSettings = settingsBuilder.updateIapSettingsSettings().build();
        this.validateIapAttributeExpressionSettings = settingsBuilder.validateIapAttributeExpressionSettings().build();
        this.listTunnelDestGroupsSettings = settingsBuilder.listTunnelDestGroupsSettings().build();
        this.createTunnelDestGroupSettings = settingsBuilder.createTunnelDestGroupSettings().build();
        this.getTunnelDestGroupSettings = settingsBuilder.getTunnelDestGroupSettings().build();
        this.deleteTunnelDestGroupSettings = settingsBuilder.deleteTunnelDestGroupSettings().build();
        this.updateTunnelDestGroupSettings = settingsBuilder.updateTunnelDestGroupSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<IdentityAwareProxyAdminServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<GetIapSettingsRequest, IapSettings> getIapSettingsSettings;
        private final UnaryCallSettings.Builder<UpdateIapSettingsRequest, IapSettings> updateIapSettingsSettings;
        private final UnaryCallSettings.Builder<ValidateIapAttributeExpressionRequest, ValidateIapAttributeExpressionResponse> validateIapAttributeExpressionSettings;
        private final PagedCallSettings.Builder<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, IdentityAwareProxyAdminServiceClient.ListTunnelDestGroupsPagedResponse> listTunnelDestGroupsSettings;
        private final UnaryCallSettings.Builder<CreateTunnelDestGroupRequest, TunnelDestGroup> createTunnelDestGroupSettings;
        private final UnaryCallSettings.Builder<GetTunnelDestGroupRequest, TunnelDestGroup> getTunnelDestGroupSettings;
        private final UnaryCallSettings.Builder<DeleteTunnelDestGroupRequest, Empty> deleteTunnelDestGroupSettings;
        private final UnaryCallSettings.Builder<UpdateTunnelDestGroupRequest, TunnelDestGroup> updateTunnelDestGroupSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIapSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateIapSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.validateIapAttributeExpressionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTunnelDestGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TUNNEL_DEST_GROUPS_PAGE_STR_FACT);
            this.createTunnelDestGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTunnelDestGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTunnelDestGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTunnelDestGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, this.getIapSettingsSettings, this.updateIapSettingsSettings, this.validateIapAttributeExpressionSettings, this.listTunnelDestGroupsSettings, this.createTunnelDestGroupSettings, this.getTunnelDestGroupSettings, this.deleteTunnelDestGroupSettings, this.updateTunnelDestGroupSettings);
            Builder.initDefaults(this);
        }

        protected Builder(IdentityAwareProxyAdminServiceStubSettings settings) {
            super((StubSettings)settings);
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.getIapSettingsSettings = settings.getIapSettingsSettings.toBuilder();
            this.updateIapSettingsSettings = settings.updateIapSettingsSettings.toBuilder();
            this.validateIapAttributeExpressionSettings = settings.validateIapAttributeExpressionSettings.toBuilder();
            this.listTunnelDestGroupsSettings = settings.listTunnelDestGroupsSettings.toBuilder();
            this.createTunnelDestGroupSettings = settings.createTunnelDestGroupSettings.toBuilder();
            this.getTunnelDestGroupSettings = settings.getTunnelDestGroupSettings.toBuilder();
            this.deleteTunnelDestGroupSettings = settings.deleteTunnelDestGroupSettings.toBuilder();
            this.updateTunnelDestGroupSettings = settings.updateTunnelDestGroupSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, this.getIapSettingsSettings, this.updateIapSettingsSettings, this.validateIapAttributeExpressionSettings, this.listTunnelDestGroupsSettings, this.createTunnelDestGroupSettings, this.getTunnelDestGroupSettings, this.deleteTunnelDestGroupSettings, this.updateTunnelDestGroupSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(IdentityAwareProxyAdminServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)IdentityAwareProxyAdminServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IdentityAwareProxyAdminServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IdentityAwareProxyAdminServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)IdentityAwareProxyAdminServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)IdentityAwareProxyAdminServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IdentityAwareProxyAdminServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IdentityAwareProxyAdminServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getIapSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateIapSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.validateIapAttributeExpressionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listTunnelDestGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createTunnelDestGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getTunnelDestGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteTunnelDestGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateTunnelDestGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<GetIapSettingsRequest, IapSettings> getIapSettingsSettings() {
            return this.getIapSettingsSettings;
        }

        public UnaryCallSettings.Builder<UpdateIapSettingsRequest, IapSettings> updateIapSettingsSettings() {
            return this.updateIapSettingsSettings;
        }

        public UnaryCallSettings.Builder<ValidateIapAttributeExpressionRequest, ValidateIapAttributeExpressionResponse> validateIapAttributeExpressionSettings() {
            return this.validateIapAttributeExpressionSettings;
        }

        public PagedCallSettings.Builder<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, IdentityAwareProxyAdminServiceClient.ListTunnelDestGroupsPagedResponse> listTunnelDestGroupsSettings() {
            return this.listTunnelDestGroupsSettings;
        }

        public UnaryCallSettings.Builder<CreateTunnelDestGroupRequest, TunnelDestGroup> createTunnelDestGroupSettings() {
            return this.createTunnelDestGroupSettings;
        }

        public UnaryCallSettings.Builder<GetTunnelDestGroupRequest, TunnelDestGroup> getTunnelDestGroupSettings() {
            return this.getTunnelDestGroupSettings;
        }

        public UnaryCallSettings.Builder<DeleteTunnelDestGroupRequest, Empty> deleteTunnelDestGroupSettings() {
            return this.deleteTunnelDestGroupSettings;
        }

        public UnaryCallSettings.Builder<UpdateTunnelDestGroupRequest, TunnelDestGroup> updateTunnelDestGroupSettings() {
            return this.updateTunnelDestGroupSettings;
        }

        public IdentityAwareProxyAdminServiceStubSettings build() throws IOException {
            return new IdentityAwareProxyAdminServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

