/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iap.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.iap.v1.CreateTunnelDestGroupRequest;
import com.google.cloud.iap.v1.DeleteTunnelDestGroupRequest;
import com.google.cloud.iap.v1.GetIapSettingsRequest;
import com.google.cloud.iap.v1.GetTunnelDestGroupRequest;
import com.google.cloud.iap.v1.IapSettings;
import com.google.cloud.iap.v1.IdentityAwareProxyAdminServiceSettings;
import com.google.cloud.iap.v1.ListTunnelDestGroupsRequest;
import com.google.cloud.iap.v1.ListTunnelDestGroupsResponse;
import com.google.cloud.iap.v1.TunnelDestGroup;
import com.google.cloud.iap.v1.TunnelDestGroupName;
import com.google.cloud.iap.v1.TunnelLocationName;
import com.google.cloud.iap.v1.UpdateIapSettingsRequest;
import com.google.cloud.iap.v1.UpdateTunnelDestGroupRequest;
import com.google.cloud.iap.v1.ValidateIapAttributeExpressionRequest;
import com.google.cloud.iap.v1.ValidateIapAttributeExpressionResponse;
import com.google.cloud.iap.v1.stub.IdentityAwareProxyAdminServiceStub;
import com.google.cloud.iap.v1.stub.IdentityAwareProxyAdminServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class IdentityAwareProxyAdminServiceClient
implements BackgroundResource {
    private final IdentityAwareProxyAdminServiceSettings settings;
    private final IdentityAwareProxyAdminServiceStub stub;

    public static final IdentityAwareProxyAdminServiceClient create() throws IOException {
        return IdentityAwareProxyAdminServiceClient.create(IdentityAwareProxyAdminServiceSettings.newBuilder().build());
    }

    public static final IdentityAwareProxyAdminServiceClient create(IdentityAwareProxyAdminServiceSettings settings) throws IOException {
        return new IdentityAwareProxyAdminServiceClient(settings);
    }

    public static final IdentityAwareProxyAdminServiceClient create(IdentityAwareProxyAdminServiceStub stub) {
        return new IdentityAwareProxyAdminServiceClient(stub);
    }

    protected IdentityAwareProxyAdminServiceClient(IdentityAwareProxyAdminServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((IdentityAwareProxyAdminServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected IdentityAwareProxyAdminServiceClient(IdentityAwareProxyAdminServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final IdentityAwareProxyAdminServiceSettings getSettings() {
        return this.settings;
    }

    public IdentityAwareProxyAdminServiceStub getStub() {
        return this.stub;
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final IapSettings getIapSettings(GetIapSettingsRequest request) {
        return (IapSettings)this.getIapSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetIapSettingsRequest, IapSettings> getIapSettingsCallable() {
        return this.stub.getIapSettingsCallable();
    }

    public final IapSettings updateIapSettings(UpdateIapSettingsRequest request) {
        return (IapSettings)this.updateIapSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateIapSettingsRequest, IapSettings> updateIapSettingsCallable() {
        return this.stub.updateIapSettingsCallable();
    }

    public final ValidateIapAttributeExpressionResponse validateIapAttributeExpression(ValidateIapAttributeExpressionRequest request) {
        return (ValidateIapAttributeExpressionResponse)this.validateIapAttributeExpressionCallable().call((Object)request);
    }

    public final UnaryCallable<ValidateIapAttributeExpressionRequest, ValidateIapAttributeExpressionResponse> validateIapAttributeExpressionCallable() {
        return this.stub.validateIapAttributeExpressionCallable();
    }

    public final ListTunnelDestGroupsPagedResponse listTunnelDestGroups(TunnelLocationName parent) {
        ListTunnelDestGroupsRequest request = ListTunnelDestGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTunnelDestGroups(request);
    }

    public final ListTunnelDestGroupsPagedResponse listTunnelDestGroups(String parent) {
        ListTunnelDestGroupsRequest request = ListTunnelDestGroupsRequest.newBuilder().setParent(parent).build();
        return this.listTunnelDestGroups(request);
    }

    public final ListTunnelDestGroupsPagedResponse listTunnelDestGroups(ListTunnelDestGroupsRequest request) {
        return (ListTunnelDestGroupsPagedResponse)((Object)this.listTunnelDestGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTunnelDestGroupsRequest, ListTunnelDestGroupsPagedResponse> listTunnelDestGroupsPagedCallable() {
        return this.stub.listTunnelDestGroupsPagedCallable();
    }

    public final UnaryCallable<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse> listTunnelDestGroupsCallable() {
        return this.stub.listTunnelDestGroupsCallable();
    }

    public final TunnelDestGroup createTunnelDestGroup(TunnelLocationName parent, TunnelDestGroup tunnelDestGroup, String tunnelDestGroupId) {
        CreateTunnelDestGroupRequest request = CreateTunnelDestGroupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTunnelDestGroup(tunnelDestGroup).setTunnelDestGroupId(tunnelDestGroupId).build();
        return this.createTunnelDestGroup(request);
    }

    public final TunnelDestGroup createTunnelDestGroup(String parent, TunnelDestGroup tunnelDestGroup, String tunnelDestGroupId) {
        CreateTunnelDestGroupRequest request = CreateTunnelDestGroupRequest.newBuilder().setParent(parent).setTunnelDestGroup(tunnelDestGroup).setTunnelDestGroupId(tunnelDestGroupId).build();
        return this.createTunnelDestGroup(request);
    }

    public final TunnelDestGroup createTunnelDestGroup(CreateTunnelDestGroupRequest request) {
        return (TunnelDestGroup)this.createTunnelDestGroupCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTunnelDestGroupRequest, TunnelDestGroup> createTunnelDestGroupCallable() {
        return this.stub.createTunnelDestGroupCallable();
    }

    public final TunnelDestGroup getTunnelDestGroup(TunnelDestGroupName name) {
        GetTunnelDestGroupRequest request = GetTunnelDestGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTunnelDestGroup(request);
    }

    public final TunnelDestGroup getTunnelDestGroup(String name) {
        GetTunnelDestGroupRequest request = GetTunnelDestGroupRequest.newBuilder().setName(name).build();
        return this.getTunnelDestGroup(request);
    }

    public final TunnelDestGroup getTunnelDestGroup(GetTunnelDestGroupRequest request) {
        return (TunnelDestGroup)this.getTunnelDestGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetTunnelDestGroupRequest, TunnelDestGroup> getTunnelDestGroupCallable() {
        return this.stub.getTunnelDestGroupCallable();
    }

    public final void deleteTunnelDestGroup(TunnelDestGroupName name) {
        DeleteTunnelDestGroupRequest request = DeleteTunnelDestGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTunnelDestGroup(request);
    }

    public final void deleteTunnelDestGroup(String name) {
        DeleteTunnelDestGroupRequest request = DeleteTunnelDestGroupRequest.newBuilder().setName(name).build();
        this.deleteTunnelDestGroup(request);
    }

    public final void deleteTunnelDestGroup(DeleteTunnelDestGroupRequest request) {
        this.deleteTunnelDestGroupCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTunnelDestGroupRequest, Empty> deleteTunnelDestGroupCallable() {
        return this.stub.deleteTunnelDestGroupCallable();
    }

    public final TunnelDestGroup updateTunnelDestGroup(TunnelDestGroup tunnelDestGroup, FieldMask updateMask) {
        UpdateTunnelDestGroupRequest request = UpdateTunnelDestGroupRequest.newBuilder().setTunnelDestGroup(tunnelDestGroup).setUpdateMask(updateMask).build();
        return this.updateTunnelDestGroup(request);
    }

    public final TunnelDestGroup updateTunnelDestGroup(UpdateTunnelDestGroupRequest request) {
        return (TunnelDestGroup)this.updateTunnelDestGroupCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTunnelDestGroupRequest, TunnelDestGroup> updateTunnelDestGroupCallable() {
        return this.stub.updateTunnelDestGroupCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTunnelDestGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, TunnelDestGroup, ListTunnelDestGroupsPage, ListTunnelDestGroupsFixedSizeCollection> {
        private ListTunnelDestGroupsFixedSizeCollection(List<ListTunnelDestGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTunnelDestGroupsFixedSizeCollection createEmptyCollection() {
            return new ListTunnelDestGroupsFixedSizeCollection(null, 0);
        }

        protected ListTunnelDestGroupsFixedSizeCollection createCollection(List<ListTunnelDestGroupsPage> pages, int collectionSize) {
            return new ListTunnelDestGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTunnelDestGroupsPage
    extends AbstractPage<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, TunnelDestGroup, ListTunnelDestGroupsPage> {
        private ListTunnelDestGroupsPage(PageContext<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, TunnelDestGroup> context, ListTunnelDestGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListTunnelDestGroupsPage createEmptyPage() {
            return new ListTunnelDestGroupsPage(null, null);
        }

        protected ListTunnelDestGroupsPage createPage(PageContext<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, TunnelDestGroup> context, ListTunnelDestGroupsResponse response) {
            return new ListTunnelDestGroupsPage(context, response);
        }

        public ApiFuture<ListTunnelDestGroupsPage> createPageAsync(PageContext<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, TunnelDestGroup> context, ApiFuture<ListTunnelDestGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTunnelDestGroupsPagedResponse
    extends AbstractPagedListResponse<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, TunnelDestGroup, ListTunnelDestGroupsPage, ListTunnelDestGroupsFixedSizeCollection> {
        public static ApiFuture<ListTunnelDestGroupsPagedResponse> createAsync(PageContext<ListTunnelDestGroupsRequest, ListTunnelDestGroupsResponse, TunnelDestGroup> context, ApiFuture<ListTunnelDestGroupsResponse> futureResponse) {
            ApiFuture<ListTunnelDestGroupsPage> futurePage = ListTunnelDestGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTunnelDestGroupsPagedResponse((ListTunnelDestGroupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTunnelDestGroupsPagedResponse(ListTunnelDestGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTunnelDestGroupsFixedSizeCollection.createEmptyCollection());
        }
    }
}

