/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iap.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.iap.v1.Brand;
import com.google.cloud.iap.v1.CreateBrandRequest;
import com.google.cloud.iap.v1.CreateIdentityAwareProxyClientRequest;
import com.google.cloud.iap.v1.DeleteIdentityAwareProxyClientRequest;
import com.google.cloud.iap.v1.GetBrandRequest;
import com.google.cloud.iap.v1.GetIdentityAwareProxyClientRequest;
import com.google.cloud.iap.v1.IdentityAwareProxyClient;
import com.google.cloud.iap.v1.IdentityAwareProxyOAuthServiceClient;
import com.google.cloud.iap.v1.ListBrandsRequest;
import com.google.cloud.iap.v1.ListBrandsResponse;
import com.google.cloud.iap.v1.ListIdentityAwareProxyClientsRequest;
import com.google.cloud.iap.v1.ListIdentityAwareProxyClientsResponse;
import com.google.cloud.iap.v1.ResetIdentityAwareProxyClientSecretRequest;
import com.google.cloud.iap.v1.stub.GrpcIdentityAwareProxyOAuthServiceStub;
import com.google.cloud.iap.v1.stub.HttpJsonIdentityAwareProxyOAuthServiceStub;
import com.google.cloud.iap.v1.stub.IdentityAwareProxyOAuthServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class IdentityAwareProxyOAuthServiceStubSettings
extends StubSettings<IdentityAwareProxyOAuthServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ListBrandsRequest, ListBrandsResponse> listBrandsSettings;
    private final UnaryCallSettings<CreateBrandRequest, Brand> createBrandSettings;
    private final UnaryCallSettings<GetBrandRequest, Brand> getBrandSettings;
    private final UnaryCallSettings<CreateIdentityAwareProxyClientRequest, IdentityAwareProxyClient> createIdentityAwareProxyClientSettings;
    private final PagedCallSettings<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse, IdentityAwareProxyOAuthServiceClient.ListIdentityAwareProxyClientsPagedResponse> listIdentityAwareProxyClientsSettings;
    private final UnaryCallSettings<GetIdentityAwareProxyClientRequest, IdentityAwareProxyClient> getIdentityAwareProxyClientSettings;
    private final UnaryCallSettings<ResetIdentityAwareProxyClientSecretRequest, IdentityAwareProxyClient> resetIdentityAwareProxyClientSecretSettings;
    private final UnaryCallSettings<DeleteIdentityAwareProxyClientRequest, Empty> deleteIdentityAwareProxyClientSettings;
    private static final PagedListDescriptor<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse, IdentityAwareProxyClient> LIST_IDENTITY_AWARE_PROXY_CLIENTS_PAGE_STR_DESC = new PagedListDescriptor<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse, IdentityAwareProxyClient>(){

        public String emptyToken() {
            return "";
        }

        public ListIdentityAwareProxyClientsRequest injectToken(ListIdentityAwareProxyClientsRequest payload, String token) {
            return ListIdentityAwareProxyClientsRequest.newBuilder((ListIdentityAwareProxyClientsRequest)payload).setPageToken(token).build();
        }

        public ListIdentityAwareProxyClientsRequest injectPageSize(ListIdentityAwareProxyClientsRequest payload, int pageSize) {
            return ListIdentityAwareProxyClientsRequest.newBuilder((ListIdentityAwareProxyClientsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListIdentityAwareProxyClientsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListIdentityAwareProxyClientsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<IdentityAwareProxyClient> extractResources(ListIdentityAwareProxyClientsResponse payload) {
            return payload.getIdentityAwareProxyClientsList();
        }
    };
    private static final PagedListResponseFactory<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse, IdentityAwareProxyOAuthServiceClient.ListIdentityAwareProxyClientsPagedResponse> LIST_IDENTITY_AWARE_PROXY_CLIENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse, IdentityAwareProxyOAuthServiceClient.ListIdentityAwareProxyClientsPagedResponse>(){

        public ApiFuture<IdentityAwareProxyOAuthServiceClient.ListIdentityAwareProxyClientsPagedResponse> getFuturePagedResponse(UnaryCallable<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse> callable, ListIdentityAwareProxyClientsRequest request, ApiCallContext context, ApiFuture<ListIdentityAwareProxyClientsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_IDENTITY_AWARE_PROXY_CLIENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IdentityAwareProxyOAuthServiceClient.ListIdentityAwareProxyClientsPagedResponse.createAsync((PageContext<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse, IdentityAwareProxyClient>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<ListBrandsRequest, ListBrandsResponse> listBrandsSettings() {
        return this.listBrandsSettings;
    }

    public UnaryCallSettings<CreateBrandRequest, Brand> createBrandSettings() {
        return this.createBrandSettings;
    }

    public UnaryCallSettings<GetBrandRequest, Brand> getBrandSettings() {
        return this.getBrandSettings;
    }

    public UnaryCallSettings<CreateIdentityAwareProxyClientRequest, IdentityAwareProxyClient> createIdentityAwareProxyClientSettings() {
        return this.createIdentityAwareProxyClientSettings;
    }

    public PagedCallSettings<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse, IdentityAwareProxyOAuthServiceClient.ListIdentityAwareProxyClientsPagedResponse> listIdentityAwareProxyClientsSettings() {
        return this.listIdentityAwareProxyClientsSettings;
    }

    public UnaryCallSettings<GetIdentityAwareProxyClientRequest, IdentityAwareProxyClient> getIdentityAwareProxyClientSettings() {
        return this.getIdentityAwareProxyClientSettings;
    }

    public UnaryCallSettings<ResetIdentityAwareProxyClientSecretRequest, IdentityAwareProxyClient> resetIdentityAwareProxyClientSecretSettings() {
        return this.resetIdentityAwareProxyClientSecretSettings;
    }

    public UnaryCallSettings<DeleteIdentityAwareProxyClientRequest, Empty> deleteIdentityAwareProxyClientSettings() {
        return this.deleteIdentityAwareProxyClientSettings;
    }

    public IdentityAwareProxyOAuthServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcIdentityAwareProxyOAuthServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonIdentityAwareProxyOAuthServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "iap";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "iap.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "iap.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return IdentityAwareProxyOAuthServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IdentityAwareProxyOAuthServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IdentityAwareProxyOAuthServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return IdentityAwareProxyOAuthServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected IdentityAwareProxyOAuthServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listBrandsSettings = settingsBuilder.listBrandsSettings().build();
        this.createBrandSettings = settingsBuilder.createBrandSettings().build();
        this.getBrandSettings = settingsBuilder.getBrandSettings().build();
        this.createIdentityAwareProxyClientSettings = settingsBuilder.createIdentityAwareProxyClientSettings().build();
        this.listIdentityAwareProxyClientsSettings = settingsBuilder.listIdentityAwareProxyClientsSettings().build();
        this.getIdentityAwareProxyClientSettings = settingsBuilder.getIdentityAwareProxyClientSettings().build();
        this.resetIdentityAwareProxyClientSecretSettings = settingsBuilder.resetIdentityAwareProxyClientSecretSettings().build();
        this.deleteIdentityAwareProxyClientSettings = settingsBuilder.deleteIdentityAwareProxyClientSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<IdentityAwareProxyOAuthServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ListBrandsRequest, ListBrandsResponse> listBrandsSettings;
        private final UnaryCallSettings.Builder<CreateBrandRequest, Brand> createBrandSettings;
        private final UnaryCallSettings.Builder<GetBrandRequest, Brand> getBrandSettings;
        private final UnaryCallSettings.Builder<CreateIdentityAwareProxyClientRequest, IdentityAwareProxyClient> createIdentityAwareProxyClientSettings;
        private final PagedCallSettings.Builder<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse, IdentityAwareProxyOAuthServiceClient.ListIdentityAwareProxyClientsPagedResponse> listIdentityAwareProxyClientsSettings;
        private final UnaryCallSettings.Builder<GetIdentityAwareProxyClientRequest, IdentityAwareProxyClient> getIdentityAwareProxyClientSettings;
        private final UnaryCallSettings.Builder<ResetIdentityAwareProxyClientSecretRequest, IdentityAwareProxyClient> resetIdentityAwareProxyClientSecretSettings;
        private final UnaryCallSettings.Builder<DeleteIdentityAwareProxyClientRequest, Empty> deleteIdentityAwareProxyClientSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listBrandsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBrandSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getBrandSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createIdentityAwareProxyClientSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listIdentityAwareProxyClientsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_IDENTITY_AWARE_PROXY_CLIENTS_PAGE_STR_FACT);
            this.getIdentityAwareProxyClientSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resetIdentityAwareProxyClientSecretSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteIdentityAwareProxyClientSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listBrandsSettings, this.createBrandSettings, this.getBrandSettings, this.createIdentityAwareProxyClientSettings, this.listIdentityAwareProxyClientsSettings, this.getIdentityAwareProxyClientSettings, this.resetIdentityAwareProxyClientSecretSettings, this.deleteIdentityAwareProxyClientSettings);
            Builder.initDefaults(this);
        }

        protected Builder(IdentityAwareProxyOAuthServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listBrandsSettings = settings.listBrandsSettings.toBuilder();
            this.createBrandSettings = settings.createBrandSettings.toBuilder();
            this.getBrandSettings = settings.getBrandSettings.toBuilder();
            this.createIdentityAwareProxyClientSettings = settings.createIdentityAwareProxyClientSettings.toBuilder();
            this.listIdentityAwareProxyClientsSettings = settings.listIdentityAwareProxyClientsSettings.toBuilder();
            this.getIdentityAwareProxyClientSettings = settings.getIdentityAwareProxyClientSettings.toBuilder();
            this.resetIdentityAwareProxyClientSecretSettings = settings.resetIdentityAwareProxyClientSecretSettings.toBuilder();
            this.deleteIdentityAwareProxyClientSettings = settings.deleteIdentityAwareProxyClientSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listBrandsSettings, this.createBrandSettings, this.getBrandSettings, this.createIdentityAwareProxyClientSettings, this.listIdentityAwareProxyClientsSettings, this.getIdentityAwareProxyClientSettings, this.resetIdentityAwareProxyClientSecretSettings, this.deleteIdentityAwareProxyClientSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(IdentityAwareProxyOAuthServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)IdentityAwareProxyOAuthServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IdentityAwareProxyOAuthServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IdentityAwareProxyOAuthServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)IdentityAwareProxyOAuthServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)IdentityAwareProxyOAuthServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IdentityAwareProxyOAuthServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IdentityAwareProxyOAuthServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listBrandsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createBrandSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getBrandSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createIdentityAwareProxyClientSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listIdentityAwareProxyClientsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getIdentityAwareProxyClientSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.resetIdentityAwareProxyClientSecretSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteIdentityAwareProxyClientSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ListBrandsRequest, ListBrandsResponse> listBrandsSettings() {
            return this.listBrandsSettings;
        }

        public UnaryCallSettings.Builder<CreateBrandRequest, Brand> createBrandSettings() {
            return this.createBrandSettings;
        }

        public UnaryCallSettings.Builder<GetBrandRequest, Brand> getBrandSettings() {
            return this.getBrandSettings;
        }

        public UnaryCallSettings.Builder<CreateIdentityAwareProxyClientRequest, IdentityAwareProxyClient> createIdentityAwareProxyClientSettings() {
            return this.createIdentityAwareProxyClientSettings;
        }

        public PagedCallSettings.Builder<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse, IdentityAwareProxyOAuthServiceClient.ListIdentityAwareProxyClientsPagedResponse> listIdentityAwareProxyClientsSettings() {
            return this.listIdentityAwareProxyClientsSettings;
        }

        public UnaryCallSettings.Builder<GetIdentityAwareProxyClientRequest, IdentityAwareProxyClient> getIdentityAwareProxyClientSettings() {
            return this.getIdentityAwareProxyClientSettings;
        }

        public UnaryCallSettings.Builder<ResetIdentityAwareProxyClientSecretRequest, IdentityAwareProxyClient> resetIdentityAwareProxyClientSecretSettings() {
            return this.resetIdentityAwareProxyClientSecretSettings;
        }

        public UnaryCallSettings.Builder<DeleteIdentityAwareProxyClientRequest, Empty> deleteIdentityAwareProxyClientSettings() {
            return this.deleteIdentityAwareProxyClientSettings;
        }

        public IdentityAwareProxyOAuthServiceStubSettings build() throws IOException {
            return new IdentityAwareProxyOAuthServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

