/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hypercomputecluster.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.hypercomputecluster.v1beta.Cluster;
import com.google.cloud.hypercomputecluster.v1beta.CreateClusterRequest;
import com.google.cloud.hypercomputecluster.v1beta.DeleteClusterRequest;
import com.google.cloud.hypercomputecluster.v1beta.GetClusterRequest;
import com.google.cloud.hypercomputecluster.v1beta.HypercomputeClusterClient;
import com.google.cloud.hypercomputecluster.v1beta.ListClustersRequest;
import com.google.cloud.hypercomputecluster.v1beta.ListClustersResponse;
import com.google.cloud.hypercomputecluster.v1beta.OperationMetadata;
import com.google.cloud.hypercomputecluster.v1beta.UpdateClusterRequest;
import com.google.cloud.hypercomputecluster.v1beta.stub.GrpcHypercomputeClusterCallableFactory;
import com.google.cloud.hypercomputecluster.v1beta.stub.HypercomputeClusterStub;
import com.google.cloud.hypercomputecluster.v1beta.stub.HypercomputeClusterStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcHypercomputeClusterStub
extends HypercomputeClusterStub {
    private static final MethodDescriptor<ListClustersRequest, ListClustersResponse> listClustersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.hypercomputecluster.v1beta.HypercomputeCluster/ListClusters").setRequestMarshaller(ProtoUtils.marshaller((Message)ListClustersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListClustersResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetClusterRequest, Cluster> getClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.hypercomputecluster.v1beta.HypercomputeCluster/GetCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)GetClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Cluster.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateClusterRequest, Operation> createClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.hypercomputecluster.v1beta.HypercomputeCluster/CreateCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateClusterRequest, Operation> updateClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.hypercomputecluster.v1beta.HypercomputeCluster/UpdateCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteClusterRequest, Operation> deleteClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.hypercomputecluster.v1beta.HypercomputeCluster/DeleteCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable;
    private final UnaryCallable<ListClustersRequest, HypercomputeClusterClient.ListClustersPagedResponse> listClustersPagedCallable;
    private final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable;
    private final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable;
    private final OperationCallable<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationCallable;
    private final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable;
    private final OperationCallable<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationCallable;
    private final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable;
    private final OperationCallable<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, HypercomputeClusterClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcHypercomputeClusterStub create(HypercomputeClusterStubSettings settings) throws IOException {
        return new GrpcHypercomputeClusterStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcHypercomputeClusterStub create(ClientContext clientContext) throws IOException {
        return new GrpcHypercomputeClusterStub(HypercomputeClusterStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcHypercomputeClusterStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcHypercomputeClusterStub(HypercomputeClusterStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcHypercomputeClusterStub(HypercomputeClusterStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcHypercomputeClusterCallableFactory());
    }

    protected GrpcHypercomputeClusterStub(HypercomputeClusterStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listClustersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listClustersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getClusterMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createClusterMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateClusterMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("cluster.name", String.valueOf(request.getCluster().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteClusterMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listClustersCallable = callableFactory.createUnaryCallable(listClustersTransportSettings, settings.listClustersSettings(), clientContext);
        this.listClustersPagedCallable = callableFactory.createPagedCallable(listClustersTransportSettings, settings.listClustersSettings(), clientContext);
        this.getClusterCallable = callableFactory.createUnaryCallable(getClusterTransportSettings, settings.getClusterSettings(), clientContext);
        this.createClusterCallable = callableFactory.createUnaryCallable(createClusterTransportSettings, settings.createClusterSettings(), clientContext);
        this.createClusterOperationCallable = callableFactory.createOperationCallable(createClusterTransportSettings, settings.createClusterOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateClusterCallable = callableFactory.createUnaryCallable(updateClusterTransportSettings, settings.updateClusterSettings(), clientContext);
        this.updateClusterOperationCallable = callableFactory.createOperationCallable(updateClusterTransportSettings, settings.updateClusterOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteClusterCallable = callableFactory.createUnaryCallable(deleteClusterTransportSettings, settings.deleteClusterSettings(), clientContext);
        this.deleteClusterOperationCallable = callableFactory.createOperationCallable(deleteClusterTransportSettings, settings.deleteClusterOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.listClustersCallable;
    }

    @Override
    public UnaryCallable<ListClustersRequest, HypercomputeClusterClient.ListClustersPagedResponse> listClustersPagedCallable() {
        return this.listClustersPagedCallable;
    }

    @Override
    public UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.getClusterCallable;
    }

    @Override
    public UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.createClusterCallable;
    }

    @Override
    public OperationCallable<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationCallable() {
        return this.createClusterOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.updateClusterCallable;
    }

    @Override
    public OperationCallable<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationCallable() {
        return this.updateClusterOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.deleteClusterCallable;
    }

    @Override
    public OperationCallable<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationCallable() {
        return this.deleteClusterOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, HypercomputeClusterClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

